/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import net.kaneka.planttech2.fluids.capability.BiomassFluidEnergy;
import net.kaneka.planttech2.fluids.capability.IBiomassFluidEnergy;
import net.kaneka.planttech2.items.BiomassContainerItem;
import net.kaneka.planttech2.registries.ModItems;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;

public abstract class EnergyInventoryFluidTileEntity
extends EnergyInventoryTileEntity {
    protected final IBiomassFluidEnergy BIOMASS_CAP = BiomassFluidEnergy.getTECap(this);

    public EnergyInventoryFluidTileEntity(TileEntityType<?> type, int energyStorage, int invSize, int maxBiomassStorage, int tier) {
        super(type, energyStorage, invSize, tier);
        this.BIOMASS_CAP.setMaxStorage(maxBiomassStorage);
        this.BIOMASS_CAP.setCurrentStorage(0);
    }

    public void doFluidLoop() {
        ItemStack stack = this.itemhandler.getStackInSlot(this.getFluidInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getFluidOutSlot());
        if (this.BIOMASS_CAP.getCurrentStorage() < this.BIOMASS_CAP.getMaxStorage()) {
            if (stack.func_77973_b() instanceof BiomassContainerItem) {
                this.BIOMASS_CAP.changeCurrentStorage(BiomassContainerItem.extractBiomass(stack, 1));
            } else if (stack.func_77973_b() == ModItems.BIOMASS_BUCKET) {
                stack.func_190918_g(1);
                this.itemhandler.setStackInSlot(this.getFluidInSlot(), new ItemStack((IItemProvider)Items.field_151133_ar));
                this.BIOMASS_CAP.recieveBiomass(3000);
            }
        }
        if (stack2.func_77973_b() instanceof BiomassContainerItem) {
            for (int i = 4; i > 1; --i) {
                if (BiomassContainerItem.getCapacity() - BiomassContainerItem.getCurrentStorage(stack2) < i || this.BIOMASS_CAP.getCurrentStorage() < i) continue;
                BiomassContainerItem.receiveBiomass(stack2, this.BIOMASS_CAP.extractBiomass(i));
                break;
            }
        } else if (stack2.func_77973_b() == Items.field_151133_ar && this.BIOMASS_CAP.getCurrentStorage() >= 3000) {
            stack2.func_190918_g(1);
            this.itemhandler.setStackInSlot(this.getFluidOutSlot(), new ItemStack((IItemProvider)ModItems.BIOMASS_BUCKET));
            this.BIOMASS_CAP.extractBiomass(3000);
        }
    }

    protected abstract int getFluidInSlot();

    protected abstract int getFluidOutSlot();
}

