/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.ModBlocks;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.ItemAnalyser;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.kaneka.planttech2.property.PropertyCrop;
import net.kaneka.planttech2.tileentity.TileEntityCrops;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCropBase
extends BlockContainer {
    public static final PropertyInteger GROWSTATE = PropertyInteger.func_177719_a((String)"growstate", (int)0, (int)7);
    public static final PropertyCrop PLANTTYPE = new PropertyCrop("planttype", PlantTechMain.instance.croplist);
    private String name = "crop";

    public BlockCropBase() {
        super(Material.field_151577_b);
        this.func_149647_a(PlantTechMain.tabmain);
        this.func_149663_c(this.name);
        this.setRegistryName(this.name);
    }

    public void registerItemModel(Item itemBlock) {
        PlantTechMain.proxy.registerItemRenderer(itemBlock, 0, this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase cropStateMapper = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                CropListEntry property = (CropListEntry)state.func_177229_b((IProperty)PLANTTYPE);
                return new ModelResourceLocation(property.getModelResourceLocation(), ((Integer)state.func_177229_b((IProperty)GROWSTATE)).toString());
            }
        };
        ModelLoader.setCustomStateMapper((Block)ModBlocks.CROP, (IStateMapper)cropStateMapper);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrops();
    }

    public void updateCrop(World world, BlockPos pos, HashMapCropTraits traits) {
        block3: {
            block2: {
                IBlockState state = world.func_180495_p(pos);
                int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
                if (growstate >= 7) break block2;
                if (!this.canGrow(world, pos, traits)) break block3;
                world.func_175656_a(pos, state.func_177226_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(Integer.valueOf(growstate) + 1)).func_177226_a((IProperty)PLANTTYPE, (Comparable)PlantTechMain.instance.croplist.getEntryByName(traits.getType())));
                break block3;
            }
            List<BlockPos> neighborpos = this.getNeighborBlockPosRandom(pos);
            for (BlockPos blockpos : neighborpos) {
                if (world.func_180495_p(blockpos).func_177230_c() != ModBlocks.CROPBARS) continue;
                List<BlockPos> cropbarneighbors = this.getNeighborBlockPosRandomExeptOne(blockpos, pos);
                for (BlockPos possiblePartner : cropbarneighbors) {
                    if (world.func_180495_p(possiblePartner).func_177230_c() != ModBlocks.CROP || !(world.func_175625_s(possiblePartner) instanceof TileEntityCrops)) continue;
                    HashMapCropTraits partnertraits = ((TileEntityCrops)world.func_175625_s(possiblePartner)).getTraits();
                    world.func_175656_a(blockpos, ModBlocks.CROP.func_176223_P());
                    if (!(world.func_175625_s(blockpos) instanceof TileEntityCrops) || !(world.func_175625_s(pos) instanceof TileEntityCrops)) continue;
                    ((TileEntityCrops)world.func_175625_s(blockpos)).setTraits(((TileEntityCrops)world.func_175625_s(pos)).getTraits().calculateNewTraits(partnertraits));
                    break;
                }
                if (world.func_180495_p(blockpos).func_177230_c() == ModBlocks.CROP) break;
                world.func_175656_a(blockpos, ModBlocks.CROP.func_176223_P());
                if (!(world.func_175625_s(blockpos) instanceof TileEntityCrops) || !(world.func_175625_s(pos) instanceof TileEntityCrops)) break;
                ((TileEntityCrops)world.func_175625_s(blockpos)).setTraits(((TileEntityCrops)world.func_175625_s(pos)).getTraits().copy());
                break;
            }
        }
    }

    private List<BlockPos> getNeighborBlockPosRandom(BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177976_e());
        Collections.shuffle(neighbors);
        return neighbors;
    }

    private List<BlockPos> getNeighborBlockPosRandomExeptOne(BlockPos pos, BlockPos exept) {
        List<BlockPos> neighbors = this.getNeighborBlockPosRandom(pos);
        neighbors.remove(exept);
        return neighbors;
    }

    private boolean canGrow(World world, BlockPos pos, HashMapCropTraits traits) {
        if (!this.enoughtLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
            return false;
        }
        if (!this.enoughtWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
            return false;
        }
        if (!this.rightSoil(world, pos, traits.getType())) {
            return false;
        }
        return this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE));
    }

    public String[] canGrowString(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        String[] messages = new String[10];
        if (te instanceof TileEntityCrops) {
            HashMapCropTraits traits = ((TileEntityCrops)te).getTraits();
            if (!this.enoughtLight(world, pos, traits.getTrait(EnumTraitsInt.LIGHTSENSITIVITY))) {
                messages[1] = "Not enought light";
            }
            if (!this.enoughtWater(world, pos, traits.getTrait(EnumTraitsInt.WATERSENSITIVITY))) {
                messages[2] = "Not enought water";
            }
            if (!this.rightSoil(world, pos, traits.getType())) {
                messages[3] = "Not right soil";
            }
            if (!this.rightTemperature(world, pos, traits.getType(), traits.getTrait(EnumTraitsInt.TEMPERATURETOLERANCE))) {
                messages[4] = "Not right temperature";
            }
        } else {
            messages[0] = "error";
        }
        return messages;
    }

    public boolean enoughtLight(World world, BlockPos pos, int lightsensitivity) {
        if (!world.func_175697_a(pos, 1)) {
            return false;
        }
        return world.func_175671_l(pos) >= 14 - lightsensitivity;
    }

    public boolean enoughtWater(World world, BlockPos pos, int waterSensitivity) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1 * (waterSensitivity + 1), 0, -1 * (waterSensitivity + 1)), (BlockPos)pos.func_177982_a(waterSensitivity + 1, -1, waterSensitivity + 1))) {
            if (world.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public boolean rightSoil(World world, BlockPos pos, String name) {
        ItemStack stack = PlantTechMain.instance.croplist.getEntryByName(name).getSoil();
        if (stack.func_190926_b()) {
            return true;
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            return state.func_177230_c() == block && block.func_176203_a(stack.func_77960_j()) == state;
        }
        return false;
    }

    public boolean rightTemperature(World world, BlockPos pos, String name, int tolerance) {
        EnumTemperature temp = PlantTechMain.instance.croplist.getEntryByName(name).getTemperature();
        return temp.inRange(world.func_180494_b(pos).func_185353_n(), tolerance);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLANTTYPE, GROWSTATE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)GROWSTATE, (Comparable)((Integer)state.func_177229_b((IProperty)GROWSTATE))).func_177226_a((IProperty)PLANTTYPE, (Comparable)PlantTechMain.instance.croplist.getEntryByName(((TileEntityCrops)worldIn.func_175625_s(pos)).getCropType()));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)GROWSTATE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(meta));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCrops) {
            ((TileEntityCrops)te).addDrops(drops, growstate);
            drops.add((Object)new ItemStack((Block)ModBlocks.CROPBARS));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int growstate = (Integer)state.func_177229_b((IProperty)GROWSTATE);
        if (growstate > 6 && hand.equals((Object)EnumHand.MAIN_HAND) && !worldIn.field_72995_K) {
            ItemStack holdItem = playerIn.func_184586_b(EnumHand.MAIN_HAND);
            if (!holdItem.func_190926_b() && holdItem.func_77973_b() instanceof ItemAnalyser) {
                return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
            }
            NonNullList drops = NonNullList.func_191196_a();
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof TileEntityCrops) {
                ((TileEntityCrops)te).dropsRemoveOneSeed((NonNullList<ItemStack>)drops, growstate);
                for (ItemStack stack : drops) {
                    BlockCropBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
                }
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)GROWSTATE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)PLANTTYPE, (Comparable)PlantTechMain.instance.croplist.getEntryByName(((TileEntityCrops)te).getCropType())));
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState iBlockState) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState iBlockState) {
        return false;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }
}

