/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.blocks.machines;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.blocks.BlockBase;
import net.kaneka.planttech2.blocks.ModBlocks;
import net.kaneka.planttech2.items.ModItems;
import net.kaneka.planttech2.tileentity.cable.TileEntityCable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCable
extends BlockBase {
    public static final IUnlistedProperty<Integer> UP = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"up", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> NORTH = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"north", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> WEST = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"west", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> SOUTH = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"south", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> EAST = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"east", (int)0, (int)4));
    public static final IUnlistedProperty<Integer> DOWN = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"down", (int)0, (int)4));
    protected static final AxisAlignedBB[] AABB_CONNECTIONS = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625), new AxisAlignedBB(0.375, 0.875, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.125), new AxisAlignedBB(0.375, 0.375, 0.875, 0.625, 0.625, 1.0), new AxisAlignedBB(0.0, 0.375, 0.375, 0.125, 0.625, 0.625), new AxisAlignedBB(0.875, 0.375, 0.375, 1.0, 0.625, 0.625)};

    public BlockCable() {
        super(Material.field_151573_f, "cable", PlantTechMain.tabmachines);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation("planttech2:cable");
            }
        };
        ModelLoader.setCustomStateMapper((Block)ModBlocks.CABLE, (IStateMapper)ignoreState);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCable te;
        Integer result;
        if (!worldIn.field_72995_K && hand.equals((Object)EnumHand.MAIN_HAND) && playerIn.func_184614_ca().func_77973_b().equals((Object)ModItems.WRENCH) && (result = Integer.valueOf(this.getConnectionLookedOn(worldIn, pos, playerIn.func_174791_d().func_72441_c(0.0, (double)playerIn.eyeHeight, 0.0), playerIn.func_174791_d().func_72441_c(0.0, (double)playerIn.eyeHeight, 0.0).func_178787_e(playerIn.func_70040_Z().func_186678_a(5.0))))) != -1 && (te = this.getTECable(worldIn, pos)) != null) {
            te.rotateConnection(result);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.CABLE);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.CABLE);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityCable te = this.getTECable(worldIn, pos);
        if (te != null) {
            te.initCable(state);
        }
    }

    public boolean func_149716_u() {
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCable();
    }

    @Override
    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    @Override
    public void registerItemModel(Item itemBlock) {
        PlantTechMain.proxy.registerItemRenderer(itemBlock, 0, "cable");
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCable) {
            ((TileEntityCable)te).deleteCable();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.getBB(state, worldIn, pos);
    }

    public int getConnectionLookedOn(World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        HashMap<Integer, AxisAlignedBB> boxes = this.getCollisionBoxListConnectionsList(worldIn, pos);
        HashMap<Integer, RayTraceResult> rayTraces = this.rayTraceList(pos, start, end, boxes);
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        int returnval = -1;
        for (Map.Entry<Integer, RayTraceResult> entry : rayTraces.entrySet()) {
            double d0 = entry.getValue().field_72307_f.func_72436_e(end);
            if (!(d0 > d1)) continue;
            raytraceresult1 = entry.getValue();
            d1 = d0;
            returnval = entry.getKey();
        }
        return returnval;
    }

    private HashMap<Integer, AxisAlignedBB> getCollisionBoxListConnectionsList(World world, BlockPos pos) {
        HashMap<Integer, AxisAlignedBB> list = new HashMap<Integer, AxisAlignedBB>();
        TileEntityCable te = this.getTECable(world, pos);
        if (te != null) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (te.getConnection(facing) <= 1) continue;
                list.put(facing.func_176745_a(), AABB_CONNECTIONS[facing.func_176745_a()]);
            }
        }
        return list;
    }

    @Nullable
    protected HashMap<Integer, RayTraceResult> rayTraceList(BlockPos pos, Vec3d start, Vec3d end, HashMap<Integer, AxisAlignedBB> boxes) {
        HashMap<Integer, RayTraceResult> list = new HashMap<Integer, RayTraceResult>();
        boxes.forEach((k, v) -> {
            Vec3d vec3d1;
            Vec3d vec3d = start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            RayTraceResult raytraceresult = v.func_72327_a(vec3d, vec3d1 = end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
            if (raytraceresult != null) {
                list.put((Integer)k, new RayTraceResult(raytraceresult.field_72307_f.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), raytraceresult.field_178784_b, pos));
            }
        });
        return list;
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{UP, DOWN, EAST, WEST, NORTH, SOUTH};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityCable) {
                TileEntityCable tec = (TileEntityCable)te;
                return extState.withProperty(UP, (Object)((TileEntityCable)te).getConnection(EnumFacing.UP)).withProperty(DOWN, (Object)((TileEntityCable)te).getConnection(EnumFacing.DOWN)).withProperty(EAST, (Object)((TileEntityCable)te).getConnection(EnumFacing.EAST)).withProperty(WEST, (Object)((TileEntityCable)te).getConnection(EnumFacing.WEST)).withProperty(NORTH, (Object)((TileEntityCable)te).getConnection(EnumFacing.NORTH)).withProperty(SOUTH, (Object)((TileEntityCable)te).getConnection(EnumFacing.SOUTH));
            }
        }
        return state;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing neighborfacing = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!pos.func_177972_a(facing).equals((Object)fromPos)) continue;
            neighborfacing = facing;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && neighborfacing != null && (te instanceof TileEntityCable || te.hasCapability(CapabilityEnergy.ENERGY, neighborfacing))) {
            ((TileEntityCable)te).checkConnections();
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBB(state, source, pos);
    }

    private AxisAlignedBB getBB(IBlockState state, IBlockAccess source, BlockPos pos) {
        double minX = 0.4375;
        double minY = 0.4375;
        double minZ = 0.4375;
        double maxX = 0.5625;
        double maxY = 0.5625;
        double maxZ = 0.5625;
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TileEntityCable) {
            TileEntityCable tec = (TileEntityCable)te;
            if (tec.getConnection(EnumFacing.UP) == 1) {
                maxY = 1.0;
            }
            if (tec.getConnection(EnumFacing.UP) > 1) {
                maxY = 1.0;
                minX = Math.min(0.375, minX);
                minZ = Math.min(0.375, minZ);
                maxX = Math.max(0.625, maxX);
                maxZ = Math.max(0.625, maxZ);
            }
            if (tec.getConnection(EnumFacing.DOWN) == 1) {
                minY = 0.0;
            }
            if (tec.getConnection(EnumFacing.DOWN) > 1) {
                minY = 0.0;
                minX = Math.min(0.375, minX);
                minZ = Math.min(0.375, minZ);
                maxX = Math.max(0.625, maxX);
                maxZ = Math.max(0.625, maxZ);
            }
            if (tec.getConnection(EnumFacing.EAST) == 1) {
                maxX = 1.0;
            }
            if (tec.getConnection(EnumFacing.EAST) > 1) {
                maxX = 1.0;
                minY = Math.min(0.375, minY);
                minZ = Math.min(0.375, minZ);
                maxY = Math.max(0.625, maxY);
                maxZ = Math.max(0.625, maxZ);
            }
            if (tec.getConnection(EnumFacing.WEST) == 1) {
                minX = 0.0;
            }
            if (tec.getConnection(EnumFacing.WEST) > 1) {
                minX = 0.0;
                minY = Math.min(0.375, minY);
                minZ = Math.min(0.375, minZ);
                maxY = Math.max(0.625, maxY);
                maxZ = Math.max(0.625, maxZ);
            }
            if (tec.getConnection(EnumFacing.NORTH) == 1) {
                minZ = 0.0;
            }
            if (tec.getConnection(EnumFacing.NORTH) > 1) {
                minZ = 0.0;
                minY = Math.min(0.375, minY);
                minX = Math.min(0.375, minX);
                maxY = Math.max(0.625, maxY);
                maxX = Math.max(0.625, maxX);
            }
            if (tec.getConnection(EnumFacing.SOUTH) == 1) {
                maxZ = 1.0;
            }
            if (tec.getConnection(EnumFacing.SOUTH) > 1) {
                maxZ = 1.0;
                minY = Math.min(0.375, minY);
                minX = Math.min(0.375, minX);
                maxY = Math.max(0.625, maxY);
                maxX = Math.max(0.625, maxX);
            }
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private TileEntityCable getTECable(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCable) {
            return (TileEntityCable)te;
        }
        return null;
    }
}

