/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.gui;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.gui.GuiGuideBase;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.kaneka.planttech2.librarys.utils.Drop;
import net.kaneka.planttech2.librarys.utils.Parents;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GuiGuidePlants
extends GuiGuideBase {
    private int[] buttonIDs = new int[8];
    private String selectedName;
    protected ItemStack mainseed;
    protected ItemStack soil;
    protected ItemStack[] seeds = new ItemStack[9];
    protected Drop[] drops = new Drop[9];
    protected ItemStack[][] parents = new ItemStack[4][2];
    private EnumTemperature temp = EnumTemperature.NORMAL;

    public GuiGuidePlants() {
        super(PlantTechMain.instance.croplist.getLengthWithoutBlacklisted() - 8, true);
    }

    @Override
    protected void drawForeground() {
        if (this.selectedId != -1) {
            int i;
            GuiGuidePlants.func_146110_a((int)(this.guiLeft + 307), (int)(this.guiTop + 65), (float)0.0f, (float)(196 + 16 * this.temp.getId()), (int)16, (int)16, (float)512.0f, (float)512.0f);
            this.renderItem(this.mainseed, 261, 32);
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            if (this.soil != null && !this.soil.func_190926_b()) {
                this.renderItem(this.soil, 217, 65);
            }
            RenderHelper.func_74519_b();
            for (i = 0; i < 9; ++i) {
                if (this.seeds[i] != null) {
                    this.renderItem(this.seeds[i], 189 + 18 * i, 98);
                }
                if (this.drops[i] == null) continue;
                this.renderItem(this.drops[i].getItemStack(), 189 + 18 * i, 131);
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0] == null) continue;
                this.renderItem(this.parents[i][0], 162 + 56 * i, 164);
                this.renderItem(this.parents[i][1], 192 + 56 * i, 164);
            }
        }
    }

    @Override
    protected void updateButtons() {
        List<String> list = PlantTechMain.instance.croplist.getAllEntriesWithoutBlacklisted();
        for (int i = 0; i < 8; ++i) {
            if (this.scrollPos + i >= list.size()) continue;
            CropListEntry entry = PlantTechMain.instance.croplist.getEntryByName(list.get(this.scrollPos + i));
            ((GuiButton)this.field_146292_n.get((int)i)).field_146126_j = entry.getDisplayNameUnformated();
            this.buttonIDs[i] = entry.getID();
        }
    }

    @Override
    protected void drawStrings() {
        if (this.selectedId == -1) {
            this.drawCenteredString(this.translateUnformated("gui.non_selected"), this.guiLeft + 255, this.guiTop + 90);
        } else {
            this.drawCenteredString(this.selectedName, this.guiLeft + 263, this.guiTop + 15);
            this.drawCenteredString(this.translateUnformated("gui.soil"), this.guiLeft + 223, this.guiTop + 54);
            this.drawCenteredString(this.translateUnformated("gui.temperature"), this.guiLeft + 306, this.guiTop + 54);
            this.drawCenteredString(this.translateUnformated("gui.seeds"), this.guiLeft + 263, this.guiTop + 87);
            this.drawCenteredString(this.translateUnformated("gui.drops"), this.guiLeft + 263, this.guiTop + 120);
            this.drawCenteredString(this.translateUnformated("gui.parents"), this.guiLeft + 263, this.guiTop + 153);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k >= 0 && button.field_146127_k < 8) {
            this.setItems(this.buttonIDs[button.field_146127_k]);
        }
    }

    protected void setItems(int id) {
        this.selectedId = id;
        CropListEntry entry = PlantTechMain.instance.croplist.getByID(id);
        this.selectedName = entry.getDisplayNameUnformated();
        if (entry.getMainSeed() != null) {
            this.mainseed = entry.getMainSeed();
        }
        this.soil = entry.getSoil();
        if (this.soil.func_190926_b()) {
            this.soil = new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d));
        }
        Set<ItemStack> seeds = entry.getSeeds();
        Set<Drop> drops = entry.getDrops();
        Set<Parents> parentslist = entry.getParents();
        int i = 0;
        if (!seeds.isEmpty()) {
            for (ItemStack item : seeds) {
                if (i < 9) {
                    this.seeds[i] = item;
                }
                ++i;
            }
        }
        for (int k = i; k < 9; ++k) {
            this.seeds[k] = null;
        }
        i = 1;
        this.drops[0] = entry.getMainSeedDrop();
        if (drops != null) {
            for (Drop drop : drops) {
                if (i < 9) {
                    this.drops[i] = drop;
                }
                ++i;
            }
        }
        for (int k = i; k < 9; ++k) {
            this.drops[k] = null;
        }
        i = 0;
        if (parentslist != null) {
            for (Parents parents : parentslist) {
                if (i < 4) {
                    this.parents[i][0] = PlantTechMain.instance.croplist.getEntryByName(parents.getParent(0)).getMainSeed();
                    this.parents[i][1] = PlantTechMain.instance.croplist.getEntryByName(parents.getParent(1)).getMainSeed();
                }
                ++i;
            }
        }
        for (int k = i; k < 4; ++k) {
            this.parents[k][0] = null;
            this.parents[k][1] = null;
        }
        this.temp = entry.getTemperature();
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        if (this.selectedId != -1) {
            int i;
            this.drawTooltip(this.mainseed.func_82833_r(), mouseX, mouseY, 261, 32);
            if (this.soil != null && !this.soil.func_190926_b()) {
                this.drawTooltip(this.soil.func_82833_r(), mouseX, mouseY, 217, 65);
            }
            this.drawTooltip(this.temp.getDisplayString(), mouseX, mouseY, 307, 65);
            for (i = 0; i < 9; ++i) {
                if (this.seeds[i] != null) {
                    this.drawTooltip(this.seeds[i].func_82833_r(), mouseX, mouseY, 189 + 18 * i, 98);
                }
                if (this.drops[i] == null) continue;
                this.drawTooltip(this.drops[i].getMin() + "-" + this.drops[i].getMax() + "x " + this.drops[i].getItemStack().func_82833_r(), mouseX, mouseY, 189 + 18 * i, 131);
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0] == null) continue;
                this.drawTooltip(this.parents[i][0].func_82833_r(), mouseX, mouseY, 162 + 56 * i, 164);
                this.drawTooltip(this.parents[i][1].func_82833_r(), mouseX, mouseY, 192 + 56 * i, 164);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.selectedId != -1 && mouseButton == 0) {
            CropListEntry entry;
            int i;
            ItemStack clickedOn = null;
            if (this.inItemStackArea(mouseX, mouseY, 261, 32)) {
                clickedOn = this.mainseed;
            }
            if (this.inItemStackArea(mouseX, mouseY, 217, 65) && this.soil != null && !this.soil.func_190926_b()) {
                clickedOn = this.soil;
            }
            for (i = 0; i < 9; ++i) {
                if (this.seeds[i] != null && this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 98)) {
                    clickedOn = this.seeds[i];
                }
                if (this.drops[i] == null || !this.inItemStackArea(mouseX, mouseY, 189 + 18 * i, 131)) continue;
                clickedOn = this.drops[i].getItemStack();
            }
            for (i = 0; i < 4; ++i) {
                if (this.parents[i][0] == null) continue;
                if (this.inItemStackArea(mouseX, mouseY, 162 + 56 * i, 164)) {
                    clickedOn = this.parents[i][0];
                }
                if (!this.inItemStackArea(mouseX, mouseY, 192 + 56 * i, 164)) continue;
                clickedOn = this.parents[i][1];
            }
            if (clickedOn != null && (entry = PlantTechMain.instance.croplist.getBySeed(clickedOn)) != null) {
                this.setItems(entry.getID());
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private boolean inArea(int mouseX, int mouseY, int posX, int posY, int width, int height) {
        return mouseX >= (posX += this.guiLeft) && mouseX <= posX + width && mouseY >= (posY += this.guiTop) && mouseY <= posY + height;
    }

    private boolean inItemStackArea(int mouseX, int mouseY, int posX, int posY) {
        return this.inArea(mouseX, mouseY, posX, posY, 16, 16);
    }

    @Override
    protected void drawBackground() {
        if (this.selectedId == -1) {
            GuiGuidePlants.func_146110_a((int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)0.0f, (int)300, (int)this.ySize, (float)512.0f, (float)512.0f);
        } else {
            GuiGuidePlants.func_146110_a((int)(this.guiLeft + 100), (int)this.guiTop, (float)212.0f, (float)196.0f, (int)300, (int)this.ySize, (float)512.0f, (float)512.0f);
        }
        GuiGuidePlants.func_146110_a((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)150, (int)this.ySize, (float)512.0f, (float)512.0f);
    }
}

