/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.hashmaps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTraitsInt;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class HashMapCropTraits {
    private String type;
    private HashMap<EnumTraitsInt, Integer> traits = new HashMap();
    private boolean analysed;

    public HashMapCropTraits() {
        this.setDefault();
    }

    private void setDefault() {
        this.type = "carrot";
        for (EnumTraitsInt trait : EnumTraitsInt.values()) {
            this.traits.put(trait, trait.getMin());
        }
        this.analysed = false;
    }

    public HashMapCropTraits copy() {
        HashMapCropTraits copy = new HashMapCropTraits();
        Set<EnumTraitsInt> keyset = this.getTraitsList();
        for (EnumTraitsInt key : keyset) {
            copy.setTrait(key, this.getTrait(key));
        }
        copy.setType(this.getType());
        copy.setAnalysed(this.isAnalysed());
        return copy;
    }

    public Set<EnumTraitsInt> getTraitsList() {
        return this.traits.keySet();
    }

    public boolean setTrait(EnumTraitsInt trait, int value) {
        Set<EnumTraitsInt> keyset = this.getTraitsList();
        if (keyset.contains((Object)trait) && value > 0) {
            this.traits.put(trait, value);
            return true;
        }
        return false;
    }

    public int getTrait(EnumTraitsInt trait) {
        Set<EnumTraitsInt> keyset = this.getTraitsList();
        if (keyset.contains((Object)trait)) {
            return this.traits.get((Object)trait);
        }
        return 0;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isAnalysed() {
        return this.analysed;
    }

    public void setAnalysed(boolean bool) {
        this.analysed = bool;
    }

    public ItemStack createItemStackwithTraits(Item item) {
        ItemStack stack = new ItemStack(item);
        NBTTagCompound nbt = this.toNBT();
        stack.func_77982_d(nbt);
        return stack;
    }

    public ItemStack addToItemStack(ItemStack stack) {
        NBTTagCompound nbt = this.toNBT();
        stack.func_77982_d(nbt);
        return stack;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.addToNBT(nbt);
    }

    public NBTTagCompound addToNBT(NBTTagCompound nbt) {
        Set<EnumTraitsInt> keyset = this.getTraitsList();
        for (EnumTraitsInt key : keyset) {
            nbt.func_74768_a(key.func_176610_l(), this.getTrait(key));
        }
        nbt.func_74778_a("type", this.type);
        nbt.func_74757_a("analysed", this.isAnalysed());
        return nbt;
    }

    public void fromStack(ItemStack stack) {
        this.fromNBT(stack.func_77978_p());
    }

    public void fromNBT(NBTTagCompound nbt) {
        Set<EnumTraitsInt> keyset = this.getTraitsList();
        if (nbt != null) {
            for (EnumTraitsInt key : keyset) {
                if (!nbt.func_74764_b(key.func_176610_l())) continue;
                this.setTrait(key, nbt.func_74762_e(key.func_176610_l()));
            }
            this.setType(nbt.func_74779_i("type"));
            this.setAnalysed(nbt.func_74767_n("analysed"));
        }
    }

    public HashMapCropTraits calculateNewTraits(HashMapCropTraits oldTraits) {
        Set<CropListEntry> possibleChilds;
        Random rand = new Random();
        HashMapCropTraits newTraits = new HashMapCropTraits();
        if (rand.nextBoolean()) {
            newTraits.setType(this.type);
        } else {
            newTraits.setType(oldTraits.getType());
        }
        if (this.getType() != oldTraits.getType() && !(possibleChilds = PlantTechMain.instance.croplist.getByParents(this.getType(), oldTraits.getType())).isEmpty()) {
            float randomfloat;
            float sumNewTyp = 0.0f;
            float sumOldTyp = 0.0f;
            for (CropListEntry entry : possibleChilds) {
                sumNewTyp += entry.getChance();
            }
            sumOldTyp = sumNewTyp;
            if (sumNewTyp < 0.5f) {
                sumOldTyp = 1.0f - sumNewTyp;
            }
            if ((randomfloat = rand.nextFloat() * (sumOldTyp + sumNewTyp)) <= sumNewTyp) {
                float sum2 = 0.0f;
                for (CropListEntry entry : possibleChilds) {
                    if (!(randomfloat <= (sum2 += entry.getChance()))) continue;
                    newTraits.setType(entry.getString());
                }
            }
        }
        for (EnumTraitsInt trait : EnumTraitsInt.values()) {
            if (this.getTrait(trait) == oldTraits.getTrait(trait)) {
                if (trait.getTransitionPossibility() > rand.nextFloat() && this.getTrait(trait) < trait.getMax()) {
                    newTraits.setTrait(trait, this.getTrait(trait) + 1);
                    continue;
                }
                newTraits.setTrait(trait, this.getTrait(trait));
                continue;
            }
            int min = Math.min(this.getTrait(trait), oldTraits.getTrait(trait));
            int max = Math.max(this.getTrait(trait), oldTraits.getTrait(trait));
            newTraits.setTrait(trait, rand.nextInt(max - min) + min);
        }
        return newTraits;
    }

    public static List<String> getTraitsKeyList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("type");
        for (EnumTraitsInt trait : EnumTraitsInt.values()) {
            list.add(trait.func_176610_l());
        }
        return list;
    }
}

