/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.librarys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kaneka.planttech2.PlantTechMain;
import net.kaneka.planttech2.enums.EnumTemperature;
import net.kaneka.planttech2.filehelper.BlacklistFileHandler;
import net.kaneka.planttech2.filehelper.ParentsFileHandler;
import net.kaneka.planttech2.filehelper.SoilFileHandler;
import net.kaneka.planttech2.filehelper.TemperatureFileHandler;
import net.kaneka.planttech2.items.ModItems;
import net.kaneka.planttech2.librarys.CropListEntry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CropList {
    private HashMap<String, CropListEntry> croplist = new HashMap();
    private int nextID = 0;
    private int amountBlacklisted = 0;

    public void addEntry(String name, String model, String icon, int seedColor, boolean hasParticle) {
        this.croplist.put(name, new CropListEntry(this.nextID, name, model, icon, seedColor, hasParticle));
        ++this.nextID;
    }

    public void removeEntry(String name) {
        this.croplist.remove(name);
    }

    public Set<String> getAllKeys() {
        return this.croplist.keySet();
    }

    public Collection<CropListEntry> getAllEntries() {
        return this.croplist.values();
    }

    public List<String> getAllEntriesWithoutBlacklisted() {
        ArrayList<String> list = new ArrayList<String>();
        for (CropListEntry entry : this.croplist.values()) {
            if (entry.isBlacklisted()) continue;
            list.add(entry.getString());
        }
        Collections.sort(list);
        return list;
    }

    public Set<String> getAllWithParticles() {
        HashSet<String> keys = new HashSet<String>();
        for (CropListEntry entry : this.getAllEntries()) {
            if (!entry.hasParticle()) continue;
            keys.add(entry.getString());
        }
        return keys;
    }

    public CropListEntry getEntryByName(String name) {
        return this.croplist.get(name);
    }

    public CropListEntry getBySeed(ItemStack item) {
        CropListEntry returnvalue = null;
        for (CropListEntry entry : this.croplist.values()) {
            if (!entry.isSeed(item)) continue;
            returnvalue = entry;
            break;
        }
        return returnvalue;
    }

    public CropListEntry getByID(int id) {
        CropListEntry returnvalue = null;
        for (CropListEntry entry : this.croplist.values()) {
            if (entry.getID() != id) continue;
            returnvalue = entry;
            break;
        }
        return returnvalue;
    }

    public Set<CropListEntry> getByParents(String parent1, String parent2) {
        HashSet<CropListEntry> returnvalue = new HashSet<CropListEntry>();
        for (CropListEntry entry : this.croplist.values()) {
            if (!entry.isChild(parent1, parent2)) continue;
            returnvalue.add(entry);
        }
        return returnvalue;
    }

    public void setMainSeeds() {
        for (int i = 0; i < this.nextID; ++i) {
            this.getByID(i).setMainSeed(new ItemStack((Item)ModItems.CROPSEEDS, 1, i), 1, 4);
        }
    }

    public void setParticles() {
        for (CropListEntry entry : this.getAllEntries()) {
            if (!entry.hasParticle()) continue;
            entry.addDrop(new ItemStack((Item)ModItems.PARTICLES.get(entry.getString())), 0, 8);
        }
    }

    public int getLength() {
        return this.nextID;
    }

    public int getLengthWithoutBlacklisted() {
        return this.nextID - this.amountBlacklisted;
    }

    public void addPlanttechEntries() {
        this.addEntry("allium", "planttech2:plants/plant_allium", "planttech2:textures/blocks/plants/plant_allium_1.png", Integer.parseInt("a65ee1", 16), false);
        this.addEntry("aluminum", "planttech2:plants/plant_aluminum", "planttech2:textures/blocks/plants/plant_aluminum.png", Integer.parseInt("b4b4b4", 16), true);
        this.addEntry("ardite", "planttech2:plants/plant_ardite", "planttech2:textures/blocks/plants/plant_ardite.png", Integer.parseInt("88471b", 16), true);
        this.addEntry("azure_bluet", "planttech2:plants/plant_azure_bluet", "planttech2:textures/blocks/plants/plant_azure_bluet_1.png", Integer.parseInt("d6e8e8", 16), false);
        this.addEntry("beast", "planttech2:plants/plant_beast", "planttech2:textures/blocks/plants/plant_mob_beast.png", Integer.parseInt("6a6965", 16), true);
        this.addEntry("beetroots", "planttech2:plants/plant_beetroots", "planttech2:textures/blocks/plants/plant_beetroots_3.png", Integer.parseInt("bf2529", 16), false);
        this.addEntry("black_quartz", "planttech2:plants/plant_black_quartz", "planttech2:textures/blocks/plants/plant_black_quartz.png", Integer.parseInt("202020", 16), true);
        this.addEntry("blaze", "planttech2:plants/plant_blaze", "planttech2:textures/blocks/plants/plant_mob_blaze.png", Integer.parseInt("fc9600", 16), true);
        this.addEntry("blue_orchid", "planttech2:plants/plant_blue_orchid", "planttech2:textures/blocks/plants/plant_blue_orchid_1.png", Integer.parseInt("1c92d6", 16), false);
        this.addEntry("cactus", "planttech2:plants/plant_cactus", "planttech2:textures/blocks/plants/plant_cactus_3.png", Integer.parseInt("527d26", 16), false);
        this.addEntry("carrot", "planttech2:plants/plant_carrot", "planttech2:textures/blocks/plants/plant_carrot_3.png", Integer.parseInt("e38a1d", 16), false);
        this.addEntry("chicken", "planttech2:plants/plant_chicken", "planttech2:textures/blocks/plants/plant_mob_chicken.png", Integer.parseInt("e2e2e2", 16), true);
        this.addEntry("certus_quartz", "planttech2:plants/plant_certus_quartz", "planttech2:textures/blocks/plants/plant_certus_quartz.png", Integer.parseInt("36a3a3", 16), true);
        this.addEntry("chorus", "planttech2:plants/plant_chorus", "planttech2:textures/blocks/plants/plant_chorus_3.png", Integer.parseInt("8f718f", 16), false);
        this.addEntry("coal", "planttech2:plants/plant_coal", "planttech2:textures/blocks/plants/plant_coal.png", Integer.parseInt("3f3f3f", 16), true);
        this.addEntry("cobalt", "planttech2:plants/plant_cobalt", "planttech2:textures/blocks/plants/plant_cobalt.png", Integer.parseInt("1d5791", 16), true);
        this.addEntry("cocoa_bean", "planttech2:plants/plant_cocoa_bean", "planttech2:textures/blocks/plants/plant_cocoa_bean_3.png", Integer.parseInt("b97335", 16), false);
        this.addEntry("copper", "planttech2:plants/plant_copper", "planttech2:textures/blocks/plants/plant_copper.png", Integer.parseInt("b47800", 16), true);
        this.addEntry("cornflower", "planttech2:plants/plant_cornflower", "planttech2:textures/blocks/plants/plant_cornflower_1.png", Integer.parseInt("466aeb", 16), false);
        this.addEntry("cow", "planttech2:plants/plant_cow", "planttech2:textures/blocks/plants/plant_mob_cow.png", Integer.parseInt("443626", 16), true);
        this.addEntry("creeper", "planttech2:plants/plant_creeper", "planttech2:textures/blocks/plants/plant_mob_creeper.png", Integer.parseInt("41b736", 16), true);
        this.addEntry("dancium", "planttech2:plants/plant_dancium", "planttech2:textures/blocks/plants/plant_dancium.png", Integer.parseInt("eb8c14", 16), true);
        this.addEntry("dandelion", "planttech2:plants/plant_dandelion", "planttech2:textures/blocks/plants/plant_dandelion_1.png", Integer.parseInt("fed639", 16), false);
        this.addEntry("diamond", "planttech2:plants/plant_diamond", "planttech2:textures/blocks/plants/plant_diamond.png", Integer.parseInt("77cefb", 16), true);
        this.addEntry("dirt", "planttech2:plants/plant_dirt", "planttech2:textures/blocks/plants/plant_dirt.png", Integer.parseInt("593d29", 16), true);
        this.addEntry("drowned", "planttech2:plants/plant_drowned", "planttech2:textures/blocks/plants/plant_mob_drowned.png", Integer.parseInt("8ff1d7", 16), true);
        this.addEntry("emerald", "planttech2:plants/plant_emerald", "planttech2:textures/blocks/plants/plant_emerald.png", Integer.parseInt("17dd62", 16), true);
        this.addEntry("enderdragon", "planttech2:plants/plant_enderdragon", "planttech2:textures/blocks/plants/plant_mob_enderdragon.png", Integer.parseInt("181818", 16), true);
        this.addEntry("enderman", "planttech2:plants/plant_enderman", "planttech2:textures/blocks/plants/plant_mob_enderman.png", Integer.parseInt("181818", 16), true);
        this.addEntry("endstone", "planttech2:plants/plant_endstone", "planttech2:textures/blocks/plants/plant_endstone.png", Integer.parseInt("f6fabd", 16), true);
        this.addEntry("fish", "planttech2:plants/plant_fish", "planttech2:textures/blocks/plants/plant_mob_fish.png", Integer.parseInt("bf841b", 16), true);
        this.addEntry("ghast", "planttech2:plants/plant_ghast", "planttech2:textures/blocks/plants/plant_mob_ghast.png", Integer.parseInt("f0f0f0", 16), true);
        this.addEntry("glowstone", "planttech2:plants/plant_glowstone", "planttech2:textures/blocks/plants/plant_glowstone.png", Integer.parseInt("fbda74", 16), true);
        this.addEntry("gold", "planttech2:plants/plant_gold", "planttech2:textures/blocks/plants/plant_gold.png", Integer.parseInt("f8af2b", 16), true);
        this.addEntry("guardian", "planttech2:plants/plant_guardian", "planttech2:textures/blocks/plants/plant_mob_guardian.png", Integer.parseInt("668980", 16), true);
        this.addEntry("husk", "planttech2:plants/plant_husk", "planttech2:textures/blocks/plants/plant_mob_husk.png", Integer.parseInt("6a5d4a", 16), true);
        this.addEntry("illager", "planttech2:plants/plant_illager", "planttech2:textures/blocks/plants/plant_mob_illager.png", Integer.parseInt("939999", 16), true);
        this.addEntry("iron", "planttech2:plants/plant_iron", "planttech2:textures/blocks/plants/plant_iron.png", Integer.parseInt("bc9980", 16), true);
        this.addEntry("kanekium", "planttech2:plants/plant_kanekium", "planttech2:textures/blocks/plants/plant_kanekium.png", Integer.parseInt("572e8a", 16), true);
        this.addEntry("kinnoium", "planttech2:plants/plant_kinnoium", "planttech2:textures/blocks/plants/plant_kinnoium.png", Integer.parseInt("246b2d", 16), true);
        this.addEntry("lilly_of_the_valley", "planttech2:plants/plant_lilly_of_the_valley", "planttech2:textures/blocks/plants/plant_lilly_of_the_valley_1.png", Integer.parseInt("e7e7e7", 16), false);
        this.addEntry("lapis", "planttech2:plants/plant_lapis", "planttech2:textures/blocks/plants/plant_lapis.png", Integer.parseInt("1044ac", 16), true);
        this.addEntry("lava", "planttech2:plants/plant_lava", "planttech2:textures/blocks/plants/plant_lava.png", Integer.parseInt("d14f0c", 16), true);
        this.addEntry("lead", "planttech2:plants/plant_lead", "planttech2:textures/blocks/plants/plant_lead.png", Integer.parseInt("326e99", 16), true);
        this.addEntry("lenthurium", "planttech2:plants/plant_lenthurium", "planttech2:textures/blocks/plants/plant_lenthurium.png", Integer.parseInt("2c8585", 16), true);
        this.addEntry("magma_cube", "planttech2:plants/plant_magma_cube", "planttech2:textures/blocks/plants/plant_mob_magma_cube.png", Integer.parseInt("330000", 16), true);
        this.addEntry("melon", "planttech2:plants/plant_melon", "planttech2:textures/blocks/plants/plant_melon_3.png", Integer.parseInt("a7ac1d", 16), false);
        this.addEntry("mooshroom", "planttech2:plants/plant_mooshroom", "planttech2:textures/blocks/plants/plant_mob_mooshroom.png", Integer.parseInt("a81012", 16), true);
        this.addEntry("mushroom", "planttech2:plants/plant_mushroom", "planttech2:textures/blocks/plants/plant_mushroom_3.png", Integer.parseInt("e21212", 16), false);
        this.addEntry("mycelium", "planttech2:plants/plant_mycelium", "planttech2:textures/blocks/plants/plant_mycelium.png", Integer.parseInt("736162", 16), true);
        this.addEntry("netherrack", "planttech2:plants/plant_netherrack", "planttech2:textures/blocks/plants/plant_netherrack.png", Integer.parseInt("652828", 16), true);
        this.addEntry("nether_wart", "planttech2:plants/plant_nether_wart", "planttech2:textures/blocks/plants/plant_nether_wart_2.png", Integer.parseInt("831c20", 16), false);
        this.addEntry("nickel", "planttech2:plants/plant_nickel", "planttech2:textures/blocks/plants/plant_nickel.png", Integer.parseInt("aeaf3a", 16), true);
        this.addEntry("orange_tulip", "planttech2:plants/plant_orange_tulip", "planttech2:textures/blocks/plants/plant_orange_tulip_1.png", Integer.parseInt("bd6a22", 16), false);
        this.addEntry("oxeye_daisy", "planttech2:plants/plant_oxeye_daisy", "planttech2:textures/blocks/plants/plant_oxeye_daisy_1.png", Integer.parseInt("f5ba27", 16), false);
        this.addEntry("panda", "planttech2:plants/plant_panda", "planttech2:textures/blocks/plants/plant_mob_panda.png", Integer.parseInt("f5ba27", 16), true);
        this.addEntry("parrot", "planttech2:plants/plant_parrot", "planttech2:textures/blocks/plants/plant_mob_parrot.png", Integer.parseInt("18bdff", 16), true);
        this.addEntry("pig", "planttech2:plants/plant_pig", "planttech2:textures/blocks/plants/plant_mob_pig.png", Integer.parseInt("f19e98", 16), true);
        this.addEntry("pink_tulip", "planttech2:plants/plant_pink_tulip", "planttech2:textures/blocks/plants/plant_pink_tulip_1.png", Integer.parseInt("e4aff4", 16), false);
        this.addEntry("plantium", "planttech2:plants/plant_plantium", "planttech2:textures/blocks/plants/plant_plantium.png", Integer.parseInt("35a048", 16), true);
        this.addEntry("platinum", "planttech2:plants/plant_platinum", "planttech2:textures/blocks/plants/plant_platinum.png", Integer.parseInt("a2a2a2", 16), true);
        this.addEntry("polarbear", "planttech2:plants/plant_polarbear", "planttech2:textures/blocks/plants/plant_mob_polarbear.png", Integer.parseInt("f6f6f6", 16), true);
        this.addEntry("poppy", "planttech2:plants/plant_poppy", "planttech2:textures/blocks/plants/plant_poppy_1.png", Integer.parseInt("ed302c", 16), false);
        this.addEntry("potato", "planttech2:plants/plant_potato", "planttech2:textures/blocks/plants/plant_potato_3.png", Integer.parseInt("c8a24b", 16), false);
        this.addEntry("prismarin", "planttech2:plants/plant_prismarin", "planttech2:textures/blocks/plants/plant_prismarin.png", Integer.parseInt("5ea496", 16), true);
        this.addEntry("pumpkin", "planttech2:plants/plant_pumpkin", "planttech2:textures/blocks/plants/plant_pumpkin_3.png", Integer.parseInt("e38a1d", 16), false);
        this.addEntry("quartz", "planttech2:plants/plant_quartz", "planttech2:textures/blocks/plants/plant_quartz.png", Integer.parseInt("d4caba", 16), true);
        this.addEntry("redstone", "planttech2:plants/plant_redstone", "planttech2:textures/blocks/plants/plant_redstone.png", Integer.parseInt("ff0000", 16), true);
        this.addEntry("red_tulip", "planttech2:plants/plant_red_tulip", "planttech2:textures/blocks/plants/plant_red_tulip_1.png", Integer.parseInt("ed302c", 16), false);
        this.addEntry("sand", "planttech2:plants/plant_sand", "planttech2:textures/blocks/plants/plant_sand.png", Integer.parseInt("dacfa3", 16), true);
        this.addEntry("sheep", "planttech2:plants/plant_sheep", "planttech2:textures/blocks/plants/plant_mob_sheep.png", Integer.parseInt("c09e86", 16), true);
        this.addEntry("shulker", "planttech2:plants/plant_shulker", "planttech2:textures/blocks/plants/plant_mob_shulker.png", Integer.parseInt("8e608e", 16), true);
        this.addEntry("silver", "planttech2:plants/plant_silver", "planttech2:textures/blocks/plants/plant_silver.png", Integer.parseInt("dadada", 16), true);
        this.addEntry("skeleton", "planttech2:plants/plant_skeleton", "planttech2:textures/blocks/plants/plant_mob_skeleton.png", Integer.parseInt("bcbcbc", 16), true);
        this.addEntry("slime", "planttech2:plants/plant_slime", "planttech2:textures/blocks/plants/plant_mob_slime.png", Integer.parseInt("59bd45", 16), true);
        this.addEntry("snow", "planttech2:plants/plant_snow", "planttech2:textures/blocks/plants/plant_snow.png", Integer.parseInt("ffffff", 16), true);
        this.addEntry("soulsand", "planttech2:plants/plant_soulsand", "planttech2:textures/blocks/plants/plant_soulsand.png", Integer.parseInt("49372c", 16), true);
        this.addEntry("spider", "planttech2:plants/plant_spider", "planttech2:textures/blocks/plants/plant_mob_spider.png", Integer.parseInt("605448", 16), true);
        this.addEntry("sponge", "planttech2:plants/plant_sponge", "planttech2:textures/blocks/plants/plant_sponge.png", Integer.parseInt("cdce4a", 16), true);
        this.addEntry("squid", "planttech2:plants/plant_squid", "planttech2:textures/blocks/plants/plant_mob_squid.png", Integer.parseInt("cdce4a", 16), true);
        this.addEntry("stone", "planttech2:plants/plant_stone", "planttech2:textures/blocks/plants/plant_stone.png", Integer.parseInt("616161", 16), true);
        this.addEntry("stray", "planttech2:plants/plant_stray", "planttech2:textures/blocks/plants/plant_mob_stray.png", Integer.parseInt("acbabd", 16), true);
        this.addEntry("sugarcane", "planttech2:plants/plant_sugarcane", "planttech2:textures/blocks/plants/plant_sugarcane_3.png", Integer.parseInt("82a859", 16), false);
        this.addEntry("tin", "planttech2:plants/plant_tin", "planttech2:textures/blocks/plants/plant_tin.png", Integer.parseInt("aba78c", 16), true);
        this.addEntry("turtle", "planttech2:plants/plant_turtle", "planttech2:textures/blocks/plants/plant_mob_turtle.png", Integer.parseInt("388d3a", 16), true);
        this.addEntry("uranium", "planttech2:plants/plant_uranium", "planttech2:textures/blocks/plants/plant_uranium.png", Integer.parseInt("3abd22", 16), true);
        this.addEntry("villager", "planttech2:plants/plant_villager", "planttech2:textures/blocks/plants/plant_mob_villager.png", Integer.parseInt("b57b67", 16), true);
        this.addEntry("vine", "planttech2:plants/plant_vine", "planttech2:textures/blocks/plants/plant_vine_3.png", Integer.parseInt("1b5011", 16), false);
        this.addEntry("water", "planttech2:plants/plant_water", "planttech2:textures/blocks/plants/plant_water.png", Integer.parseInt("2b5fff", 16), true);
        this.addEntry("wheat", "planttech2:plants/plant_wheat", "planttech2:textures/blocks/plants/plant_wheat_7.png", Integer.parseInt("00ae19", 16), false);
        this.addEntry("white_tulip", "planttech2:plants/plant_white_tulip", "planttech2:textures/blocks/plants/plant_white_tulip_1.png", Integer.parseInt("f7f7f7", 16), false);
        this.addEntry("witch", "planttech2:plants/plant_witch", "planttech2:textures/blocks/plants/plant_mob_witch.png", Integer.parseInt("a39483", 16), true);
        this.addEntry("wither_rose", "planttech2:plants/plant_wither_rose", "planttech2:textures/blocks/plants/plant_wither_rose_1.png", Integer.parseInt("000000", 16), false);
        this.addEntry("wither_skeleton", "planttech2:plants/plant_wither_skeleton", "planttech2:textures/blocks/plants/plant_mob_wither_skeleton.png", Integer.parseInt("515353", 16), true);
        this.addEntry("wither", "planttech2:plants/plant_wither", "planttech2:textures/blocks/plants/plant_mob_wither.png", Integer.parseInt("343434", 16), true);
        this.addEntry("wood", "planttech2:plants/plant_wood", "planttech2:textures/blocks/plants/plant_wood.png", Integer.parseInt("605e54", 16), true);
        this.addEntry("zombie_pigman", "planttech2:plants/plant_zombie_pigman", "planttech2:textures/blocks/plants/plant_mob_zombie_pigman.png", Integer.parseInt("eea5a4", 16), true);
        this.addEntry("zombie_villager", "planttech2:plants/plant_zombie_villager", "planttech2:textures/blocks/plants/plant_mob_zombie_villager.png", Integer.parseInt("3b622f", 16), true);
        this.addEntry("zombie", "planttech2:plants/plant_zombie", "planttech2:textures/blocks/plants/plant_mob_zombie.png", Integer.parseInt("71955b", 16), true);
        this.loadBlacklist();
    }

    public void configuratePlanttechEntries() {
        this.setMainSeeds();
        this.setParticles();
        this.getEntryByName("allium").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 2)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4);
        this.getEntryByName("azure_bluet").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 3)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4);
        this.getEntryByName("beast");
        this.getEntryByName("beetroots").addSeeds(new ItemStack(Items.field_185163_cU)).addDrop(new ItemStack(Items.field_185164_cV), 0, 4);
        this.getEntryByName("blaze");
        this.getEntryByName("blue_orchid").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 1)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4);
        this.getEntryByName("cactus").addSeeds(new ItemStack((Block)Blocks.field_150434_aF)).addDrop(new ItemStack((Block)Blocks.field_150434_aF), 0, 4);
        this.getEntryByName("carrot").addSeeds(new ItemStack(Items.field_151172_bF)).addDrop(new ItemStack(Items.field_151172_bF), 0, 4);
        this.getEntryByName("chicken");
        this.getEntryByName("chorus").addDrop(new ItemStack(Items.field_185161_cS), 0, 4);
        this.getEntryByName("coal");
        this.getEntryByName("cocoa_bean").addSeeds(new ItemStack(Items.field_151100_aR, 1, 3)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4);
        this.getEntryByName("cornflower").addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4);
        this.getEntryByName("cow");
        this.getEntryByName("creeper");
        this.getEntryByName("dancium");
        this.getEntryByName("dandelion").addSeeds(new ItemStack((Block)Blocks.field_150327_N, 1, 0)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((Block)Blocks.field_150327_N, 1, 0), 0, 4);
        this.getEntryByName("diamond");
        this.getEntryByName("dirt");
        this.getEntryByName("drowned");
        this.getEntryByName("emerald");
        this.getEntryByName("enderdragon");
        this.getEntryByName("enderman");
        this.getEntryByName("endstone");
        this.getEntryByName("fish");
        this.getEntryByName("ghast");
        this.getEntryByName("glowstone");
        this.getEntryByName("gold");
        this.getEntryByName("guardian");
        this.getEntryByName("husk");
        this.getEntryByName("illager");
        this.getEntryByName("iron");
        this.getEntryByName("kanekium");
        this.getEntryByName("kinnoium");
        this.getEntryByName("lilly_of_the_valley").addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4);
        this.getEntryByName("lapis");
        this.getEntryByName("lava");
        this.getEntryByName("lenthurium");
        this.getEntryByName("magma_cube");
        this.getEntryByName("melon").addSeeds(new ItemStack(Items.field_151081_bc)).addDrop(new ItemStack(Items.field_151127_ba), 0, 4);
        this.getEntryByName("mooshroom");
        this.getEntryByName("mushroom").addSeeds(new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150338_P)).addDrop(new ItemStack((Block)Blocks.field_150337_Q), 0, 4).addDrop(new ItemStack((Block)Blocks.field_150338_P), 0, 4);
        this.getEntryByName("mycelium");
        this.getEntryByName("netherrack");
        this.getEntryByName("nether_wart");
        this.getEntryByName("orange_tulip").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 5)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((Block)Blocks.field_150328_O, 1, 5), 0, 4);
        this.getEntryByName("oxeye_daisy").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 8)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((Block)Blocks.field_150328_O, 1, 8), 0, 4);
        this.getEntryByName("panda");
        this.getEntryByName("parrot");
        this.getEntryByName("pig");
        this.getEntryByName("pink_tulip").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 7)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((Block)Blocks.field_150328_O, 1, 7), 0, 4);
        this.getEntryByName("plantium").addSeeds(new ItemStack((Item)ModItems.PLANTIUM_NUGGET));
        this.getEntryByName("polarbear");
        this.getEntryByName("poppy").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 0)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((Block)Blocks.field_150328_O, 1, 0), 0, 4);
        this.getEntryByName("potato").addSeeds(new ItemStack(Items.field_151174_bG)).addDrop(new ItemStack(Items.field_151174_bG), 1, 4).addDrop(new ItemStack(Items.field_151170_bI), 0, 4);
        this.getEntryByName("prismarin");
        this.getEntryByName("pumpkin").addSeeds(new ItemStack(Items.field_151080_bb)).addDrop(new ItemStack(Blocks.field_150423_aK), 0, 4);
        this.getEntryByName("quartz");
        this.getEntryByName("redstone");
        this.getEntryByName("red_tulip").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 4)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((Block)Blocks.field_150328_O, 1, 4), 0, 4);
        this.getEntryByName("sand");
        this.getEntryByName("sheep");
        this.getEntryByName("shulker");
        this.getEntryByName("skeleton");
        this.getEntryByName("slime");
        this.getEntryByName("snow");
        this.getEntryByName("soulsand");
        this.getEntryByName("spider");
        this.getEntryByName("sponge");
        this.getEntryByName("squid").addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 0, 2);
        this.getEntryByName("stone");
        this.getEntryByName("stray");
        this.getEntryByName("sugarcane").addSeeds(new ItemStack(Items.field_151120_aE));
        this.getEntryByName("turtle");
        this.getEntryByName("villager");
        this.getEntryByName("vine").addSeeds(new ItemStack(Blocks.field_150395_bd));
        this.getEntryByName("water");
        this.getEntryByName("wheat").addSeeds(new ItemStack(Items.field_151014_N)).addDrop(new ItemStack(Items.field_151015_O), 1, 4);
        this.getEntryByName("white_tulip").addSeeds(new ItemStack((Block)Blocks.field_150328_O, 1, 6)).addDrop(new ItemStack((Item)ModItems.COLOR_PARTICLES), 1, 4).addDrop(new ItemStack((Block)Blocks.field_150328_O), 0, 4);
        this.getEntryByName("witch");
        this.getEntryByName("wither_rose");
        this.getEntryByName("wither_skeleton");
        this.getEntryByName("wither");
        this.getEntryByName("wood");
        this.getEntryByName("zombie_pigman");
        this.getEntryByName("zombie_villager");
        this.getEntryByName("zombie");
        this.loadParents();
        this.loadTemperatures();
        this.loadSoils();
    }

    private void loadParents() {
        PlantTechMain.logger.info("initiate cropparents");
        ParentsFileHandler parentsfile = new ParentsFileHandler();
        List<String> list = parentsfile.loadFile();
        int i = 1;
        for (String input : list) {
            if (!input.isEmpty() && input.charAt(0) != '/') {
                if (input.matches(".+[=].+[+].+[,].+[0.].+")) {
                    String[] splitted = input.split("[=+,]");
                    if (splitted.length == 4) {
                        if (this.existEntry(splitted[0], i) && this.existEntry(splitted[1], i) && this.existEntry(splitted[2], i)) {
                            this.getEntryByName(splitted[0]).addParents(splitted[1], splitted[2], Float.valueOf(splitted[3]).floatValue());
                        } else {
                            PlantTechMain.logger.info("line " + i + " not existing croptype: " + input);
                        }
                    } else {
                        PlantTechMain.logger.info("line " + i + " not matching pattern: " + input);
                    }
                } else {
                    PlantTechMain.logger.info("line " + i + " not matching pattern: " + input);
                }
            }
            ++i;
        }
        PlantTechMain.logger.info("finish cropparents");
    }

    private void loadTemperatures() {
        PlantTechMain.logger.info("initiate croptemperature");
        TemperatureFileHandler temperaturesfile = new TemperatureFileHandler();
        List<String> list = temperaturesfile.loadFile();
        int i = 1;
        for (String input : list) {
            if (!input.isEmpty() && input.charAt(0) != '/') {
                if (input.matches(".+[=].+")) {
                    String[] splitted = input.split("[=]");
                    if (splitted.length == 2) {
                        if (this.existEntry(splitted[0], i)) {
                            this.getEntryByName(splitted[0]).alternateTemperature(EnumTemperature.byName(splitted[1]));
                        } else {
                            PlantTechMain.logger.info("line " + i + " not existing croptype: " + input);
                        }
                    } else {
                        PlantTechMain.logger.info("line " + i + " not matching pattern: " + input);
                    }
                } else {
                    PlantTechMain.logger.info("line " + i + " not matching pattern: " + input);
                }
            }
            ++i;
        }
        PlantTechMain.logger.info("finish croptemperature");
    }

    private void loadSoils() {
        PlantTechMain.logger.info("initiate cropsoils");
        SoilFileHandler soilsfile = new SoilFileHandler();
        List<String> list = soilsfile.loadFile();
        int i = 1;
        for (String input : list) {
            if (!input.isEmpty() && input.charAt(0) != '/') {
                if (input.matches(".+[=].+[,].+")) {
                    String[] splitted = input.split("[=,]");
                    if (splitted.length == 3) {
                        if (this.existEntry(splitted[0], i)) {
                            this.getEntryByName(splitted[0]).setSoil(new ItemStack(Block.func_149684_b((String)splitted[1]), 1, Integer.valueOf(splitted[2]).intValue()));
                        } else {
                            PlantTechMain.logger.info("line " + i + " not existing croptype: " + input);
                        }
                    } else {
                        PlantTechMain.logger.info("line " + i + " not matching pattern: " + input);
                    }
                } else {
                    PlantTechMain.logger.info("line " + i + " not matching pattern: " + input);
                }
            }
            ++i;
        }
        PlantTechMain.logger.info("finish cropsoil");
    }

    private void loadBlacklist() {
        PlantTechMain.logger.info("initiate blacklist");
        BlacklistFileHandler blacklistfile = new BlacklistFileHandler();
        List<String> list = blacklistfile.loadFile();
        int i = 1;
        for (String input : list) {
            if (!input.isEmpty() && input.charAt(0) != '/') {
                if (this.existEntry(input, i)) {
                    this.getEntryByName(input).setBlacklisted(true);
                    ++this.amountBlacklisted;
                } else {
                    PlantTechMain.logger.info("line " + i + " not existing croptype: " + input);
                }
            }
            ++i;
        }
        PlantTechMain.logger.info("finish blacklist");
    }

    private boolean existEntry(String name, int i) {
        if (this.getEntryByName(name) != null) {
            return true;
        }
        PlantTechMain.logger.info("missing croplistentry in line " + i + ": " + name + " does not exists!");
        return false;
    }
}

