/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.cable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kaneka.planttech2.tileentity.cable.Connection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityCable
extends TileEntity
implements ITickable {
    private BlockPos masterPos = null;
    private boolean isMaster = false;
    private int[] connections = new int[]{0, 0, 0, 0, 0, 0};
    private int maxTransferRate = 20;
    private List<BlockPos> cables = new ArrayList<BlockPos>();
    private HashMap<Integer, List<Connection>> connectionsMaster = new HashMap<Integer, List<Connection>>(){
        {
            this.put(0, new ArrayList());
            this.put(1, new ArrayList());
            this.put(2, new ArrayList());
        }
    };
    HashMap<BlockPos, EnumFacing> producer = new HashMap();
    HashMap<BlockPos, EnumFacing> consumer = new HashMap();
    HashMap<BlockPos, EnumFacing> storages = new HashMap();
    private boolean connectionUpdate = true;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isMaster) {
            this.transferEnergy();
        }
    }

    private void transferEnergy() {
        IEnergyStorage cap;
        int maxNeeded = 0;
        int maxSupplied = 0;
        int maxStorragesNeeded = 0;
        int maxStorragesSupplied = 0;
        int amountConsumer = 0;
        int amountProducer = 0;
        int amountStorages = 0;
        if (this.connectionUpdate) {
            this.producer.clear();
            this.consumer.clear();
            this.storages.clear();
            for (Connection con : this.connectionsMaster.get(0)) {
                cap = this.getEnergyCap(con.getConnectedPos(), con.getFacing().func_176734_d());
                if (cap == null || this.consumer.containsKey(con.getConnectedPos())) continue;
                this.consumer.put(con.getConnectedPos(), con.getFacing().func_176734_d());
            }
            for (Connection con : this.connectionsMaster.get(1)) {
                cap = this.getEnergyCap(con.getConnectedPos(), con.getFacing().func_176734_d());
                if (cap == null || this.producer.containsKey(con.getConnectedPos())) continue;
                this.producer.put(con.getConnectedPos(), con.getFacing().func_176734_d());
            }
            for (Connection con : this.connectionsMaster.get(2)) {
                cap = this.getEnergyCap(con.getConnectedPos(), con.getFacing().func_176734_d());
                if (cap == null || this.storages.containsKey(con.getConnectedPos())) continue;
                this.storages.put(con.getConnectedPos(), con.getFacing().func_176734_d());
            }
            List intersect_PC = this.producer.keySet().stream().filter(x -> this.consumer.containsKey(x)).collect(Collectors.toList());
            List intersect_PS = this.producer.keySet().stream().filter(x -> this.storages.containsKey(x)).collect(Collectors.toList());
            List intersect_CS = this.consumer.keySet().stream().filter(x -> this.storages.containsKey(x)).collect(Collectors.toList());
            intersect_PC.addAll(intersect_PS);
            intersect_PC.addAll(intersect_CS);
            this.producer.entrySet().removeIf(entry -> intersect_PC.contains(entry.getKey()));
            this.consumer.entrySet().removeIf(entry -> intersect_PC.contains(entry.getKey()));
            this.storages.entrySet().removeIf(entry -> intersect_PC.contains(entry.getKey()));
            this.connectionUpdate = false;
        }
        for (Map.Entry<BlockPos, EnumFacing> entry2 : this.producer.entrySet()) {
            cap = this.getEnergyCap(entry2.getKey(), entry2.getValue());
            if (cap == null) continue;
            maxSupplied += cap.extractEnergy(this.maxTransferRate, true);
            ++amountProducer;
        }
        for (Map.Entry<BlockPos, EnumFacing> entry2 : this.consumer.entrySet()) {
            cap = this.getEnergyCap(entry2.getKey(), entry2.getValue());
            if (cap == null) continue;
            maxNeeded += cap.receiveEnergy(this.maxTransferRate, true);
            ++amountConsumer;
        }
        for (Map.Entry<BlockPos, EnumFacing> entry2 : this.storages.entrySet()) {
            cap = this.getEnergyCap(entry2.getKey(), entry2.getValue());
            if (cap == null) continue;
            maxStorragesSupplied += cap.extractEnergy(this.maxTransferRate, true);
            maxStorragesNeeded += cap.receiveEnergy(this.maxTransferRate, true);
            ++amountStorages;
        }
        if (maxNeeded + maxStorragesNeeded > 0 && maxSupplied + maxStorragesSupplied > 0) {
            int perMachineConsumer = 0;
            int perMachineProducer = 0;
            int perMachineStoragesIn = 0;
            int perMachineStoragesOut = 0;
            int leftoverConsumer = 0;
            int leftoverProducer = 0;
            int leftoverStorageIn = 0;
            int leftoverStorageOut = 0;
            if (maxNeeded > maxSupplied) {
                int maxSuppliedBoth = maxSupplied + maxStorragesSupplied;
                if (maxNeeded > maxSuppliedBoth) {
                    perMachineProducer = this.maxTransferRate;
                    perMachineStoragesOut = this.maxTransferRate;
                    perMachineConsumer = maxSuppliedBoth / amountConsumer;
                    leftoverConsumer = maxSuppliedBoth - perMachineConsumer * amountConsumer;
                } else {
                    perMachineProducer = this.maxTransferRate;
                    perMachineStoragesOut = (maxNeeded - maxSupplied) / amountStorages;
                    leftoverStorageOut = maxNeeded - maxSupplied - perMachineStoragesOut * amountStorages;
                    perMachineConsumer = this.maxTransferRate;
                }
            } else if (maxNeeded < maxSupplied) {
                int maxNeededBoth = maxNeeded + maxStorragesNeeded;
                if (maxNeededBoth < maxSupplied) {
                    perMachineProducer = maxNeededBoth / amountProducer;
                    leftoverProducer = maxNeededBoth - perMachineProducer * amountProducer;
                    perMachineStoragesIn = this.maxTransferRate;
                    perMachineConsumer = this.maxTransferRate;
                } else {
                    perMachineProducer = this.maxTransferRate;
                    perMachineStoragesIn = (maxSupplied - maxNeeded) / amountStorages;
                    leftoverStorageIn = maxSupplied - maxNeeded - perMachineStoragesIn * amountStorages;
                    perMachineConsumer = this.maxTransferRate;
                }
            } else {
                perMachineProducer = this.maxTransferRate;
                perMachineConsumer = this.maxTransferRate;
            }
            for (Map.Entry<BlockPos, EnumFacing> entry3 : this.producer.entrySet()) {
                cap = this.getEnergyCap(entry3.getKey(), entry3.getValue());
                if (cap == null) continue;
                if (leftoverProducer > 0) {
                    cap.extractEnergy(perMachineProducer + 1, false);
                    --leftoverProducer;
                    continue;
                }
                cap.extractEnergy(perMachineProducer, false);
            }
            for (Map.Entry<BlockPos, EnumFacing> entry3 : this.consumer.entrySet()) {
                cap = this.getEnergyCap(entry3.getKey(), entry3.getValue());
                if (cap == null) continue;
                if (leftoverConsumer > 0) {
                    cap.receiveEnergy(perMachineConsumer + 1, false);
                    --leftoverConsumer;
                    continue;
                }
                cap.receiveEnergy(perMachineConsumer, false);
            }
            for (Map.Entry<BlockPos, EnumFacing> entry3 : this.storages.entrySet()) {
                cap = this.getEnergyCap(entry3.getKey(), entry3.getValue());
                if (cap == null) continue;
                if (perMachineStoragesIn > 0) {
                    if (leftoverStorageIn > 0) {
                        cap.receiveEnergy(perMachineStoragesIn + 1, false);
                        --leftoverStorageIn;
                    } else {
                        cap.receiveEnergy(perMachineStoragesIn, false);
                    }
                }
                if (perMachineStoragesOut <= 0) continue;
                if (leftoverStorageOut > 0) {
                    cap.extractEnergy(perMachineStoragesOut + 1, false);
                    --leftoverStorageOut;
                    continue;
                }
                cap.extractEnergy(perMachineStoragesOut, false);
            }
        }
    }

    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    public void setMasterPos(BlockPos pos) {
        this.masterPos = pos;
    }

    public int getConnection(EnumFacing facing) {
        return this.connections[facing.func_176745_a()];
    }

    public void setConnection(EnumFacing facing, int i) {
        if (0 <= i && i < 5) {
            TileEntityCable te = this.getTECable(this.masterPos);
            if (te != null) {
                te.changeConnectionMaster(this.field_174879_c, facing, this.connections[facing.func_176745_a()], i);
            }
            this.connections[facing.func_176745_a()] = i;
        }
    }

    public void changeConnectionMaster(BlockPos pos, EnumFacing facing, int before, int after) {
        if (before > 1) {
            this.connectionsMaster.get(before - 2).removeIf(x -> x.areEqual(pos, facing));
        }
        if (after > 1 && !this.connectionsMaster.get(after - 2).stream().anyMatch(x -> x.areEqual(pos, facing))) {
            this.connectionsMaster.get(after - 2).add(new Connection(pos, facing));
        }
        this.connectionUpdate = true;
    }

    private void removeValues() {
        this.masterPos = null;
        if (this.isMaster) {
            this.removeMaster(null);
        }
    }

    public void setAsMaster() {
        this.isMaster = true;
        this.masterPos = this.field_174879_c;
        this.cables.add(this.field_174879_c);
        this.connectionUpdate = true;
    }

    public void removeMaster(BlockPos newMaster) {
        this.isMaster = false;
        this.masterPos = newMaster;
        this.cables.clear();
        for (int i = 0; i < this.connectionsMaster.size(); ++i) {
            this.connectionsMaster.get(i).clear();
        }
    }

    public void addCable(BlockPos pos) {
        this.cables.add(pos);
    }

    public void removeCable(BlockPos pos) {
        this.cables.remove(pos);
    }

    public void initCable(IBlockState state) {
        TileEntity te;
        boolean changedConnections = false;
        ArrayList<BlockPos> neighborMaster = new ArrayList<BlockPos>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (te == null) continue;
            if (te instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)te;
                if (!neighborMaster.contains(cable.getMasterPos())) {
                    neighborMaster.add(cable.getMasterPos());
                }
                changedConnections = true;
            }
            if (!te.hasCapability(CapabilityEnergy.ENERGY, facing)) continue;
            changedConnections = true;
        }
        switch (neighborMaster.size()) {
            case 0: {
                this.setAsMaster();
                this.masterPos = this.field_174879_c;
                break;
            }
            case 1: {
                te = this.func_145831_w().func_175625_s((BlockPos)neighborMaster.get(0));
                if (te == null || !(te instanceof TileEntityCable)) break;
                ((TileEntityCable)te).addCable(this.func_174877_v());
                this.setMasterPos(te.func_174877_v());
                break;
            }
            default: {
                this.combineAndAdd(neighborMaster);
            }
        }
        this.checkConnections();
        this.func_70296_d();
    }

    public void deleteCable() {
        ArrayList<BlockPos> neighborCables = new ArrayList<BlockPos>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (te == null || !(te instanceof TileEntityCable)) continue;
            neighborCables.add(this.field_174879_c.func_177972_a(facing));
        }
        if (this.isMaster) {
            if (neighborCables.size() == 1) {
                TileEntityCable newMaster = (TileEntityCable)this.field_145850_b.func_175625_s((BlockPos)neighborCables.get(0));
                this.transferMastery(newMaster, this);
                newMaster.removeCable(this.field_174879_c);
            } else if (neighborCables.size() > 1) {
                this.recreateNetworks(neighborCables, this.cables);
            }
        } else if (neighborCables.size() == 1) {
            ((TileEntityCable)this.field_145850_b.func_175625_s((BlockPos)neighborCables.get(0))).removeCable(this.field_174879_c);
        } else if (neighborCables.size() > 1) {
            this.recreateNetworks(neighborCables, this.getTECable(this.masterPos).getCableList());
        }
    }

    public void recreateNetworks(List<BlockPos> neighborcables, List<BlockPos> cables) {
        TileEntityCable te;
        List cableCopy = cables.stream().collect(Collectors.toList());
        for (BlockPos cablePos : cableCopy) {
            te = this.getTECable(cablePos);
            if (te == null) continue;
            te.removeValues();
        }
        for (BlockPos neighborcable : neighborcables) {
            te = this.getTECable(neighborcable);
            if (te.getMasterPos() != null) continue;
            te.setAsMaster();
            te.sendConnections();
            te.spreadPos(this.field_174879_c);
        }
    }

    public void spreadPos(BlockPos exeption) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntityCable te;
            BlockPos nextPos = this.field_174879_c.func_177972_a(facing);
            if (nextPos.equals((Object)exeption) || (te = this.getTECable(nextPos)) == null || te.getMasterPos() != null) continue;
            te.setMasterPos(this.masterPos);
            this.getTECable(te.getMasterPos()).addCable(te.func_174877_v());
            te.sendConnections();
            te.spreadPos(exeption);
        }
    }

    private void sendConnections() {
        TileEntityCable te = this.getTECable(this.masterPos);
        if (te != null) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (this.connections[facing.func_176745_a()] <= 1) continue;
                te.changeConnectionMaster(this.field_174879_c, facing, 0, this.connections[facing.func_176745_a()]);
            }
        }
    }

    public void combineAndAdd(List<BlockPos> list) {
        TileEntity te = this.field_145850_b.func_175625_s(list.get(0));
        list.remove(0);
        if (te != null && te instanceof TileEntityCable) {
            TileEntityCable newMaster = (TileEntityCable)te;
            for (BlockPos oldMasterPos : list) {
                TileEntity oldTE = this.field_145850_b.func_175625_s(oldMasterPos);
                if (oldTE == null || !(oldTE instanceof TileEntityCable)) continue;
                TileEntityCable oldMaster = (TileEntityCable)oldTE;
                this.transferMastery(newMaster, oldMaster);
            }
            newMaster.addCable(this.func_174877_v());
            this.setMasterPos(newMaster.func_174877_v());
        }
    }

    public HashMap<Integer, List> getLists() {
        HashMap<Integer, List> lists = new HashMap<Integer, List>();
        lists.put(0, this.cables);
        lists.put(1, this.connectionsMaster.get(0));
        lists.put(2, this.connectionsMaster.get(1));
        lists.put(3, this.connectionsMaster.get(2));
        return lists;
    }

    public void setLists(HashMap<Integer, List> lists) {
        this.cables.addAll(lists.get(0));
        this.connectionsMaster.get(0).addAll(lists.get(1));
        this.connectionsMaster.get(1).addAll(lists.get(2));
        this.connectionsMaster.get(2).addAll(lists.get(3));
    }

    public List<BlockPos> getCableList() {
        return this.cables;
    }

    private void setCableMasterPos(BlockPos pos) {
        for (BlockPos cablePos : this.cables) {
            TileEntity te = this.field_145850_b.func_175625_s(cablePos);
            if (te == null || !(te instanceof TileEntityCable)) continue;
            ((TileEntityCable)te).setMasterPos(pos);
        }
    }

    private void transferMastery(TileEntityCable newMaster, TileEntityCable oldMaster) {
        oldMaster.setCableMasterPos(newMaster.getMasterPos());
        newMaster.setAsMaster();
        newMaster.setLists(oldMaster.getLists());
        oldMaster.removeMaster(newMaster.getMasterPos());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("ismaster", this.isMaster);
        if (this.masterPos != null) {
            compound.func_74768_a("masterposx", this.masterPos.func_177958_n());
            compound.func_74768_a("masterposy", this.masterPos.func_177956_o());
            compound.func_74768_a("masterposz", this.masterPos.func_177952_p());
        }
        if (!this.cables.isEmpty()) {
            NBTTagList cableList = new NBTTagList();
            this.cables.stream().forEach(x -> cableList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)x)));
            compound.func_74782_a("cables", (NBTBase)cableList);
        }
        if (this.connections.length == 6) {
            compound.func_74783_a("connections", this.connections);
        }
        for (int i = 0; i < 3; ++i) {
            if (this.connectionsMaster.get(i).size() <= 0) continue;
            List<Connection> connections = this.connectionsMaster.get(i);
            NBTTagList connectionlist = new NBTTagList();
            for (Connection con : connections) {
                connectionlist.func_74742_a((NBTBase)con.serializeConnection());
            }
            compound.func_74782_a("connections_" + i, (NBTBase)connectionlist);
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagList cableList;
        super.func_145839_a(compound);
        if (compound.func_74764_b("ismaster")) {
            this.isMaster = compound.func_74767_n("ismaster");
        }
        if (compound.func_74764_b("masterposx")) {
            this.masterPos = new BlockPos(compound.func_74762_e("masterposx"), compound.func_74762_e("masterposy"), compound.func_74762_e("masterposz"));
        }
        if ((cableList = compound.func_150295_c("cables", 10)).func_74745_c() > 0) {
            this.cables.clear();
            for (int i = 0; i < cableList.func_74745_c(); ++i) {
                this.cables.add(NBTUtil.func_186861_c((NBTTagCompound)cableList.func_150305_b(i)));
            }
        }
        if (compound.func_74764_b("connections")) {
            this.connections = compound.func_74759_k("connections");
        }
        for (int i = 0; i < 3; ++i) {
            NBTTagList list;
            if (!compound.func_74764_b("connections_" + i) || (list = compound.func_150295_c("connections_" + i, 10)).func_74745_c() <= 0) continue;
            this.connectionsMaster.get(i).clear();
            for (int k = 0; k < list.func_74745_c(); ++k) {
                this.connectionsMaster.get(i).add(new Connection().deserializeConnection(list.func_150305_b(k)));
            }
        }
    }

    private IEnergyStorage getEnergyCap(BlockPos pos, EnumFacing facing) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            return (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing);
        }
        return null;
    }

    private TileEntityCable getTECable(BlockPos pos) {
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCable) {
            return (TileEntityCable)te;
        }
        return null;
    }

    public void checkConnections() {
        boolean shouldSendChanges = false;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (te != null) {
                if (te instanceof TileEntityCable && this.getConnection(facing) != 1) {
                    this.setConnection(facing, 1);
                    shouldSendChanges = true;
                }
                if (!te.hasCapability(CapabilityEnergy.ENERGY, facing) || this.getConnection(facing) >= 2) continue;
                this.setConnection(facing, 2);
                shouldSendChanges = true;
                continue;
            }
            if (this.getConnection(facing) == 0) continue;
            this.setConnection(facing, 0);
            shouldSendChanges = true;
        }
        if (shouldSendChanges && !this.field_145850_b.field_72995_K) {
            this.sendUpdates();
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    private void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public void rotateConnection(int i) {
        int next = this.connections[i] + 1;
        if (next > 4) {
            next = 2;
        }
        this.setConnection(EnumFacing.func_82600_a((int)i), next);
        this.sendUpdates();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return newState.func_177230_c() != oldState.func_177230_c();
    }
}

