/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kaneka.planttech2.hashmaps.HashMapCropTraits;
import net.kaneka.planttech2.items.ModItems;
import net.kaneka.planttech2.tileentity.machine.TileEntityEnergyInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityDNARemover
extends TileEntityEnergyInventory {
    private int ticksPassed = 0;

    public TileEntityDNARemover() {
        super(1000, 3);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() > this.energyPerTick()) {
            List<String> traitsList;
            ItemStack stack1 = this.itemhandler.getStackInSlot(0);
            ItemStack stack2 = this.itemhandler.getStackInSlot(1);
            if (!stack1.func_190926_b() && stack2.func_190926_b() && stack1.func_77973_b() == ModItems.DNA_CONTAINER && (traitsList = this.getAvailableTraits(stack1)).size() > 1) {
                if (this.ticksPassed < this.ticksPerItem()) {
                    ++this.ticksPassed;
                    this.energystorage.extractEnergy(this.energyPerTick(), false);
                } else {
                    Collections.shuffle(traitsList);
                    NBTTagCompound nbt = stack1.func_77978_p().func_74737_b();
                    nbt.func_82580_o(traitsList.get(0));
                    ItemStack stack = new ItemStack((Item)ModItems.DNA_CONTAINER);
                    stack.func_77982_d(nbt);
                    this.itemhandler.setStackInSlot(1, stack);
                    stack1.func_190918_g(1);
                    this.energystorage.extractEnergy(this.energyPerTick(), false);
                    this.ticksPassed = 0;
                }
            }
        }
    }

    private List<String> getAvailableTraits(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            for (String key : HashMapCropTraits.getTraitsKeyList()) {
                if (!nbt.func_74764_b(key)) continue;
                list.add(key);
            }
        }
        return list;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(2, ModItems.SPEEDUPGRADE) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(2, ModItems.SPEEDUPGRADE) * 35;
    }

    @Override
    public String getNameString() {
        return "dna_remover";
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        super.func_145839_a(compound);
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.getField(id);
            }
            case 2: {
                return this.ticksPassed;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.setField(id, value);
                break;
            }
            case 2: {
                this.ticksPassed = value;
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 3;
    }
}

