/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.items.ModItems;
import net.kaneka.planttech2.tileentity.machine.TileEntityEnergyInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityIdentifier
extends TileEntityEnergyInventory {
    public int ticksPassed = 0;

    public TileEntityIdentifier() {
        super(10000, 19);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() > this.getEnergyPerTickPerItem()) {
            if (this.canIdentify()) {
                this.energystorage.extractEnergy(this.getEnergyPerTickPerItem(), false);
                ++this.ticksPassed;
                if (this.ticksPassed >= this.getTicksPerItem()) {
                    this.identifyItem();
                    this.ticksPassed = 0;
                }
            } else if (this.ticksPassed > 0) {
                this.ticksPassed = 0;
            }
        } else if (!this.canIdentify() && this.ticksPassed > 0) {
            this.ticksPassed = 0;
        }
    }

    private boolean canIdentify() {
        if (!this.hasFreeOutputSlot()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound nbt;
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (stack.func_190926_b() || (nbt = stack.func_77978_p()) == null || !nbt.func_74764_b("analysed") || nbt.func_74767_n("analysed")) continue;
            return true;
        }
        return false;
    }

    public void identifyItem() {
        if (this.canIdentify()) {
            for (int i = 0; i < 9; ++i) {
                NBTTagCompound nbt;
                ItemStack stack = this.itemhandler.getStackInSlot(i);
                if (stack.func_190926_b() || (nbt = stack.func_77978_p()) == null || !nbt.func_74764_b("analysed") || nbt.func_74767_n("analysed")) continue;
                nbt.func_74757_a("analysed", true);
                stack.func_77982_d(nbt);
                this.itemhandler.setStackInSlot(this.getFreeOutputSlot(), stack);
                this.itemhandler.setStackInSlot(i, ItemStack.field_190927_a);
                break;
            }
        }
    }

    public boolean hasFreeOutputSlot() {
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int getFreeOutputSlot() {
        for (int i = 9; i < 18; ++i) {
            ItemStack stack = this.itemhandler.getStackInSlot(i);
            if (!stack.func_190926_b()) continue;
            return i;
        }
        return 9;
    }

    public int getEnergyPerTickPerItem() {
        return 4 + this.getUpgradeTier(18, ModItems.SPEEDUPGRADE) * 4;
    }

    public int getTicksPerItem() {
        return 200 - this.getUpgradeTier(18, ModItems.SPEEDUPGRADE) * 35;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("cooktime", this.ticksPassed);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.ticksPassed = compound.func_74762_e("cooktime");
        super.func_145839_a(compound);
    }

    @Override
    public String getNameString() {
        return "identifier";
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.getField(id);
            }
            case 2: {
                return this.ticksPassed;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.setField(id, value);
                break;
            }
            case 2: {
                this.ticksPassed = value;
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 3;
    }
}

