/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import net.kaneka.planttech2.items.ModItems;
import net.kaneka.planttech2.tileentity.machine.TileEntityEnergyInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMegaFurnace
extends TileEntityEnergyInventory {
    public int[] ticksPassed = new int[6];
    boolean isSmelting;

    public TileEntityMegaFurnace() {
        super(10000, 13);
    }

    @Override
    public void doUpdate() {
        this.isSmelting = false;
        for (int i = 0; i < 6; ++i) {
            if (this.energystorage.getEnergyStored() > this.getEnergyPerTickPerItem()) {
                if (this.canSmelt(i)) {
                    this.isSmelting = true;
                    int n = i;
                    this.ticksPassed[n] = this.ticksPassed[n] + 1;
                    if (this.ticksPassed[i] < this.getTicksPerItem()) continue;
                    this.smeltItem(i);
                    this.ticksPassed[i] = 0;
                    continue;
                }
                if (this.ticksPassed[i] <= 0) continue;
                this.ticksPassed[i] = 0;
                continue;
            }
            if (this.canSmelt(i) || this.ticksPassed[i] <= 0) break;
            this.ticksPassed[i] = 0;
            break;
        }
        if (this.isSmelting) {
            this.energystorage.extractEnergy(this.getEnergyPerTickPerItem(), false);
        }
    }

    private boolean canSmelt(int slot) {
        ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
        if (output.func_190926_b()) {
            return false;
        }
        ItemStack outputslot = this.itemhandler.getStackInSlot(slot + 6);
        if (outputslot.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(outputslot)) {
            return false;
        }
        if (outputslot.func_190916_E() + output.func_190916_E() <= 64 && outputslot.func_190916_E() + output.func_190916_E() <= outputslot.func_77976_d()) {
            return true;
        }
        return outputslot.func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    public void smeltItem(int slot) {
        if (this.canSmelt(slot)) {
            ItemStack itemstack = this.itemhandler.getStackInSlot(slot);
            ItemStack itemstack1 = FurnaceRecipes.func_77602_a().func_151395_a(itemstack);
            ItemStack itemstack2 = this.itemhandler.getStackInSlot(slot + 6);
            if (itemstack2.func_190926_b()) {
                this.itemhandler.setStackInSlot(slot + 6, itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            itemstack.func_190918_g(1);
        }
    }

    public int getEnergyPerTickPerItem() {
        return 4 + this.getUpgradeTier(12, ModItems.SPEEDUPGRADE) * 4;
    }

    public int getTicksPerItem() {
        return 200 - this.getUpgradeTier(12, ModItems.SPEEDUPGRADE) * 35;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        for (int i = 0; i < 6; ++i) {
            compound.func_74768_a("cooktime_" + i, this.ticksPassed[i]);
        }
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        for (int i = 0; i < 6; ++i) {
            this.ticksPassed[i] = compound.func_74762_e("cooktime_" + i);
        }
        super.func_145839_a(compound);
    }

    @Override
    public String getNameString() {
        return "mega_furnace";
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: 
            case 1: {
                return super.getField(id);
            }
            case 2: {
                return this.ticksPassed[0];
            }
            case 3: {
                return this.ticksPassed[1];
            }
            case 4: {
                return this.ticksPassed[2];
            }
            case 5: {
                return this.ticksPassed[3];
            }
            case 6: {
                return this.ticksPassed[4];
            }
            case 7: {
                return this.ticksPassed[5];
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: 
            case 1: {
                super.setField(id, value);
                break;
            }
            case 2: {
                this.ticksPassed[0] = value;
                break;
            }
            case 3: {
                this.ticksPassed[1] = value;
                break;
            }
            case 4: {
                this.ticksPassed[2] = value;
                break;
            }
            case 5: {
                this.ticksPassed[3] = value;
                break;
            }
            case 6: {
                this.ticksPassed[4] = value;
                break;
            }
            case 7: {
                this.ticksPassed[5] = value;
            }
        }
    }

    @Override
    public int getAmountFields() {
        return 8;
    }
}

