/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.filehelper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;

public class JsonGenerator {
    int nextLine = 0;
    List<String> lines = new ArrayList<String>();
    List<String> template = new ArrayList<String>();
    String actualtemplate = "";

    private void saveFile(String file) {
        try {
            File f = new File("json/outputs/" + file + ".json");
            f.createNewFile();
            FileWriter fw = new FileWriter(f, true);
            BufferedWriter bw = new BufferedWriter(fw);
            for (String line : this.lines) {
                bw.write(line);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lines.isEmpty();
        this.nextLine = 0;
    }

    private void loadTemplate(String temp) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader("json/templates/" + temp + ".json"));
            String line = reader.readLine();
            while (line != null) {
                this.template.add(line);
                line = reader.readLine();
            }
            reader.close();
            this.actualtemplate = temp;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createFile(String temp, String filename, HashMap<String, String> replacements) {
        if (this.actualtemplate != temp) {
            this.loadTemplate(temp);
        }
        this.lines.clear();
        this.lines.addAll(this.template);
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            for (int i = 0; i < this.lines.size(); ++i) {
                this.lines.set(i, this.lines.get(i).replace(entry.getKey(), entry.getValue()));
            }
        }
        this.saveFile(filename);
    }

    public void create() {
        this.createChipalyzerItemWithEnchantmentFile(ModItems.PROTECTION_CHIP, Enchantments.field_180310_c);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.FIRE_PROTECTION_CHIP, Enchantments.field_77329_d);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.FEATHER_FALLING_CHIP, Enchantments.field_180309_e);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.BLAST_PROTECTION_CHIP, Enchantments.field_185297_d);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.PROJECTILE_PROTECTION_CHIP, Enchantments.field_180308_g);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.RESPIRATION_CHIP, Enchantments.field_185298_f);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.AQUA_AFFINITY_CHIP, Enchantments.field_185299_g);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.THORNS_CHIP, Enchantments.field_92091_k);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.DEPTH_STRIDER_CHIP, Enchantments.field_185300_i);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.FROST_WALKER_CHIP, Enchantments.field_185301_j);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.SHARPNESS_CHIP, Enchantments.field_185302_k);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.SMITE_CHIP, Enchantments.field_185303_l);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.BANE_OF_ARTHROPODS_CHIP, Enchantments.field_180312_n);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.KNOCKBACK_CHIP, Enchantments.field_180313_o);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.FIRE_ASPECT_CHIP, Enchantments.field_77334_n);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.LOOTING_CHIP, Enchantments.field_185304_p);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.SWEEPING_CHIP, Enchantments.field_191530_r);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.EFFICIENCY_CHIP, Enchantments.field_185305_q);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.SILK_TOUCH_CHIP, Enchantments.field_185306_r);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.UNBREAKING_CHIP, Enchantments.field_185307_s);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.FORTUNE_CHIP, Enchantments.field_185308_t);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.POWER_CHIP, Enchantments.field_185309_u);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.PUNCH_CHIP, Enchantments.field_185310_v);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.FLAME_CHIP, Enchantments.field_185311_w);
        this.createChipalyzerItemWithEnchantmentFile(ModItems.INFINITY_CHIP, Enchantments.field_185312_x);
    }

    private void createChipalyzerItemWithoutEnchantmentFile(final Item output, final Item input, final int tier) {
        this.createFile("chipalyzeritem", output.getRegistryName().func_110623_a(), new HashMap<String, String>(){
            {
                this.put("%tier", String.valueOf(tier));
                this.put("%input", input.getRegistryName().toString());
                this.put("%output", output.getRegistryName().toString());
            }
        });
    }

    private void createChipalyzerItemWithEnchantmentFile(final Item output, final Enchantment input) {
        this.createFile("chipalyzerenchantment", output.getRegistryName().func_110623_a(), new HashMap<String, String>(){
            {
                this.put("%tier", String.valueOf(2));
                this.put("%enchantment", input.func_77320_a().replace("enchantment.minecraft.", ""));
                this.put("%output", output.getRegistryName().toString());
            }
        });
    }

    private void createItemModelFile(Item output, final String file) {
        this.createFile("itemmodel", output.getRegistryName().func_110623_a(), new HashMap<String, String>(){
            {
                this.put("%file", file);
            }
        });
    }
}

