/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.filehelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class RecipeJSONGenerator {
    int maxLines = 100;
    int nextLine = 0;
    String[] lines = new String[this.maxLines];
    String[] abc = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I"};

    public void saveFile(String file) {
        try {
            File f = new File("recipes/" + file + ".json");
            f.createNewFile();
            FileWriter fw = new FileWriter(f, true);
            BufferedWriter bw = new BufferedWriter(fw);
            for (int i = 0; i < this.nextLine; ++i) {
                bw.write(this.lines[i]);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lines = new String[this.maxLines];
        this.nextLine = 0;
    }

    public void addLine(String line) {
        this.lines[this.nextLine] = line;
        ++this.nextLine;
    }

    public void createShapelessRecipeFile(String name, String output, int amount, String ... ingredients) {
        this.addLine("{");
        this.addLine("    \"type\": \"minecraft:crafting_shapeless\",");
        this.addLine("    \"ingredients\": [");
        int i = ingredients.length;
        int k = 0;
        for (String ingredient : ingredients) {
            ++k;
            this.addLine("        {");
            String[] withMeta = ingredient.split("-");
            if (withMeta.length < 2) {
                this.addLine("            \"item\": \"" + ingredient + "\"");
            } else {
                this.addLine("            \"item\": \"" + withMeta[0] + "\"");
            }
            if (k < i) {
                this.addLine("        },");
                continue;
            }
            this.addLine("        }");
        }
        this.addLine("    ],");
        this.addLine("    \"result\": {");
        this.addLine("        \"item\": \"" + output + "\",");
        this.addLine("        \"count\": " + amount + "");
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(name);
    }

    public void createShapedRecipeFile(String row1, String row2, String row3, String name, String output, int amount, String ... ingredients) {
        this.addLine("{");
        this.addLine("    \"type\": \"minecraft:crafting_shaped\",");
        this.addLine("    \"pattern\": [");
        this.addLine("        \"" + row1 + "\",");
        if (!row3.equals("")) {
            this.addLine("        \"" + row2 + "\",");
            this.addLine("        \"" + row3 + "\"");
        } else {
            this.addLine("        \"" + row2 + "\"");
        }
        this.addLine("    ],");
        this.addLine("    \"key\": {");
        int i = ingredients.length;
        int k = 0;
        for (String ingredient : ingredients) {
            this.addLine("        \"" + this.abc[k] + "\": ");
            ++k;
            this.addLine("        {");
            String[] withMeta = ingredient.split("-");
            if (withMeta.length < 2) {
                this.addLine("            \"item\": \"" + ingredient + "\"");
            } else {
                this.addLine("            \"item\": \"" + withMeta[0] + "\"");
            }
            if (k < i) {
                this.addLine("        },");
                continue;
            }
            this.addLine("        }");
        }
        this.addLine("    },");
        this.addLine("    \"result\": {");
        this.addLine("        \"item\": \"" + output + "\",");
        this.addLine("        \"count\": " + amount + "");
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(name);
    }

    public void createShapedRecipeFileItem(String row1, String row2, String row3, ItemStack output, int amount, ItemStack ... ingredients) {
        this.createShapedRecipeFileItem(row1, row2, row3, output, output.func_77973_b().getRegistryName().toString().replace("minecraft:", "").replace("planttech2:", ""), amount, ingredients);
    }

    public void createShapedRecipeFileItem(String row1, String row2, String row3, ItemStack output, String filename, int amount, ItemStack ... ingredients) {
        System.out.println(filename);
        this.addLine("{");
        this.addLine("    \"type\": \"minecraft:crafting_shaped\",");
        this.addLine("    \"pattern\": [");
        this.addLine("        \"" + row1 + "\",");
        if (!row3.equals("")) {
            this.addLine("        \"" + row2 + "\",");
            this.addLine("        \"" + row3 + "\"");
        } else {
            this.addLine("        \"" + row2 + "\"");
        }
        this.addLine("    ],");
        this.addLine("    \"key\": {");
        int i = ingredients.length;
        int k = 0;
        for (ItemStack ingredient : ingredients) {
            this.addLine("        \"" + this.abc[k] + "\": ");
            this.addLine("        {");
            this.addLine("            \"item\": \"" + ingredient.func_77973_b().getRegistryName() + "\"");
            if (++k < i) {
                this.addLine("        },");
                continue;
            }
            this.addLine("        }");
        }
        this.addLine("    },");
        this.addLine("    \"result\": {");
        this.addLine("        \"item\": \"" + output.func_77973_b().getRegistryName() + "\",");
        this.addLine("        \"count\": " + amount + "");
        this.addLine("    }");
        this.addLine("}");
        this.saveFile(filename);
    }

    public void createXRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("A A", " A ", "A A", output, amount, input);
    }

    public void createORecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "A A", "AAA", output, amount, input);
    }

    public void create2x2Recipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AA", "AA", "", output, amount, input);
    }

    public void create3x3Recipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", output, amount, input);
    }

    public void createChestplateRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("A A", "AAA", "AAA", output, amount, input);
    }

    public void createHelmetRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "A A", "   ", output, amount, input);
    }

    public void createLeggingsRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("AAA", "A A", "A A", output, amount, input);
    }

    public void createBootsRecipe(ItemStack output, int amount, ItemStack input) {
        this.createShapedRecipeFileItem("A A", "A A", "   ", output, amount, input);
    }

    public void createRecipes() {
        this.createShapedRecipeFileItem("ABA", "BAB", "ABA", new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), 1, new ItemStack((IItemProvider)Items.field_151014_N), new ItemStack((IItemProvider)Items.field_191525_da));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), "plantium_ingot2", 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_NUGGET));
        this.createShapelessRecipeFile("plantium_ingot3", "planttech2:plantium_ingot", 9, "planttech2:plantium_block");
        this.createShapelessRecipeFile("plantium_nugget", "planttech2:plantium_nugget", 9, "planttech2:plantium_ingot");
        this.create3x3Recipe(new ItemStack((IItemProvider)ModBlocks.PLANTIUM_BLOCK), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((IItemProvider)ModItems.DANCIUM_INGOT), "dancium_ingot1", 1, new ItemStack((IItemProvider)ModItems.DANCIUM_NUGGET));
        this.createShapelessRecipeFile("dancium_ingot2", "planttech2:dancium_ingot", 9, "planttech2:dancium_block");
        this.createShapelessRecipeFile("dancium_nugget", "planttech2:dancium_nugget", 9, "planttech2:dancium_ingot");
        this.create3x3Recipe(new ItemStack((IItemProvider)ModBlocks.DANCIUM_BLOCK), 1, new ItemStack((IItemProvider)ModItems.DANCIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((IItemProvider)ModItems.KANEKIUM_INGOT), "kanekium_ingot1", 1, new ItemStack((IItemProvider)ModItems.KANEKIUM_NUGGET));
        this.createShapelessRecipeFile("kanekium_ingot2", "planttech2:kanekium_ingot", 9, "planttech2:kanekium_block");
        this.createShapelessRecipeFile("kanekium_nugget", "planttech2:kanekium_nugget", 9, "planttech2:kanekium_ingot");
        this.create3x3Recipe(new ItemStack((IItemProvider)ModBlocks.KANEKIUM_BLOCK), 1, new ItemStack((IItemProvider)ModItems.KANEKIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((IItemProvider)ModItems.KINNOIUM_INGOT), "kinnoium_ingot1", 1, new ItemStack((IItemProvider)ModItems.KINNOIUM_NUGGET));
        this.createShapelessRecipeFile("kinnoium_ingot2", "planttech2:kinnoium_ingot", 9, "planttech2:kinnoium_block");
        this.createShapelessRecipeFile("kinnoium_nugget", "planttech2:kinnoium_nugget", 9, "planttech2:kinnoium_ingot");
        this.create3x3Recipe(new ItemStack((IItemProvider)ModBlocks.KINNOIUM_BLOCK), 1, new ItemStack((IItemProvider)ModItems.KINNOIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", "AAA", new ItemStack((IItemProvider)ModItems.LENTHURIUM_INGOT), "lenthurium_ingot1", 1, new ItemStack((IItemProvider)ModItems.LENTHURIUM_NUGGET));
        this.createShapelessRecipeFile("lenthurium_ingot2", "planttech2:lenthurium_ingot", 9, "planttech2:lenthurium_block");
        this.createShapelessRecipeFile("lenthurium_nugget", "planttech2:lenthurium_nugget", 9, "planttech2:lenthurium_ingot");
        this.create3x3Recipe(new ItemStack((IItemProvider)ModBlocks.LENTHURIUM_BLOCK), 1, new ItemStack((IItemProvider)ModItems.LENTHURIUM_INGOT));
        this.createShapedRecipeFileItem("A", "A", "B", new ItemStack((IItemProvider)ModItems.THERMOMETER), 1, new ItemStack((IItemProvider)Blocks.field_150359_w), new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "AAA", " B ", new ItemStack((IItemProvider)ModItems.ANALYSER), 1, new ItemStack((IItemProvider)Blocks.field_150359_w), new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("A A", "AAA", " A ", new ItemStack((IItemProvider)ModItems.WRENCH), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SOLARFOCUS_TIER_1), "solarfocus1", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151045_i));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SOLARFOCUS_TIER_2), "solarfocus2", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.SOLARFOCUS_TIER_1), new ItemStack((IItemProvider)Items.field_151045_i));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SOLARFOCUS_TIER_3), "solarfocus3", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.SOLARFOCUS_TIER_2), new ItemStack((IItemProvider)Items.field_151045_i));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SOLARFOCUS_TIER_4), "solarfocus4", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.SOLARFOCUS_TIER_3), new ItemStack((IItemProvider)Items.field_151045_i));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SPEEDUPGRADE_TIER_1), "speedupgrade1", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151166_bC));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SPEEDUPGRADE_TIER_2), "speedupgrade2", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.SPEEDUPGRADE_TIER_1), new ItemStack((IItemProvider)Items.field_151166_bC));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SPEEDUPGRADE_TIER_3), "speedupgrade3", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.SPEEDUPGRADE_TIER_2), new ItemStack((IItemProvider)Items.field_151166_bC));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.SPEEDUPGRADE_TIER_4), "speedupgrade4", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.SPEEDUPGRADE_TIER_3), new ItemStack((IItemProvider)Items.field_151166_bC));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.RANGEUPGRADE_TIER_1), "rangeupgrade1", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151017_I));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.RANGEUPGRADE_TIER_2), "rangeupgrade2", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.RANGEUPGRADE_TIER_1), new ItemStack((IItemProvider)Items.field_151019_K));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.RANGEUPGRADE_TIER_3), "rangeupgrade3", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.RANGEUPGRADE_TIER_2), new ItemStack((IItemProvider)Items.field_151013_M));
        this.createShapedRecipeFileItem("ABA", "BCB", "ABA", new ItemStack((IItemProvider)ModItems.RANGEUPGRADE_TIER_4), "rangeupgrade4", 1, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)ModItems.RANGEUPGRADE_TIER_3), new ItemStack((IItemProvider)Items.field_151012_L));
        this.create2x2Recipe(new ItemStack((IItemProvider)ModBlocks.CROPBARS), 1, new ItemStack((IItemProvider)Items.field_151055_y));
        this.createShapedRecipeFileItem("AAA", "BCB", "AAA", new ItemStack((IItemProvider)ModBlocks.MEGAFURNACE), 1, new ItemStack((IItemProvider)Blocks.field_150460_al), new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)ModBlocks.PLANTIUM_BLOCK));
        this.createShapedRecipeFileItem("AAA", "BCB", "AAA", new ItemStack((IItemProvider)ModBlocks.IDENTIFIER), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)ModBlocks.CABLE), new ItemStack((IItemProvider)ModItems.ANALYSER));
        this.createShapedRecipeFileItem("ACA", "B B", "ACA", new ItemStack((IItemProvider)ModBlocks.SEEDSQUEEZER), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)ModBlocks.CABLE), new ItemStack((IItemProvider)Blocks.field_150331_J));
        this.createShapedRecipeFileItem("AAA", "BCB", "DDD", new ItemStack((IItemProvider)ModBlocks.SOLARGENERATOR), 1, new ItemStack((IItemProvider)Items.field_151166_bC), new ItemStack((IItemProvider)ModBlocks.CABLE), new ItemStack((IItemProvider)Blocks.field_150453_bW), new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT));
        this.createShapedRecipeFileItem("AAA", "BCB", "AAA", new ItemStack((IItemProvider)ModBlocks.PLANTFARM), 1, new ItemStack((IItemProvider)ModBlocks.PLANTIUM_BLOCK), new ItemStack((IItemProvider)ModBlocks.CABLE), new ItemStack((IItemProvider)Items.field_151012_L));
        this.createShapedRecipeFileItem(" A ", "ABA", " A ", new ItemStack((IItemProvider)ModBlocks.CABLE), 16, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)ModBlocks.PLANTIUM_BLOCK));
        this.createShapedRecipeFileItem("ABA", "A A", "AAA", new ItemStack((IItemProvider)ModItems.DNA_CONTAINER_EMPTY), 16, new ItemStack((IItemProvider)Blocks.field_150410_aZ), new ItemStack((IItemProvider)Blocks.field_196666_p));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((IItemProvider)ModBlocks.DNA_CLEANER), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151145_ak), new ItemStack((IItemProvider)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((IItemProvider)ModBlocks.DNA_EXTRACTOR), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151012_L), new ItemStack((IItemProvider)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((IItemProvider)ModBlocks.DNA_COMBINER), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151047_v), new ItemStack((IItemProvider)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((IItemProvider)ModBlocks.DNA_REMOVER), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151056_x), new ItemStack((IItemProvider)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("ABA", "ACA", "AAA", new ItemStack((IItemProvider)ModBlocks.SEEDCONSTRUCTOR), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Items.field_151046_w), new ItemStack((IItemProvider)ModItems.DNA_CONTAINER_EMPTY));
        this.createShapedRecipeFileItem("AAA", "B B", "CCC", new ItemStack((IItemProvider)ModBlocks.COMPRESSOR), 1, new ItemStack((IItemProvider)ModItems.PLANTIUM_INGOT), new ItemStack((IItemProvider)Blocks.field_150331_J), new ItemStack((IItemProvider)ModBlocks.PLANTIUM_BLOCK));
        this.createShapedRecipeFileItem(" A ", "ABA", " A ", new ItemStack((IItemProvider)ModItems.GUIDE_OVERVIEW), 1, new ItemStack((IItemProvider)Items.field_151014_N), new ItemStack((IItemProvider)Items.field_151122_aG));
        this.createShapedRecipeFileItem(" A ", "ABA", " A ", new ItemStack((IItemProvider)ModItems.GUIDE_PLANTS), 1, new ItemStack((IItemProvider)Items.field_151080_bb), new ItemStack((IItemProvider)Items.field_151122_aG));
        this.createShapedRecipeFileItem(" A ", "ABA", " A ", new ItemStack((IItemProvider)ModItems.GUIDE_GENETIC_ENGINEERING), 1, new ItemStack((IItemProvider)Items.field_151081_bc), new ItemStack((IItemProvider)Items.field_151122_aG));
    }
}

