/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.items.upgradeable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import net.kaneka.planttech2.container.ItemUpgradeableContainer;
import net.kaneka.planttech2.energy.BioEnergyStorage;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.items.BaseItem;
import net.kaneka.planttech2.items.upgradeable.IUpgradeable;
import net.kaneka.planttech2.items.upgradeable.InventoryEnergyProvider;
import net.kaneka.planttech2.items.upgradeable.UpgradeChipItem;
import net.kaneka.planttech2.utilities.NBTHelper;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BaseUpgradeableItem
extends BaseItem
implements IItemChargeable,
IUpgradeable {
    private int basecapacity;
    private int maxInvSize;
    private int slotId;
    private float baseAttack;
    private float baseAttackSpeed;

    public BaseUpgradeableItem(String name, Item.Properties property, int basecapacity, int maxInvSize, float baseAttack, float baseAttackSpeed, int slotId) {
        super(name, property);
        this.basecapacity = basecapacity;
        this.maxInvSize = maxInvSize;
        this.baseAttack = baseAttack;
        this.baseAttackSpeed = baseAttackSpeed;
        this.slotId = slotId;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new InventoryEnergyProvider(this.basecapacity, this.maxInvSize);
    }

    @Override
    public int extractEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = BaseUpgradeableItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.extractEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int receiveEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage storage = BaseUpgradeableItem.getEnergyCap(stack);
        if (storage != null) {
            int returnvalue = storage.receiveEnergy(amount, simulate);
            this.updateEnergy(stack);
            return returnvalue;
        }
        return 0;
    }

    @Override
    public int maxEnergy(ItemStack stack) {
        IEnergyStorage storage = BaseUpgradeableItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public int currentEnergy(ItemStack stack) {
        IEnergyStorage storage = BaseUpgradeableItem.getEnergyCap(stack);
        if (storage != null) {
            return storage.getEnergyStored();
        }
        return 0;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!((PlayerEntity)attacker).field_71075_bZ.field_75098_d) {
            this.extractEnergy(stack, BaseUpgradeableItem.getEnergyCost(stack), false);
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f && !((PlayerEntity)entityLiving).field_71075_bZ.field_75098_d) {
            this.extractEnergy(stack, BaseUpgradeableItem.getEnergyCost(stack), false);
            this.updateEnergy(stack);
        }
        return true;
    }

    protected static int getEnergyCost(ItemStack stack) {
        return 20 + NBTHelper.getIntSave(stack, "energycost", 0);
    }

    private double getAttackSpeed(ItemStack stack) {
        return Math.min((double)(this.baseAttackSpeed + NBTHelper.getFloatSave(stack, "attackspeed", 0)), -0.4);
    }

    private double getAttDamage(ItemStack stack) {
        return Math.min(this.baseAttack + NBTHelper.getFloatSave(stack, "attack", 0), UpgradeChipItem.getAttackMax());
    }

    public static IEnergyStorage getEnergyCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityEnergy.ENERGY);
        if (provider.isPresent()) {
            return (IEnergyStorage)provider.orElse(null);
        }
        return null;
    }

    public static IItemHandler getInvCap(ItemStack stack) {
        LazyOptional provider = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (provider.isPresent()) {
            return (IItemHandler)provider.orElse(null);
        }
        return null;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.getAttDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected void updateEnergy(ItemStack stack) {
        IEnergyStorage storage;
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        if ((storage = BaseUpgradeableItem.getEnergyCap(stack)) instanceof BioEnergyStorage) {
            tag.func_74768_a("current_energy", ((BioEnergyStorage)storage).getEnergyStored());
            tag.func_74768_a("max_energy", ((BioEnergyStorage)storage).getMaxEnergyStored());
        }
        stack.func_77982_d(tag);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.energy", new Object[]{tag.func_74762_e("current_energy") + "/" + tag.func_74762_e("max_energy")}));
            tooltip.add((ITextComponent)new TranslationTextComponent("info.energycosts", new Object[]{BaseUpgradeableItem.getEnergyCost(stack)}));
            tooltip.add((ITextComponent)new TranslationTextComponent("info.openwithshift", new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !(this.getDurabilityForDisplay(stack) >= 1.0);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            return 1.0 - (double)tag.func_74762_e("current_energy") / (double)tag.func_74762_e("max_energy");
        }
        return 1.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return Integer.parseInt("06bc00", 16);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public static int getInventorySize(ItemStack stack) {
        IItemHandler handler = BaseUpgradeableItem.getInvCap(stack);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && !world.field_72995_K && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new NamedContainerProvider(stack), buffer -> buffer.func_150788_a(stack));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public void updateNBTValues(ItemStack stack) {
        IItemHandler inv = BaseUpgradeableItem.getInvCap(stack);
        if (inv != null) {
            int energyCost = 0;
            int increaseCapacity = 0;
            int energyProduction = 0;
            int increaseHarvestlevel = 0;
            float increaseAttack = 0.0f;
            float increaseAttackSpeed = 0.0f;
            float increaseBreakdownRate = 0.0f;
            boolean unlockShovelFeat = false;
            boolean unlockAxeFeat = false;
            boolean unlockHoeFeat = false;
            boolean unlockShearsFeat = false;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack slot = inv.getStackInSlot(i);
                if (slot.func_190926_b() || !(slot.func_77973_b() instanceof UpgradeChipItem)) continue;
                UpgradeChipItem item = (UpgradeChipItem)slot.func_77973_b();
                energyCost += item.getEnergyCost();
                increaseCapacity += item.getIncreaseCapacity();
                energyProduction += item.getEnergyProduction();
                increaseHarvestlevel += item.getIncreaseHarvestlevel();
                increaseAttack += item.getIncreaseAttack();
                increaseAttackSpeed += item.getIncreaseAttackSpeed();
                increaseBreakdownRate += item.getIncreaseBreakdownRate();
                if (item.isUnlockShovelFeat()) {
                    unlockShovelFeat = true;
                }
                if (item.isUnlockAxeFeat()) {
                    unlockAxeFeat = true;
                }
                if (item.isUnlockHoeFeat()) {
                    unlockHoeFeat = true;
                }
                if (item.isUnlockShearsFeat()) {
                    unlockShearsFeat = true;
                }
                Enchantment ench = item.getEnchantment();
                if (!item.isAllowed(this.getSlotId()) || ench == null) continue;
                if (enchantments.containsKey(ench)) {
                    int nextlevel = (Integer)enchantments.get(ench) + 1;
                    enchantments.put(ench, nextlevel);
                    continue;
                }
                enchantments.put(ench, 1);
            }
            stack.func_77986_q().clear();
            for (Enchantment ench : enchantments.keySet()) {
                int level = (Integer)enchantments.get(ench);
                if (ench.func_77325_b() < level) {
                    stack.func_77966_a(ench, ench.func_77325_b());
                    continue;
                }
                stack.func_77966_a(ench, level);
            }
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            nbt.func_74768_a("energycost", energyCost);
            nbt.func_74768_a("energyproduction", energyProduction);
            nbt.func_74768_a("harvestlevel", increaseHarvestlevel);
            nbt.func_74776_a("attack", increaseAttack);
            nbt.func_74776_a("attackspeed", increaseAttackSpeed);
            nbt.func_74776_a("breakdownrate", increaseBreakdownRate);
            nbt.func_74757_a("unlockshovel", unlockShovelFeat);
            nbt.func_74757_a("unlockaxe", unlockAxeFeat);
            nbt.func_74757_a("unlockhoe", unlockHoeFeat);
            nbt.func_74757_a("unlockshears", unlockShearsFeat);
            stack.func_77982_d(nbt);
            IEnergyStorage energy = BaseUpgradeableItem.getEnergyCap(stack);
            if (energy != null && energy instanceof BioEnergyStorage) {
                ((BioEnergyStorage)energy).setEnergyMaxStored(this.basecapacity + increaseCapacity);
                this.updateEnergy(stack);
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && !stack.func_190926_b() && world.func_82737_E() % 200L == 0L) {
            this.receiveEnergy(stack, NBTHelper.getIntSave(stack, "energyproduction", 0), false);
        }
    }

    @Override
    public int getSlotId() {
        return this.slotId;
    }

    public static class NamedContainerProvider
    implements INamedContainerProvider {
        private final ItemStack stack;

        public NamedContainerProvider(ItemStack stack) {
            this.stack = stack;
        }

        public Container createMenu(int id, PlayerInventory inv, PlayerEntity entity) {
            return new ItemUpgradeableContainer(id, inv, this.stack);
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.upgradeableitem", new Object[0]);
        }
    }
}

