/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.kaneka.planttech2.container.CompressorContainer;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.CompressorRecipe;
import net.kaneka.planttech2.registries.ModTileEntities;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyInventoryTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class CompressorTileEntity
extends EnergyInventoryTileEntity {
    private int ticksPassed = 0;
    private int selectedId = -1;
    private HashMap<Integer, Pair<ItemStack, Integer>> recipeList = new HashMap();
    private ItemStack previousInput = null;
    private RangedWrapper inputs;
    private RangedWrapper outputs;
    private LazyOptional<IItemHandler> inputs_provider;
    private LazyOptional<IItemHandler> outputs_provider;
    protected final IIntArray field_array = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return CompressorTileEntity.this.energystorage.getEnergyStored();
                }
                case 1: {
                    return CompressorTileEntity.this.energystorage.getMaxEnergyStored();
                }
                case 2: {
                    return CompressorTileEntity.this.ticksPassed;
                }
                case 3: {
                    return CompressorTileEntity.this.selectedId;
                }
                case 4: {
                    return CompressorTileEntity.this.field_174879_c.func_177958_n();
                }
                case 5: {
                    return CompressorTileEntity.this.field_174879_c.func_177956_o();
                }
                case 6: {
                    return CompressorTileEntity.this.field_174879_c.func_177952_p();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    CompressorTileEntity.this.energystorage.setEnergyStored(value);
                    break;
                }
                case 1: {
                    CompressorTileEntity.this.energystorage.setEnergyMaxStored(value);
                    break;
                }
                case 2: {
                    CompressorTileEntity.this.ticksPassed = value;
                    break;
                }
                case 3: {
                    CompressorTileEntity.this.selectedId = value;
                    break;
                }
                case 4: {
                    BlockPos newPos = new BlockPos(value, CompressorTileEntity.this.field_174879_c.func_177956_o(), CompressorTileEntity.this.field_174879_c.func_177952_p());
                    CompressorTileEntity.this.field_174879_c = newPos;
                    break;
                }
                case 5: {
                    BlockPos newPos2 = new BlockPos(CompressorTileEntity.this.field_174879_c.func_177958_n(), value, CompressorTileEntity.this.field_174879_c.func_177952_p());
                    CompressorTileEntity.this.field_174879_c = newPos2;
                    break;
                }
                case 6: {
                    BlockPos newPos3 = new BlockPos(CompressorTileEntity.this.field_174879_c.func_177958_n(), CompressorTileEntity.this.field_174879_c.func_177956_o(), value);
                    CompressorTileEntity.this.field_174879_c = newPos3;
                }
            }
        }

        public int func_221478_a() {
            return 7;
        }
    };

    public CompressorTileEntity() {
        super(ModTileEntities.COMPRESSOR_TE, 1000, 25);
        this.inputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 0, 1);
        this.outputs = new RangedWrapper((IItemHandlerModifiable)this.itemhandler, 1, 2);
        this.inputs_provider = LazyOptional.of(() -> this.inputs);
        this.outputs_provider = LazyOptional.of(() -> this.outputs);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.outputs_provider.cast();
            }
            if (facing != null) {
                return this.inputs_provider.cast();
            }
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void doUpdate() {
        if (this.energystorage.getEnergyStored() > this.energyPerTick()) {
            ItemStack stack1 = this.itemhandler.getStackInSlot(0);
            ItemStack stack2 = this.itemhandler.getStackInSlot(1);
            if (!stack1.func_190926_b() && this.selectedId >= 0) {
                if (this.recipeList != null) {
                    if (!this.recipeList.isEmpty() && this.recipeList.size() > this.selectedId) {
                        Pair<ItemStack, Integer> recipe = this.recipeList.get(this.selectedId);
                        int neededInput = (Integer)recipe.getValue();
                        ItemStack stackOutput = ((ItemStack)recipe.getKey()).func_77946_l();
                        if (neededInput <= stack1.func_190916_E()) {
                            this.previousInput = stack1;
                            if (this.ticksPassed < this.ticksPerItem()) {
                                ++this.ticksPassed;
                                this.energystorage.extractEnergy(this.energyPerTick(), false);
                            } else if (stack2.func_190926_b()) {
                                this.itemhandler.setStackInSlot(1, stackOutput);
                                this.energystorage.extractEnergy(this.energyPerTick(), false);
                                stack1.func_190918_g(neededInput);
                                this.ticksPassed = 0;
                            } else if (stack2.func_77973_b() == stackOutput.func_77973_b() && stack2.func_77976_d() >= stack2.func_190916_E() + stackOutput.func_190916_E()) {
                                stack2.func_190917_f(stackOutput.func_190916_E());
                                this.energystorage.extractEnergy(this.energyPerTick(), false);
                                stack1.func_190918_g(neededInput);
                                this.ticksPassed = 0;
                            }
                        }
                    } else {
                        this.selectedId = -1;
                    }
                } else if (this.selectedId >= 0) {
                    this.initRecipeList();
                }
            }
        }
        this.doEnergyLoop();
    }

    @Override
    public IIntArray getIntArray() {
        return this.field_array;
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId;
    }

    public void setRecipe() {
        if (this.previousInput == null) {
            this.selectedId = -2;
            this.initRecipeList();
        } else if (this.previousInput.func_77973_b() != this.itemhandler.getStackInSlot(0).func_77973_b()) {
            this.selectedId = -2;
            this.initRecipeList();
        }
    }

    public void initRecipeList() {
        for (int i = 0; i < 20; ++i) {
            this.itemhandler.setStackInSlot(i + 3, ItemStack.field_190927_a);
        }
        HashMap<Integer, Pair> temprecipeList = new HashMap<Integer, Pair>();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        this.recipeList = new HashMap();
        ItemStack particleStack = this.itemhandler.getStackInSlot(0);
        if (!particleStack.func_190926_b()) {
            CompressorRecipe compRecipe;
            Item particle = particleStack.func_77973_b();
            if (this.field_145850_b != null) {
                for (IRecipe recipe : this.field_145850_b.func_199532_z().func_199510_b()) {
                    if (recipe.func_222127_g() != ModRecipeTypes.COMPRESSING || (compRecipe = (CompressorRecipe)recipe).getInput().func_77973_b() != particle) continue;
                    temprecipeList.put(Item.func_150891_b((Item)compRecipe.func_77571_b().func_77973_b()), Pair.of((Object)compRecipe.func_77571_b(), (Object)compRecipe.getAmountInput()));
                    keys.add(Item.func_150891_b((Item)compRecipe.func_77571_b().func_77973_b()));
                }
            } else {
                for (IRecipe recipe : Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b()) {
                    if (recipe.func_222127_g() != ModRecipeTypes.COMPRESSING || (compRecipe = (CompressorRecipe)recipe).getInput().func_77973_b() != particle) continue;
                    temprecipeList.put(Item.func_150891_b((Item)compRecipe.func_77571_b().func_77973_b()), Pair.of((Object)compRecipe.func_77571_b(), (Object)compRecipe.getAmountInput()));
                    keys.add(Item.func_150891_b((Item)compRecipe.func_77571_b().func_77973_b()));
                }
            }
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            this.recipeList.put(i, (Pair<ItemStack, Integer>)temprecipeList.get(keys.get(i)));
            this.itemhandler.setStackInSlot(i + 3, (ItemStack)((Pair)temprecipeList.get(keys.get(i))).getLeft());
        }
        this.ticksPassed = 0;
    }

    public int energyPerTick() {
        return 4 + this.getUpgradeTier(3, 2) * 4;
    }

    public int ticksPerItem() {
        return 200 - this.getUpgradeTier(3, 2) * 35;
    }

    @Override
    public String getNameString() {
        return "compressor";
    }

    @Override
    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        for (int i = 0; i < 3; ++i) {
            stack.add(this.itemhandler.getStackInSlot(i).func_77946_l());
        }
        return stack;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("tickspassed", this.ticksPassed);
        compound.func_74768_a("selectedId", this.selectedId);
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.ticksPassed = compound.func_74762_e("tickspassed");
        this.selectedId = compound.func_74762_e("selectedId");
        super.func_145839_a(compound);
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new CompressorContainer(id, inv, this);
    }

    @Override
    public int getEnergyInSlot() {
        return 23;
    }

    @Override
    public int getEnergyOutSlot() {
        return 24;
    }
}

