/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.tileentity.machine.baseclasses;

import java.util.ArrayList;
import java.util.List;
import net.kaneka.planttech2.energy.IItemChargeable;
import net.kaneka.planttech2.items.TierItem;
import net.kaneka.planttech2.tileentity.machine.baseclasses.EnergyTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class EnergyInventoryTileEntity
extends EnergyTileEntity {
    protected ItemStackHandler itemhandler;
    protected LazyOptional<IItemHandler> inventoryCap;

    public EnergyInventoryTileEntity(TileEntityType<?> type, int energyStorage, int invSize) {
        super(type, energyStorage);
        this.itemhandler = new ItemStackHandler(invSize);
        this.inventoryCap = LazyOptional.of(() -> this.itemhandler);
    }

    public List<ItemStack> getInventoryContent() {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemhandler.getSlots(); ++i) {
            stack.add(this.itemhandler.getStackInSlot(i).func_77946_l());
        }
        return stack;
    }

    public void doEnergyLoop() {
        ItemStack stack = this.itemhandler.getStackInSlot(this.getEnergyInSlot());
        ItemStack stack2 = this.itemhandler.getStackInSlot(this.getEnergyOutSlot());
        if (stack != null && stack.func_77973_b() instanceof IItemChargeable && this.energystorage.getEnergyStored() < this.energystorage.getMaxEnergyStored()) {
            this.energystorage.receiveEnergy(((IItemChargeable)stack.func_77973_b()).extractEnergy(stack, 1, false));
        }
        if (stack2 != null && stack2.func_77973_b() instanceof IItemChargeable && this.energystorage.getEnergyStored() >= 1) {
            this.energystorage.extractEnergy(((IItemChargeable)stack2.func_77973_b()).receiveEnergy(stack2, 1, false));
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inventory", (INBT)this.itemhandler.serializeNBT());
        super.func_189515_b(compound);
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        int slotamount = this.itemhandler.getSlots();
        this.itemhandler.deserializeNBT(compound.func_74775_l("inventory"));
        if (this.itemhandler.getSlots() != slotamount) {
            this.itemhandler.setSize(slotamount);
        }
        super.func_145839_a(compound);
    }

    public static void spawnAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (!(worldIn.field_72995_K || stack.func_190926_b() || worldIn.restoringBlockSnapshots)) {
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            ItemEntity entityitem = new ItemEntity(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174869_p();
            worldIn.func_217376_c((Entity)entityitem);
        }
    }

    public int getUpgradeTier(int slot, int itemtype) {
        TierItem item;
        ItemStack stack = this.itemhandler.getStackInSlot(slot);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof TierItem && (item = (TierItem)stack.func_77973_b()).getItemType() == itemtype) {
            return item.getTier();
        }
        return 0;
    }

    protected abstract int getEnergyInSlot();

    protected abstract int getEnergyOutSlot();
}

