/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.utilities;

import java.util.List;
import net.kaneka.planttech2.items.CreditCardItem;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;

public class PlayerInventoryUtils {
    public static boolean enoughSpace(PlayerInventory inv, int neededSpace) {
        if (neededSpace <= 0) {
            return true;
        }
        int freeSlots = 0;
        for (int i = 0; i < 36; ++i) {
            if (!inv.func_70301_a(i).func_190926_b() || ++freeSlots < neededSpace) continue;
            return true;
        }
        return false;
    }

    public static boolean hasList(PlayerInventory inv, List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack.func_190926_b() || inv.func_213901_a(stack.func_77973_b()) >= stack.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    public static boolean addList(PlayerInventory inv, List<ItemStack> stacks) {
        boolean flag = true;
        for (ItemStack stack : stacks) {
            if (inv.func_70441_a(stack)) continue;
            flag = false;
        }
        return flag;
    }

    public static boolean removeList(PlayerInventory inv, List<ItemStack> stacks) {
        boolean flag = true;
        for (ItemStack stack : stacks) {
            if (PlayerInventoryUtils.remove(inv, stack)) continue;
            flag = false;
        }
        return flag;
    }

    public static boolean remove(PlayerInventory inv, ItemStack stack) {
        int count = stack.func_190916_E();
        for (int j = 0; j < 36; ++j) {
            ItemStack invstack = inv.func_70301_a(j);
            if (invstack.func_190926_b() || invstack.func_77973_b() != stack.func_77973_b()) continue;
            int k = Math.min(count, invstack.func_190916_E());
            count -= k;
            invstack.func_190918_g(k);
            if (invstack.func_190926_b()) {
                inv.func_70299_a(j, ItemStack.field_190927_a);
            }
            if (count > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean enoughCredits(PlayerInventory inv, int amount) {
        if (amount <= 0) {
            return true;
        }
        int count = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack invstack = inv.func_70301_a(i);
            if (invstack.func_190926_b() || !(invstack.func_77973_b() instanceof CreditCardItem) || (count += CreditCardItem.getCredits(invstack)) < amount) continue;
            return true;
        }
        return false;
    }

    public static boolean removeCredits(PlayerInventory inv, int amount) {
        int count = amount;
        if (count <= 0) {
            return true;
        }
        for (int i = 0; i < 36; ++i) {
            ItemStack invstack = inv.func_70301_a(i);
            if (invstack.func_190926_b() || !(invstack.func_77973_b() instanceof CreditCardItem)) continue;
            int credits = CreditCardItem.getCredits(invstack);
            if ((count -= (credits -= CreditCardItem.shrinkCredits(invstack, count))) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean addCredits(PlayerInventory inv, int amount) {
        for (int i = 0; i < 36; ++i) {
            ItemStack invstack = inv.func_70301_a(i);
            if (invstack.func_190926_b() || !(invstack.func_77973_b() instanceof CreditCardItem)) continue;
            CreditCardItem.addCredits(invstack, amount);
        }
        return false;
    }
}

