/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.playerhopper.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import morethanhidden.playerhopper.PlayerHopper;
import morethanhidden.playerhopper.blocks.PlayerHopperMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class PlayerHopperBlockEntity
extends HopperBlockEntity {
    List<UUID> playerWhitelist = new ArrayList<UUID>();
    List<String> itemBlacklist = new ArrayList<String>();
    PlayerHopperMode mode = PlayerHopperMode.INVENTORY;

    public PlayerHopperBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        int i;
        this.playerWhitelist = new ArrayList<UUID>();
        for (i = 0; i < compound.m_128451_("whitelist_size"); ++i) {
            this.playerWhitelist.add(compound.m_128342_("whitelist_" + i));
        }
        this.itemBlacklist = new ArrayList<String>();
        for (i = 0; i < compound.m_128451_("blacklist_size"); ++i) {
            this.itemBlacklist.add(compound.m_128461_("blacklist_" + i));
        }
        this.mode = PlayerHopperMode.valueOf(compound.m_128461_("mode"));
        super.m_142466_(compound);
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        int i;
        compound.m_128405_("whitelist_size", this.playerWhitelist.size());
        for (i = 0; i < this.playerWhitelist.size(); ++i) {
            compound.m_128362_("whitelist_" + i, this.playerWhitelist.get(i));
        }
        compound.m_128405_("blacklist_size", this.itemBlacklist.size());
        for (i = 0; i < this.itemBlacklist.size(); ++i) {
            compound.m_128359_("blacklist_" + i, this.itemBlacklist.get(i));
        }
        compound.m_128359_("mode", this.mode.name());
        return super.m_6945_(compound);
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, HopperBlockEntity blockEntity) {
        if (!level.f_46443_) {
            --blockEntity.f_59302_;
            blockEntity.f_59303_ = level.m_46467_();
            if (!blockEntity.m_59407_()) {
                blockEntity.m_59395_(0);
                PlayerHopperBlockEntity.m_155578_((Level)level, (BlockPos)pos, (BlockState)state, (HopperBlockEntity)blockEntity, () -> PlayerHopperBlockEntity.pullItems(level, (Hopper)blockEntity, ((PlayerHopperBlockEntity)blockEntity).itemBlacklist, ((PlayerHopperBlockEntity)blockEntity).playerWhitelist, ((PlayerHopperBlockEntity)blockEntity).mode));
            }
        }
    }

    public static boolean pullItems(Level world, Hopper hopper, List<String> itemBlacklist, List<UUID> playerWhitelist, PlayerHopperMode mode) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((Level)world, (Hopper)hopper);
        if (ret != null) {
            return ret;
        }
        Container iinventory = PlayerHopperBlockEntity.getSourceInventory(world, hopper, playerWhitelist);
        if (iinventory instanceof Inventory) {
            boolean output = false;
            Direction direction = Direction.DOWN;
            if (mode.equals((Object)PlayerHopperMode.INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_INVENTORY) || mode.equals((Object)PlayerHopperMode.HOTBAR_INVENTORY)) {
                boolean bl = output = !PlayerHopperBlockEntity.isInventoryEmpty(iinventory, direction) && IntStream.range(9, 36).anyMatch(slot -> PlayerHopperBlockEntity.pullItemFromSlot(hopper, iinventory, slot, direction, itemBlacklist));
            }
            if (mode.equals((Object)PlayerHopperMode.HOTBAR) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR)) {
                boolean bl = output = !PlayerHopperBlockEntity.isInventoryEmpty(iinventory, direction) && IntStream.range(0, 9).anyMatch(slot -> PlayerHopperBlockEntity.pullItemFromSlot(hopper, iinventory, slot, direction, itemBlacklist)) || output;
            }
            if (mode.equals((Object)PlayerHopperMode.ARMOR) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR)) {
                output = !PlayerHopperBlockEntity.isInventoryEmpty(iinventory, direction) && IntStream.range(36, 42).anyMatch(slot -> PlayerHopperBlockEntity.pullItemFromSlot(hopper, iinventory, slot, direction, itemBlacklist)) || output;
            }
            return output;
        }
        for (ItemEntity itementity : PlayerHopperBlockEntity.m_155589_((Level)world, (Hopper)hopper)) {
            if (!PlayerHopperBlockEntity.m_59331_((Container)hopper, (ItemEntity)itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean pullItemFromSlot(Hopper hopper, Container inventoryIn, int index, Direction direction, List<String> itemBlacklist) {
        ItemStack itemstack = inventoryIn.m_8020_(index);
        if (!itemstack.m_41619_() && !itemBlacklist.contains(itemstack.m_41720_().m_5524_())) {
            ItemStack itemstack1 = itemstack.m_41777_();
            ItemStack itemstack2 = PlayerHopperBlockEntity.m_59326_((Container)inventoryIn, (Container)hopper, (ItemStack)inventoryIn.m_7407_(index, 1), (Direction)null);
            if (itemstack2.m_41619_()) {
                inventoryIn.m_6596_();
                return true;
            }
            inventoryIn.m_6836_(index, itemstack1);
        }
        return false;
    }

    private static boolean isInventoryEmpty(Container inventoryIn, Direction side) {
        return IntStream.range(0, inventoryIn.m_6643_()).allMatch(i -> inventoryIn.m_8020_(i).m_41619_());
    }

    @Nullable
    public static Container getSourceInventory(Level world, Hopper hopper, List<UUID> playerWhitelist) {
        Player player;
        if (world != null && (player = world.m_45924_(hopper.m_6343_(), hopper.m_6358_(), hopper.m_6446_(), 1.0, false)) != null && playerWhitelist.contains(player.m_142081_())) {
            return player.m_150109_();
        }
        return null;
    }

    public BlockEntityType<?> m_58903_() {
        return PlayerHopper.PLAYER_HOPPER_TETYPE;
    }
}

