/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.playerhopper.blocks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import morethanhidden.playerhopper.blocks.PlayerHopperMode;
import morethanhidden.playerhopper.blocks.PlayerHopperTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class PlayerHopperBlock
extends BlockHopper {
    private static final Map<EnumFacing, List<AxisAlignedBB>> AABB_MAP = new HashMap<EnumFacing, List<AxisAlignedBB>>(){
        {
            AxisAlignedBB[] hopperBox = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.625, 0.75)};
            this.put(EnumFacing.DOWN, Arrays.asList(hopperBox[0], hopperBox[1], new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625)));
            this.put(EnumFacing.NORTH, Arrays.asList(hopperBox[0], hopperBox[1], new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.5, 0.25)));
            this.put(EnumFacing.SOUTH, Arrays.asList(hopperBox[0], hopperBox[1], new AxisAlignedBB(0.375, 0.25, 0.75, 0.625, 0.5, 1.0)));
            this.put(EnumFacing.EAST, Arrays.asList(hopperBox[0], hopperBox[1], new AxisAlignedBB(0.0, 0.25, 0.375, 0.25, 0.5, 0.625)));
            this.put(EnumFacing.WEST, Arrays.asList(hopperBox[0], hopperBox[1], new AxisAlignedBB(0.75, 0.25, 0.375, 1.0, 0.5, 0.625)));
        }
    };

    public PlayerHopperBlock() {
        this.setRegistryName("playerhopper", "playerhopper");
        this.func_149663_c("playerhopper");
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149752_b(8.0f);
        this.func_149711_c(3.0f);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PlayerHopperTileEntity) {
            ((PlayerHopperTileEntity)tileentity).playerWhitelist.add(placer.func_110124_au());
            tileentity.func_70296_d();
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return AABB_MAP.get(blockState.func_177229_b((IProperty)BlockHopper.field_176430_a)).stream().map(s -> this.func_185503_a(pos, start, end, (AxisAlignedBB)s)).anyMatch(Objects::nonNull) ? super.func_180636_a(blockState, worldIn, pos, start, end) : null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof PlayerHopperTileEntity && !worldIn.field_72995_K && playerIn.func_184614_ca().func_190926_b()) {
                if (((PlayerHopperTileEntity)tileentity).playerWhitelist.contains(playerIn.func_110124_au())) {
                    ((PlayerHopperTileEntity)tileentity).playerWhitelist.remove(playerIn.func_110124_au());
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("playerhopper.player.removed", new Object[0]));
                } else {
                    ((PlayerHopperTileEntity)tileentity).playerWhitelist.add(playerIn.func_110124_au());
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("playerhopper.player.added", new Object[0]));
                }
                tileentity.func_70296_d();
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tileentity;
        if (playerIn.func_70093_af() && !playerIn.func_184614_ca().func_190926_b()) {
            TileEntity tileentity2 = worldIn.func_175625_s(pos);
            if (tileentity2 instanceof PlayerHopperTileEntity && !worldIn.field_72995_K) {
                String itemName = playerIn.func_184614_ca().func_77973_b().func_77658_a();
                if (((PlayerHopperTileEntity)tileentity2).itemBlacklist.contains(itemName)) {
                    ((PlayerHopperTileEntity)tileentity2).itemBlacklist.remove(itemName);
                    playerIn.func_145747_a(new TextComponentTranslation("playerhopper.item.removed.begin", new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation(itemName + ".name", new Object[0])).func_150257_a((ITextComponent)new TextComponentTranslation("playerhopper.item.removed.end", new Object[0])));
                } else {
                    ((PlayerHopperTileEntity)tileentity2).itemBlacklist.add(itemName);
                    playerIn.func_145747_a(new TextComponentTranslation("playerhopper.item.added.begin", new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation(itemName + ".name", new Object[0])).func_150257_a((ITextComponent)new TextComponentTranslation("playerhopper.item.added.end", new Object[0])));
                }
            }
        } else if (playerIn.func_70093_af() && playerIn.func_184614_ca().func_190926_b() && (tileentity = worldIn.func_175625_s(pos)) instanceof PlayerHopperTileEntity && !worldIn.field_72995_K) {
            int currentMode = ((PlayerHopperTileEntity)tileentity).mode.ordinal();
            int newMode = currentMode == PlayerHopperMode.values().length - 1 ? 0 : currentMode + 1;
            ((PlayerHopperTileEntity)tileentity).mode = PlayerHopperMode.values()[newMode];
            playerIn.func_145747_a(new TextComponentTranslation("playerhopper.modechange", new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation("playerhopper.mode." + ((PlayerHopperTileEntity)tileentity).mode.name().toLowerCase(), new Object[0])));
            tileentity.func_70296_d();
        }
        super.func_180649_a(worldIn, pos, playerIn);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new PlayerHopperTileEntity();
    }
}

