/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.playerhopper.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import morethanhidden.playerhopper.blocks.PlayerHopperMode;
import net.minecraft.block.BlockHopper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class PlayerHopperTileEntity
extends TileEntityHopper {
    List<UUID> playerWhitelist = new ArrayList<UUID>();
    List<String> itemBlacklist = new ArrayList<String>();
    PlayerHopperMode mode = PlayerHopperMode.INVENTORY;

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        this.playerWhitelist = new ArrayList<UUID>();
        for (i = 0; i < compound.func_74762_e("whitelist_size"); ++i) {
            this.playerWhitelist.add(compound.func_186857_a("whitelist_" + i));
        }
        this.itemBlacklist = new ArrayList<String>();
        for (i = 0; i < compound.func_74762_e("blacklist_size"); ++i) {
            this.itemBlacklist.add(compound.func_74779_i("blacklist_" + i));
        }
        this.mode = PlayerHopperMode.valueOf(compound.func_74779_i("mode"));
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        int i;
        compound.func_74768_a("whitelist_size", this.playerWhitelist.size());
        for (i = 0; i < this.playerWhitelist.size(); ++i) {
            compound.func_186854_a("whitelist_" + i, this.playerWhitelist.get(i));
        }
        compound.func_74768_a("blacklist_size", this.itemBlacklist.size());
        for (i = 0; i < this.itemBlacklist.size(); ++i) {
            compound.func_74778_a("blacklist_" + i, this.itemBlacklist.get(i));
        }
        compound.func_74778_a("mode", this.mode.name());
        return super.func_189515_b(compound);
    }

    protected boolean func_145887_i() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (!this.func_145888_j() && BlockHopper.func_149917_c((int)this.func_145832_p())) {
                boolean flag = false;
                if (!this.func_152104_k()) {
                    flag = this.func_145883_k();
                }
                if (!this.func_152105_l()) {
                    boolean bl = flag = PlayerHopperTileEntity.pullItems((IHopper)this, this.playerWhitelist, this.itemBlacklist, this.mode) || flag;
                }
                if (flag) {
                    this.func_145896_c(8);
                    this.func_70296_d();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean pullItems(IHopper hopper, List<UUID> playerWhitelist, List<String> itemBlacklist, PlayerHopperMode mode) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)hopper);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = PlayerHopperTileEntity.getSourceInventory(hopper, playerWhitelist);
        if (iinventory instanceof InventoryPlayer) {
            boolean output = false;
            if (mode.equals((Object)PlayerHopperMode.INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_INVENTORY) || mode.equals((Object)PlayerHopperMode.HOTBAR_INVENTORY)) {
                boolean bl = output = !PlayerHopperTileEntity.isInventoryEmpty(iinventory) && IntStream.range(9, 36).anyMatch(slot -> PlayerHopperTileEntity.pullItemFromSlot(hopper, iinventory, slot, itemBlacklist));
            }
            if (mode.equals((Object)PlayerHopperMode.HOTBAR) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR)) {
                boolean bl = output = !PlayerHopperTileEntity.isInventoryEmpty(iinventory) && IntStream.range(0, 9).anyMatch(slot -> PlayerHopperTileEntity.pullItemFromSlot(hopper, iinventory, slot, itemBlacklist)) || output;
            }
            if (mode.equals((Object)PlayerHopperMode.ARMOR) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR)) {
                output = !PlayerHopperTileEntity.isInventoryEmpty(iinventory) && IntStream.range(36, 42).anyMatch(slot -> PlayerHopperTileEntity.pullItemFromSlot(hopper, iinventory, slot, itemBlacklist)) || output;
            }
            return output;
        }
        for (EntityItem itementity : PlayerHopperTileEntity.func_184292_a((World)hopper.func_145831_w(), (double)hopper.func_96107_aA(), (double)hopper.func_96109_aB(), (double)hopper.func_96108_aC())) {
            if (!PlayerHopperTileEntity.captureItem((IInventory)hopper, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean captureItem(IInventory inventory, EntityItem item) {
        boolean flag = false;
        ItemStack itemstack = item.func_92059_d().func_77946_l();
        ItemStack itemstack1 = PlayerHopperTileEntity.func_174918_a(null, (IInventory)inventory, (ItemStack)itemstack, null);
        if (itemstack1.func_190926_b()) {
            flag = true;
            item.func_92058_a(ItemStack.field_190927_a);
        } else {
            item.func_92058_a(itemstack1);
        }
        return flag;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventoryIn, int index, List<String> itemBlacklist) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && !itemBlacklist.contains(itemstack.func_77973_b().func_77658_a())) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = PlayerHopperTileEntity.func_174918_a((IInventory)inventoryIn, (IInventory)hopper, (ItemStack)inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn) {
        return IntStream.range(0, inventoryIn.func_70302_i_()).allMatch(i -> inventoryIn.func_70301_a(i).func_190926_b());
    }

    private static IInventory getSourceInventory(IHopper hopper, List<UUID> playerWhitelist) {
        EntityPlayer player = hopper.func_145831_w().func_184137_a(hopper.func_96107_aA(), hopper.func_96109_aB(), hopper.func_96108_aC(), 1.0, false);
        if (player != null && playerWhitelist.contains(player.func_110124_au())) {
            return player.field_71071_by;
        }
        return null;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

