/*
 * Decompiled with CFR 0.152.
 */
package morethanhidden.playerhopper.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import morethanhidden.playerhopper.PlayerHopper;
import morethanhidden.playerhopper.blocks.PlayerHopperMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class PlayerHopperTileEntity
extends HopperTileEntity {
    List<UUID> playerWhitelist = new ArrayList<UUID>();
    List<String> itemBlacklist = new ArrayList<String>();
    PlayerHopperMode mode = PlayerHopperMode.INVENTORY;

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        int i;
        this.playerWhitelist = new ArrayList<UUID>();
        for (i = 0; i < compound.func_74762_e("whitelist_size"); ++i) {
            this.playerWhitelist.add(compound.func_186857_a("whitelist_" + i));
        }
        this.itemBlacklist = new ArrayList<String>();
        for (i = 0; i < compound.func_74762_e("blacklist_size"); ++i) {
            this.itemBlacklist.add(compound.func_74779_i("blacklist_" + i));
        }
        this.mode = PlayerHopperMode.valueOf(compound.func_74779_i("mode"));
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        int i;
        compound.func_74768_a("whitelist_size", this.playerWhitelist.size());
        for (i = 0; i < this.playerWhitelist.size(); ++i) {
            compound.func_186854_a("whitelist_" + i, this.playerWhitelist.get(i));
        }
        compound.func_74768_a("blacklist_size", this.itemBlacklist.size());
        for (i = 0; i < this.itemBlacklist.size(); ++i) {
            compound.func_74778_a("blacklist_" + i, this.itemBlacklist.get(i));
        }
        compound.func_74778_a("mode", this.mode.name());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.field_145901_j;
            this.field_190578_g = this.field_145850_b.func_82737_E();
            if (!this.func_145888_j()) {
                this.func_145896_c(0);
                this.func_200109_a(() -> PlayerHopperTileEntity.pullItems((IHopper)this, this.itemBlacklist, this.playerWhitelist, this.mode));
            }
        }
    }

    public static boolean pullItems(IHopper hopper, List<String> itemBlacklist, List<UUID> playerWhitelist, PlayerHopperMode mode) {
        Boolean ret = VanillaInventoryCodeHooks.extractHook((IHopper)hopper);
        if (ret != null) {
            return ret;
        }
        IInventory iinventory = PlayerHopperTileEntity.getSourceInventory(hopper, playerWhitelist);
        if (iinventory instanceof PlayerInventory) {
            boolean output = false;
            Direction direction = Direction.DOWN;
            if (mode.equals((Object)PlayerHopperMode.INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_INVENTORY) || mode.equals((Object)PlayerHopperMode.HOTBAR_INVENTORY)) {
                boolean bl = output = !PlayerHopperTileEntity.isInventoryEmpty(iinventory, direction) && IntStream.range(9, 36).anyMatch(slot -> PlayerHopperTileEntity.pullItemFromSlot(hopper, iinventory, slot, direction, itemBlacklist));
            }
            if (mode.equals((Object)PlayerHopperMode.HOTBAR) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR)) {
                boolean bl = output = !PlayerHopperTileEntity.isInventoryEmpty(iinventory, direction) && IntStream.range(0, 9).anyMatch(slot -> PlayerHopperTileEntity.pullItemFromSlot(hopper, iinventory, slot, direction, itemBlacklist)) || output;
            }
            if (mode.equals((Object)PlayerHopperMode.ARMOR) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_INVENTORY) || mode.equals((Object)PlayerHopperMode.ARMOR_HOTBAR)) {
                output = !PlayerHopperTileEntity.isInventoryEmpty(iinventory, direction) && IntStream.range(36, 42).anyMatch(slot -> PlayerHopperTileEntity.pullItemFromSlot(hopper, iinventory, slot, direction, itemBlacklist)) || output;
            }
            return output;
        }
        for (ItemEntity itementity : PlayerHopperTileEntity.func_200115_c((IHopper)hopper)) {
            if (!PlayerHopperTileEntity.func_200114_a((IInventory)hopper, (ItemEntity)itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean pullItemFromSlot(IHopper hopper, IInventory inventoryIn, int index, Direction direction, List<String> itemBlacklist) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && !itemBlacklist.contains(itemstack.func_77973_b().func_77658_a())) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = PlayerHopperTileEntity.func_174918_a((IInventory)inventoryIn, (IInventory)hopper, (ItemStack)inventoryIn.func_70298_a(index, 1), (Direction)null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, Direction side) {
        return IntStream.range(0, inventoryIn.func_70302_i_()).allMatch(i -> inventoryIn.func_70301_a(i).func_190926_b());
    }

    @Nullable
    public static IInventory getSourceInventory(IHopper hopper, List<UUID> playerWhitelist) {
        PlayerEntity player;
        if (hopper.func_145831_w() != null && (player = hopper.func_145831_w().func_217366_a(hopper.func_96107_aA(), hopper.func_96109_aB(), hopper.func_96108_aC(), 1.0, false)) != null && playerWhitelist.contains(player.func_110124_au())) {
            return player.field_71071_by;
        }
        return null;
    }

    public TileEntityType<?> func_200662_C() {
        return PlayerHopper.PLAYER_HOPPER_TETYPE;
    }
}

