/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Config.NetherGateConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureNetherGate;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class GuiNetherGate
extends GuiStructure {
    private static final ResourceLocation structureTopDown = new ResourceLocation("prefab", "textures/gui/nether_gate_top_down.png");
    protected NetherGateConfiguration configuration;

    public GuiNetherGate() {
        super("Nether Gate");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.NetherGate;
        this.modifiedInitialXAxis = 213;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        super.preButtonRender(matrixStack, x, y);
        this.bindTexture(structureTopDown);
        GuiStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 164, 108, 164.0f, 108.0f);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y) {
        this.drawSplitString(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 95, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnVisualize) {
            StructureNetherGate structure = (StructureNetherGate)StructureNetherGate.CreateInstance("assets/prefab/structures/nethergate.zip", StructureNetherGate.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            this.closeScreen();
        }
    }

    @Override
    protected void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Nether Gate", NetherGateConfiguration.class);
        this.configuration.pos = this.pos;
        int grayBoxX = this.getCenteredXAxis() - 213;
        int grayBoxY = this.getCenteredYAxis() - 83;
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }
}

