/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Config.ServerModConfiguration;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.Controls.GuiCheckBox;
import com.wuest.prefab.Gui.Controls.GuiTab;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Config.HouseConfiguration;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureAlternateStart;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import java.awt.Color;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiStartHouseChooser
extends GuiTabScreen {
    private static final ResourceLocation backgroundTextures = new ResourceLocation("prefab", "textures/gui/default_background.png");
    protected ExtendedButton btnCancel;
    protected ExtendedButton btnBuild;
    protected ExtendedButton btnVisualize;
    protected ServerModConfiguration serverConfiguration;
    private GuiTab tabGeneral;
    private GuiTab tabConfig;
    private GuiTab tabBlockTypes;
    private ExtendedButton btnHouseStyle;
    private ExtendedButton btnGlassColor;
    private ExtendedButton btnBedColor;
    private GuiCheckBox btnAddTorches;
    private GuiCheckBox btnAddBed;
    private GuiCheckBox btnAddCraftingTable;
    private GuiCheckBox btnAddFurnace;
    private GuiCheckBox btnAddChest;
    private GuiCheckBox btnAddChestContents;
    private GuiCheckBox btnAddMineShaft;
    private boolean allowItemsInChestAndFurnace = true;
    private HouseConfiguration houseConfiguration;

    public GuiStartHouseChooser() {
        this.Tabs.func_230991_b_(256);
        this.modifiedInitialXAxis = 198;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        assert (this.field_230706_i_ != null);
        if (!this.field_230706_i_.field_71439_g.func_184812_l_()) {
            this.allowItemsInChestAndFurnace = !ClientEventHandler.playerConfig.builtStarterHouse;
        }
        this.Initialize();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedValueCoords = this.getAdjustedXYValue();
        int grayBoxX = adjustedValueCoords.getFirst();
        int grayBoxY = adjustedValueCoords.getSecond();
        this.Tabs.field_230690_l_ = adjustedValueCoords.getFirst();
        this.Tabs.field_230691_m_ = adjustedValueCoords.getSecond() - 21;
        this.func_230446_a_(matrixStack);
        assert (this.field_230706_i_ != null);
        this.bindTexture(backgroundTextures);
        this.func_238474_b_(matrixStack, grayBoxX, grayBoxY, 0, 0, 256, 256);
        for (Widget button : this.field_230710_m_) {
            if (button == this.btnCancel || button == this.btnBuild) continue;
            button.field_230694_p_ = false;
        }
        this.btnAddTorches.field_230694_p_ = false;
        this.btnAddBed.field_230694_p_ = false;
        this.btnAddChest.field_230694_p_ = false;
        this.btnAddChestContents.field_230694_p_ = false;
        this.btnAddCraftingTable.field_230694_p_ = false;
        this.btnAddFurnace.field_230694_p_ = false;
        this.btnAddMineShaft.field_230694_p_ = false;
        this.btnBedColor.field_230694_p_ = false;
        if (this.getSelectedTab() == this.tabGeneral) {
            this.btnHouseStyle.field_230694_p_ = true;
            this.btnVisualize.field_230694_p_ = true;
        } else if (this.getSelectedTab() == this.tabConfig) {
            this.btnAddTorches.field_230694_p_ = this.serverConfiguration.addTorches;
            this.btnAddBed.field_230694_p_ = this.serverConfiguration.addBed;
            this.btnAddChest.field_230694_p_ = this.serverConfiguration.addChests;
            this.btnAddChestContents.field_230694_p_ = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents;
            this.btnAddCraftingTable.field_230694_p_ = this.serverConfiguration.addCraftingTable;
            this.btnAddFurnace.field_230694_p_ = this.serverConfiguration.addFurnace;
            this.btnAddMineShaft.field_230694_p_ = this.serverConfiguration.addMineshaft;
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            this.btnGlassColor.field_230694_p_ = this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.SNOWY && this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.DESERT;
            this.btnBedColor.field_230694_p_ = true;
        }
        super.func_230430_a_(matrixStack, x, y, f);
        int color = Color.DARK_GRAY.getRGB();
        if (this.getSelectedTab() == this.tabGeneral) {
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.starter.style.label"), grayBoxX + 10, grayBoxY + 10, color);
            this.drawSplitString(this.houseConfiguration.houseStyle.getHouseNotes(), grayBoxX + 147, grayBoxY + 10, 95, color);
            this.bindTexture(this.houseConfiguration.houseStyle.getHousePicture());
            GuiTabScreen.drawModalRectWithCustomSizedTexture(grayBoxX + 250, grayBoxY, 1, this.houseConfiguration.houseStyle.getImageWidth(), this.houseConfiguration.houseStyle.getImageHeight(), this.houseConfiguration.houseStyle.getImageWidth(), this.houseConfiguration.houseStyle.getImageHeight());
        } else if (this.getSelectedTab() == this.tabBlockTypes) {
            if (this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.SNOWY && this.houseConfiguration.houseStyle != HouseConfiguration.HouseStyle.DESERT) {
                this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.glass"), grayBoxX + 10, grayBoxY + 10, color);
            }
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), grayBoxX + 147, grayBoxY + 10, color);
        }
        if (!CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            this.btnVisualize.field_230694_p_ = false;
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        if (button == this.btnCancel || button == this.btnVisualize || button == this.btnBuild) {
            this.houseConfiguration.addBed = this.serverConfiguration.addBed && this.btnAddBed.func_212942_a();
            this.houseConfiguration.addChest = this.serverConfiguration.addChests && this.btnAddChest.func_212942_a();
            this.houseConfiguration.addChestContents = this.allowItemsInChestAndFurnace && this.serverConfiguration.addChestContents && this.btnAddChestContents.func_212942_a();
            this.houseConfiguration.addCraftingTable = this.serverConfiguration.addCraftingTable && this.btnAddCraftingTable.func_212942_a();
            this.houseConfiguration.addFurnace = this.serverConfiguration.addFurnace && this.btnAddFurnace.func_212942_a();
            this.houseConfiguration.addMineShaft = this.serverConfiguration.addMineshaft && this.btnAddMineShaft.func_212942_a();
            boolean bl = this.houseConfiguration.addTorches = this.serverConfiguration.addTorches && this.btnAddTorches.func_212942_a();
            assert (this.field_230706_i_ != null);
            this.houseConfiguration.houseFacing = this.field_230706_i_.field_71439_g.func_174811_aO().func_176734_d();
        }
        if (button == this.btnCancel) {
            this.closeScreen();
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((Object)new StructureTagMessage(this.houseConfiguration.WriteToCompoundNBT(), StructureTagMessage.EnumStructureConfiguration.StartHouse));
            this.closeScreen();
        } else if (button == this.btnHouseStyle) {
            int id = this.houseConfiguration.houseStyle.getValue() + 1;
            this.houseConfiguration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.LOFT && !this.serverConfiguration.enableLoftHouse) {
                id = this.houseConfiguration.houseStyle.getValue() + 1;
                this.houseConfiguration.houseStyle = HouseConfiguration.HouseStyle.ValueOf(id);
            }
            this.btnHouseStyle.func_238482_a_((ITextComponent)new StringTextComponent(this.houseConfiguration.houseStyle.getDisplayName()));
            if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.HOBBIT) {
                this.houseConfiguration.glassColor = DyeColor.GREEN;
                this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(DyeColor.GREEN)));
            } else if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.LOFT) {
                this.houseConfiguration.glassColor = DyeColor.BLACK;
                this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(DyeColor.BLACK)));
            } else if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                this.houseConfiguration.glassColor = DyeColor.LIGHT_GRAY;
                this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(DyeColor.LIGHT_GRAY)));
            } else if (this.houseConfiguration.houseStyle == HouseConfiguration.HouseStyle.DESERT2) {
                this.houseConfiguration.glassColor = DyeColor.RED;
                this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(DyeColor.RED)));
            } else {
                this.houseConfiguration.glassColor = DyeColor.CYAN;
                this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(DyeColor.CYAN)));
            }
            this.tabBlockTypes.field_230694_p_ = true;
        } else if (button == this.btnGlassColor) {
            this.houseConfiguration.glassColor = DyeColor.func_196056_a((int)(this.houseConfiguration.glassColor.func_196059_a() + 1));
            this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(this.houseConfiguration.glassColor)));
        } else if (button == this.btnBedColor) {
            this.houseConfiguration.bedColor = DyeColor.func_196056_a((int)(this.houseConfiguration.bedColor.func_196059_a() + 1));
            this.btnBedColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(this.houseConfiguration.bedColor)));
        } else if (button == this.btnVisualize) {
            StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.houseConfiguration.houseStyle.getStructureLocation(), StructureAlternateStart.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.houseConfiguration);
            this.closeScreen();
        }
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    @Override
    protected void Initialize() {
        int y;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        int color = Color.DARK_GRAY.getRGB();
        this.serverConfiguration = Prefab.proxy.getServerConfiguration();
        this.houseConfiguration = ClientEventHandler.playerConfig.getClientConfig("Starter House", HouseConfiguration.class);
        this.houseConfiguration.pos = this.pos;
        this.btnHouseStyle = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.houseConfiguration.houseStyle.getDisplayName());
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        int x = grayBoxX + 10;
        int secondColumnY = y = grayBoxY + 10;
        int secondColumnX = x + 137;
        this.btnAddFurnace = this.createAndAddCheckBox(secondColumnX, secondColumnY, GuiLangKeys.translateString("prefab.gui.starter.addfurnace"), this.houseConfiguration.addFurnace, null);
        this.btnAddFurnace.field_230694_p_ = false;
        if (this.serverConfiguration.addFurnace) {
            secondColumnY += 15;
        }
        this.btnAddBed = this.createAndAddCheckBox(secondColumnX, secondColumnY, GuiLangKeys.translateString("prefab.gui.starter.addbed"), this.houseConfiguration.addBed, null);
        this.btnAddBed.field_230694_p_ = false;
        if (this.serverConfiguration.addBed) {
            secondColumnY += 15;
        }
        this.btnAddCraftingTable = this.createAndAddCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addcraftingtable"), this.houseConfiguration.addCraftingTable, null);
        this.btnAddCraftingTable.field_230694_p_ = false;
        if (this.serverConfiguration.addCraftingTable) {
            y += 15;
        }
        this.btnAddTorches = this.createAndAddCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addtorches"), this.houseConfiguration.addTorches, null);
        this.btnAddTorches.field_230694_p_ = false;
        if (this.serverConfiguration.addTorches) {
            y += 15;
        }
        this.btnAddChest = this.createAndAddCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addchest"), this.houseConfiguration.addChest, null);
        this.btnAddChest.field_230694_p_ = false;
        if (this.serverConfiguration.addChests) {
            y += 15;
        }
        this.btnAddMineShaft = this.createAndAddCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.buildmineshaft"), this.houseConfiguration.addMineShaft, null);
        this.btnAddMineShaft.field_230694_p_ = false;
        if (this.serverConfiguration.addMineshaft) {
            y += 15;
        }
        this.btnAddChestContents = this.createAndAddCheckBox(x, y, GuiLangKeys.translateString("prefab.gui.starter.addchestcontents"), this.houseConfiguration.addChestContents, null);
        this.btnAddChestContents.field_230694_p_ = false;
        if (this.allowItemsInChestAndFurnace) {
            y += 15;
        }
        x = grayBoxX + 10;
        y = grayBoxY + 20;
        this.btnGlassColor = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateDye(this.houseConfiguration.glassColor));
        x = secondColumnX;
        this.btnBedColor = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateDye(this.houseConfiguration.bedColor));
        this.tabGeneral = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.general"), grayBoxX + 3, grayBoxY - 20);
        this.Tabs.AddTab(this.tabGeneral);
        this.tabConfig = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.config"), grayBoxX + 54, grayBoxY - 20);
        this.Tabs.AddTab(this.tabConfig);
        this.tabBlockTypes = new GuiTab(this.Tabs, GuiLangKeys.translateString("prefab.gui.starter.tab.block"), grayBoxX + 105, grayBoxY - 20);
        this.tabBlockTypes.func_230991_b_(70);
        this.Tabs.AddTab(this.tabBlockTypes);
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }
}

