/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wuest.prefab.Gui.GuiBase;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Tuple;
import java.awt.Color;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public abstract class GuiStructure
extends GuiBase {
    public BlockPos pos;
    protected PlayerEntity player;
    protected ExtendedButton btnCancel;
    protected ExtendedButton btnBuild;
    protected ExtendedButton btnVisualize;
    protected int textColor = Color.DARK_GRAY.getRGB();
    protected StructureTagMessage.EnumStructureConfiguration structureConfiguration;
    private Direction structureFacing;

    public GuiStructure(String title) {
        super(title);
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, int z, int width, int height, float textureWidth, float textureHeight) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        float u = 0.0f;
        float v = 0.0f;
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_225582_a_((double)x, (double)(y + height), (double)z).func_225583_a_(u * f, (v + (float)height) * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_225583_a_((u + (float)width) * f, (v + (float)height) * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)(x + width), (double)y, (double)z).func_225583_a_((u + (float)width) * f, v * f1).func_181675_d();
        vertexBuffer.func_225582_a_((double)x, (double)y, (double)z).func_225583_a_(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public void func_231160_c_() {
        this.player = this.getMinecraft().field_71439_g;
        this.structureFacing = this.player.func_174811_aO().func_176734_d();
        this.Initialize();
    }

    @Override
    protected void Initialize() {
    }

    public void checkVisualizationSetting() {
        if (!CommonProxy.proxyConfiguration.serverConfiguration.enableStructurePreview) {
            this.btnVisualize.field_230694_p_ = false;
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond());
        this.renderButtons(matrixStack, x, y);
        this.postButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond());
        if (this.btnVisualize != null) {
            this.checkVisualizationSetting();
        }
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        this.func_230446_a_(matrixStack);
        this.drawControlBackground(matrixStack, x, y);
    }

    protected void performCancelOrBuildOrHouseFacing(StructureConfiguration configuration, AbstractButton button) {
        configuration.houseFacing = this.structureFacing;
        if (button == this.btnCancel) {
            this.closeScreen();
        } else if (button == this.btnBuild) {
            Prefab.network.sendToServer((Object)new StructureTagMessage(configuration.WriteToCompoundNBT(), this.structureConfiguration));
            this.closeScreen();
        }
    }
}

