/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Gui.GuiTabScreen;
import com.wuest.prefab.Structures.Config.VillagerHouseConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureVillagerHouses;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiVillagerHouses
extends GuiStructure {
    protected VillagerHouseConfiguration configuration;
    private ExtendedButton btnHouseStyle;
    private ExtendedButton btnBedColor;
    private VillagerHouseConfiguration.HouseStyle houseStyle;

    public GuiVillagerHouses() {
        super("Villager Houses");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.VillagerHouses;
        this.modifiedInitialXAxis = 205;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    public void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig("Villager Houses", VillagerHouseConfiguration.class);
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = Direction.NORTH;
        this.houseStyle = this.configuration.houseStyle;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnHouseStyle = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, this.houseStyle.getDisplayName());
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 60, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        int x = grayBoxX + 130;
        int y = grayBoxY + 20;
        this.btnBedColor = this.createAndAddButton(x, y, 90, 20, GuiLangKeys.translateDye(this.configuration.bedColor));
        this.btnBedColor.field_230694_p_ = this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE;
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        super.preButtonRender(matrixStack, x, y);
        this.bindTexture(this.houseStyle.getHousePicture());
        GuiTabScreen.drawModalRectWithCustomSizedTexture(x + 250, y, 1, this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight(), this.houseStyle.getImageWidth(), this.houseStyle.getImageHeight());
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y) {
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.starter.style.label"), x + 10, y + 10, this.textColor);
        if (this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE) {
            this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.bed_color"), x + 130, y + 10, this.textColor);
        }
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.configuration.houseStyle = this.houseStyle;
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnHouseStyle) {
            int id = this.houseStyle.getValue() + 1;
            this.houseStyle = VillagerHouseConfiguration.HouseStyle.ValueOf(id);
            this.btnHouseStyle.func_238482_a_((ITextComponent)new StringTextComponent(this.houseStyle.getDisplayName()));
            this.btnBedColor.field_230694_p_ = this.houseStyle == VillagerHouseConfiguration.HouseStyle.LONG_HOUSE;
        } else if (button == this.btnVisualize) {
            StructureVillagerHouses structure = (StructureVillagerHouses)StructureVillagerHouses.CreateInstance(this.houseStyle.getStructureLocation(), StructureVillagerHouses.class);
            StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            this.closeScreen();
        } else if (button == this.btnBedColor) {
            this.configuration.bedColor = DyeColor.func_196056_a((int)(this.configuration.bedColor.func_196059_a() + 1));
            this.btnBedColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(this.configuration.bedColor)));
        }
    }
}

