/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.wuest.prefab.Events.ClientEventHandler;
import com.wuest.prefab.Gui.GuiLangKeys;
import com.wuest.prefab.Structures.Config.WareHouseConfiguration;
import com.wuest.prefab.Structures.Gui.GuiStructure;
import com.wuest.prefab.Structures.Messages.StructureTagMessage;
import com.wuest.prefab.Structures.Predefined.StructureWarehouse;
import com.wuest.prefab.Structures.Render.StructureRenderHandler;
import com.wuest.prefab.Tuple;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class GuiWareHouse
extends GuiStructure {
    private static final ResourceLocation wareHouseTopDown = new ResourceLocation("prefab", "textures/gui/warehouse_top_down.png");
    protected WareHouseConfiguration configuration;
    String clientGUIIdentifier;
    private ExtendedButton btnGlassColor;

    public GuiWareHouse() {
        super("Warehouse");
        this.structureConfiguration = StructureTagMessage.EnumStructureConfiguration.WareHouse;
        this.clientGUIIdentifier = "Warehouse";
        this.modifiedInitialXAxis = 180;
        this.modifiedInitialYAxis = 83;
    }

    @Override
    public void Initialize() {
        this.configuration = ClientEventHandler.playerConfig.getClientConfig(this.clientGUIIdentifier, WareHouseConfiguration.class);
        this.configuration.pos = this.pos;
        this.configuration.houseFacing = Direction.NORTH;
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnGlassColor = this.createAndAddButton(grayBoxX + 10, grayBoxY + 20, 90, 20, GuiLangKeys.translateDye(this.configuration.dyeColor));
        this.btnVisualize = this.createAndAddButton(grayBoxX + 10, grayBoxY + 90, 90, 20, GuiLangKeys.translateString("prefab.gui.button.preview"));
        this.btnBuild = this.createAndAddButton(grayBoxX + 10, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.build"));
        this.btnCancel = this.createAndAddButton(grayBoxX + 147, grayBoxY + 136, 90, 20, GuiLangKeys.translateString("prefab.gui.button.cancel"));
    }

    @Override
    protected void preButtonRender(MatrixStack matrixStack, int x, int y) {
        super.preButtonRender(matrixStack, x, y);
        this.bindTexture(wareHouseTopDown);
        GuiStructure.drawModalRectWithCustomSizedTexture(x + 250, y, 1, 132, 153, 132.0f, 153.0f);
    }

    @Override
    protected void postButtonRender(MatrixStack matrixStack, int x, int y) {
        this.drawString(matrixStack, GuiLangKeys.translateString("prefab.gui.structure.glass"), x + 10, y + 10, this.textColor);
        this.drawSplitString(GuiLangKeys.translateString("prefab.gui.structure.block.clicked"), x + 147, y + 10, 95, this.textColor);
    }

    @Override
    public void buttonClicked(AbstractButton button) {
        this.performCancelOrBuildOrHouseFacing(this.configuration, button);
        if (button == this.btnGlassColor) {
            this.configuration.dyeColor = DyeColor.func_196056_a((int)(this.configuration.dyeColor.func_196059_a() + 1));
            this.btnGlassColor.func_238482_a_((ITextComponent)new StringTextComponent(GuiLangKeys.translateDye(this.configuration.dyeColor)));
        } else if (button == this.btnVisualize) {
            if (this.configuration.advanced) {
                StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance("assets/prefab/structures/advanced_warehouse.zip", StructureWarehouse.class);
                StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            } else {
                StructureWarehouse structure = (StructureWarehouse)StructureWarehouse.CreateInstance("assets/prefab/structures/warehouse.zip", StructureWarehouse.class);
                StructureRenderHandler.setStructure(structure, Direction.NORTH, this.configuration);
            }
            this.closeScreen();
        }
    }
}

