/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Structures.Predefined;

import com.wuest.prefab.Structures.Base.BuildBlock;
import com.wuest.prefab.Structures.Base.BuildClear;
import com.wuest.prefab.Structures.Base.BuildingMethods;
import com.wuest.prefab.Structures.Base.Structure;
import com.wuest.prefab.Structures.Config.StructureConfiguration;
import com.wuest.prefab.Structures.Config.VillagerHouseConfiguration;
import com.wuest.prefab.Tuple;
import java.util.ArrayList;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StructureVillagerHouses
extends Structure {
    private ArrayList<Tuple<BlockPos, BlockPos>> bedPositions = new ArrayList();

    public static void ScanStructure(World world, BlockPos originalPos, Direction playerFacing, VillagerHouseConfiguration.HouseStyle houseStyle) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(houseStyle.getHeight());
        clearedSpace.getShape().setLength(houseStyle.getLength());
        clearedSpace.getShape().setWidth(houseStyle.getWidth());
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(houseStyle.getEastOffSet());
        BlockPos cornerPos = originalPos.func_177968_d().func_177965_g(houseStyle.getEastOffSet());
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.func_177970_e(houseStyle.getLength()).func_177985_f(houseStyle.getWidth()).func_177981_b(houseStyle.getHeight()), "../src/main/resources/" + houseStyle.getStructureLocation(), clearedSpace, playerFacing, false, false);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, Direction assumedNorth, Block foundBlock, BlockState blockState, PlayerEntity player) {
        if (foundBlock instanceof BedBlock) {
            BlockPos bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            BlockPos bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedPositions.add(new Tuple<BlockPos, BlockPos>(bedHeadPosition, bedFootPosition));
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, ServerWorld world, BlockPos originalPos, Direction assumedNorth, PlayerEntity player) {
        VillagerHouseConfiguration houseConfig = (VillagerHouseConfiguration)configuration;
        if (this.bedPositions.size() > 0) {
            for (Tuple<BlockPos, BlockPos> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((World)world, bedPosition.getFirst(), bedPosition.getSecond(), houseConfig.bedColor);
            }
        }
    }
}

