/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public final class Utility {
    public static <T extends TileEntity> T getTileEntity(Class<T> type, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return (T)(type.isInstance(tile) ? tile : null);
    }

    public static void dropInventory(TileEntity tile, IItemHandler inventory) {
        BlockPos pos = tile.func_174877_v();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)tile.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }

    public static Direction getDirectionFromOffset(BlockPos pos, BlockPos other) {
        BlockPos diff = pos.func_177973_b((Vec3i)other);
        return Direction.func_176737_a((float)diff.func_177958_n(), (float)diff.func_177956_o(), (float)diff.func_177952_p());
    }

    public static void addTooltip(String name, List<ITextComponent> tooltip) {
        if (Screen.hasShiftDown()) {
            String[] content;
            for (String s : content = I18n.func_135052_a((String)("info.prettypipes." + name), (Object[])new Object[0]).split("\n")) {
                tooltip.add(new StringTextComponent(s).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
        } else {
            tooltip.add(new TranslationTextComponent("info.prettypipes.shift", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)));
        }
    }

    public static ItemStack transferStackInSlot(Container container, IMergeItemStack merge, PlayerEntity player, int slotIndex, Function<ItemStack, Pair<Integer, Integer>> predicate) {
        int inventoryStart = (int)container.field_75151_b.stream().filter(slot -> slot.field_75224_c != player.field_71071_by).count();
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot slot2 = (Slot)container.field_75151_b.get(slotIndex);
        if (slot2 != null && slot2.func_75216_d()) {
            Pair<Integer, Integer> slots;
            ItemStack newStack = slot2.func_75211_c();
            ItemStack currentStack = newStack.func_77946_l();
            if (slotIndex >= inventoryStart ? ((slots = predicate.apply(newStack)) != null ? !merge.mergeItemStack(newStack, (Integer)slots.getLeft(), (Integer)slots.getRight(), false) : (slotIndex >= inventoryStart && slotIndex <= inventoryEnd ? !merge.mergeItemStack(newStack, hotbarStart, hotbarEnd + 1, false) : slotIndex >= inventoryEnd + 1 && slotIndex < hotbarEnd + 1 && !merge.mergeItemStack(newStack, inventoryStart, inventoryEnd + 1, false))) : !merge.mergeItemStack(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (newStack.func_190926_b()) {
                slot2.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot2.func_75218_e();
            }
            if (newStack.func_190916_E() == currentStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot2.func_190901_a(player, newStack);
            return currentStack;
        }
        return ItemStack.field_190927_a;
    }

    public static ListNBT serializeAll(Collection<? extends INBTSerializable<CompoundNBT>> items) {
        ListNBT list = new ListNBT();
        for (INBTSerializable<CompoundNBT> iNBTSerializable : items) {
            list.add((Object)iNBTSerializable.serializeNBT());
        }
        return list;
    }

    public static <T extends INBTSerializable<CompoundNBT>> List<T> deserializeAll(ListNBT list, Function<CompoundNBT, T> supplier) {
        ArrayList<T> items = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            items.add(supplier.apply(list.func_150305_b(i)));
        }
        return items;
    }

    public static interface IMergeItemStack {
        public boolean mergeItemStack(ItemStack var1, int var2, int var3, boolean var4);
    }
}

