/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.item.ItemStack;

public enum ItemEqualityType {
    DAMAGE((stack, filter) -> stack.func_77952_i() == filter.func_77952_i(), false),
    NBT(ItemStack::func_77970_a, false),
    TAG((stack, filter) -> {
        Set stackTags = stack.func_77973_b().getTags();
        Set filterTags = filter.func_77973_b().getTags();
        if (filterTags.isEmpty()) {
            return false;
        }
        return stackTags.containsAll(filterTags);
    }, true);

    public final BiFunction<ItemStack, ItemStack, Boolean> filter;
    public final boolean ignoreItemEquality;

    private ItemEqualityType(BiFunction<ItemStack, ItemStack, Boolean> filter, boolean ignoreItemEquality) {
        this.filter = filter;
        this.ignoreItemEquality = ignoreItemEquality;
    }

    public static boolean compareItems(ItemStack stack, ItemStack filter, ItemEqualityType ... types) {
        boolean equal = ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter);
        if (types.length <= 0) {
            return equal;
        }
        for (ItemEqualityType type : types) {
            if (!type.ignoreItemEquality && !equal) {
                return false;
            }
            if (type.filter.apply(stack, filter).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

