/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ItemTerminalWidget
extends Widget {
    private static final ResourceLocation FONT = new ResourceLocation("prettypipes", "unicode");
    private final ItemTerminalGui screen;
    public final int gridX;
    public final int gridY;
    public boolean selected;
    public ItemStack stack = ItemStack.field_190927_a;

    public ItemTerminalWidget(int xIn, int yIn, int gridX, int gridY, ItemTerminalGui screen) {
        super(xIn, yIn, 16, 16, "");
        this.gridX = gridX;
        this.gridY = gridY;
        this.screen = screen;
        this.visible = false;
    }

    public void onClick(double x, double y) {
        this.screen.streamWidgets().forEach(w -> {
            w.selected = false;
        });
        this.selected = true;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = this.screen.getMinecraft();
        ItemRenderer renderer = mc.func_175599_af();
        this.setBlitOffset(100);
        renderer.field_77023_b = 100.0f;
        if (this.selected) {
            ItemTerminalWidget.fill((int)this.x, (int)this.y, (int)(this.x + 16), (int)(this.y + 16), (int)-2130706433);
        }
        RenderSystem.enableDepthTest();
        renderer.func_184391_a((LivingEntity)mc.field_71439_g, this.stack, this.x, this.y);
        int amount = this.stack.func_190916_E();
        String amountStrg = this.stack.func_190916_E() >= 1000 ? amount / 1000 + "k" : String.valueOf(amount);
        FontRenderer font = mc.func_211500_ak().func_211504_a(FONT);
        renderer.func_180453_a(font, this.stack, this.x, this.y, amountStrg);
        renderer.field_77023_b = 0.0f;
        this.setBlitOffset(0);
        if (this.isHovered()) {
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.fillGradient(this.x, this.y, this.x + 16, this.y + 16, -2130706433, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    public void renderToolTip(int mouseX, int mouseY) {
        if (this.visible && this.isHovered()) {
            FontRenderer font = this.stack.func_77973_b().getFontRenderer(this.stack);
            if (font == null) {
                font = this.screen.getMinecraft().field_71466_p;
            }
            GuiUtils.preItemToolTip((ItemStack)this.stack);
            List tooltip = this.screen.getTooltipFromItem(this.stack);
            if (this.stack.func_190916_E() >= 1000) {
                tooltip.set(0, (String)tooltip.get(0) + TextFormatting.BOLD + " (" + this.stack.func_190916_E() + ')');
            }
            this.screen.renderTooltip(tooltip, mouseX, mouseY, font);
            GuiUtils.postItemToolTip();
        }
    }
}

