/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PipeBlock
extends ContainerBlock
implements IPipeConnectable {
    public static final Map<Direction, EnumProperty<ConnectionType>> DIRECTIONS = new HashMap<Direction, EnumProperty<ConnectionType>>();
    private static final Map<BlockState, VoxelShape> SHAPE_CACHE = new HashMap<BlockState, VoxelShape>();
    private static final VoxelShape CENTER_SHAPE = PipeBlock.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final Map<Direction, VoxelShape> DIR_SHAPES = ImmutableMap.builder().put((Object)Direction.UP, (Object)PipeBlock.func_208617_a((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).put((Object)Direction.DOWN, (Object)PipeBlock.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)).put((Object)Direction.NORTH, (Object)PipeBlock.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0)).put((Object)Direction.SOUTH, (Object)PipeBlock.func_208617_a((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0)).put((Object)Direction.EAST, (Object)PipeBlock.func_208617_a((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0)).put((Object)Direction.WEST, (Object)PipeBlock.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0)).build();

    public PipeBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_());
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        for (EnumProperty<ConnectionType> prop : DIRECTIONS.values()) {
            state = (BlockState)state.func_206870_a(prop, (Comparable)((Object)ConnectionType.DISCONNECTED));
        }
        this.func_180632_j(state);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        PipeTileEntity tile = Utility.getTileEntity(PipeTileEntity.class, worldIn, pos);
        if (tile == null) {
            return ActionResultType.PASS;
        }
        if (!tile.canHaveModules()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_77973_b() instanceof IModule) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)tile.modules, (ItemStack)copy, (boolean)false);
            if (remain.func_190926_b()) {
                stack.func_190918_g(1);
                return ActionResultType.SUCCESS;
            }
        }
        if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a((IProperty[])DIRECTIONS.values().toArray(new EnumProperty[0]));
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208198_y});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.createState(worldIn, pos, state);
        if (newState != state) {
            worldIn.func_175656_a(pos, newState);
            PipeBlock.onStateChanged(worldIn, pos, newState);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.createState(context.func_195991_k(), context.func_195995_a(), this.func_176223_P());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        PipeBlock.onStateChanged(worldIn, pos, state);
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = SHAPE_CACHE.get(state);
        if (shape != null) {
            return shape;
        }
        shape = CENTER_SHAPE;
        for (Map.Entry<Direction, EnumProperty<ConnectionType>> entry : DIRECTIONS.entrySet()) {
            if (!((ConnectionType)((Object)state.func_177229_b((IProperty)entry.getValue()))).isConnected()) continue;
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)DIR_SHAPES.get(entry.getKey()));
        }
        SHAPE_CACHE.put(state, shape);
        return shape;
    }

    private BlockState createState(World world, BlockPos pos, BlockState curr) {
        BlockState state = this.func_176223_P();
        IFluidState fluid = world.func_204610_c(pos);
        if (fluid.func_206884_a(FluidTags.field_206959_a) && fluid.func_206882_g() == 8) {
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
        }
        for (Direction dir : Direction.values()) {
            EnumProperty<ConnectionType> prop = DIRECTIONS.get(dir);
            ConnectionType type = PipeBlock.getConnectionType(world, pos, dir, state);
            if (type.isConnected() && curr.func_177229_b(prop) == ConnectionType.BLOCKED) {
                type = ConnectionType.BLOCKED;
            }
            state = (BlockState)state.func_206870_a(prop, (Comparable)((Object)type));
        }
        return state;
    }

    private static ConnectionType getConnectionType(World world, BlockPos pos, Direction direction, BlockState state) {
        IItemHandler handler;
        BlockPos offset = pos.func_177972_a(direction);
        if (!world.func_175667_e(offset)) {
            return ConnectionType.DISCONNECTED;
        }
        BlockState offState = world.func_180495_p(offset);
        Block block = offState.func_177230_c();
        if (block instanceof IPipeConnectable) {
            return ((IPipeConnectable)block).getConnectionType(world, pos, direction);
        }
        TileEntity tile = world.func_175625_s(offset);
        if (tile != null && (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(null)) != null) {
            return ConnectionType.CONNECTED;
        }
        if (PipeBlock.hasLegsTo(world, offState, offset, direction) && DIRECTIONS.values().stream().noneMatch(d -> state.func_177229_b((IProperty)d) == ConnectionType.LEGS)) {
            return ConnectionType.LEGS;
        }
        return ConnectionType.DISCONNECTED;
    }

    private static boolean hasLegsTo(World world, BlockState state, BlockPos pos, Direction direction) {
        if (state.func_177230_c() instanceof WallBlock || state.func_177230_c() instanceof FenceBlock) {
            return direction == Direction.DOWN;
        }
        if (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f) {
            return PipeBlock.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)direction.func_176734_d());
        }
        return false;
    }

    public static void onStateChanged(World world, BlockPos pos, BlockState newState) {
        PipeTileEntity tile = Utility.getTileEntity(PipeTileEntity.class, world, pos);
        if (tile != null && !tile.canHaveModules()) {
            Utility.dropInventory(tile, (IItemHandler)tile.modules);
        }
        PipeNetwork network = PipeNetwork.get(world);
        int connections = 0;
        boolean force = false;
        for (Direction dir : Direction.values()) {
            ConnectionType value = (ConnectionType)((Object)newState.func_177229_b((IProperty)DIRECTIONS.get(dir)));
            if (!value.isConnected()) continue;
            ++connections;
            BlockState otherState = world.func_180495_p(pos.func_177972_a(dir));
            if (otherState.func_177230_c() == newState.func_177230_c()) continue;
            force = true;
            break;
        }
        if (force || connections > 2) {
            network.addNode(pos, newState);
        } else {
            network.removeNode(pos);
        }
        network.onPipeChanged(pos, newState);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            PipeTileEntity tile = Utility.getTileEntity(PipeTileEntity.class, worldIn, pos);
            if (tile != null) {
                Utility.dropInventory(tile, (IItemHandler)tile.modules);
                for (PipeItem item : tile.getItems()) {
                    item.drop(worldIn);
                }
            }
            PipeNetwork network = PipeNetwork.get(worldIn);
            network.removeNode(pos);
            network.onPipeChanged(pos, state);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        PipeTileEntity pipe = Utility.getTileEntity(PipeTileEntity.class, worldIn, pos);
        if (pipe == null) {
            return 0;
        }
        return Math.min(15, pipe.getItems().size());
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PipeTileEntity();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Override
    public ConnectionType getConnectionType(World world, BlockPos pipePos, Direction direction) {
        BlockState state = world.func_180495_p(pipePos.func_177972_a(direction));
        if (state.func_177229_b((IProperty)DIRECTIONS.get(direction.func_176734_d())) == ConnectionType.BLOCKED) {
            return ConnectionType.BLOCKED;
        }
        return ConnectionType.CONNECTED;
    }

    static {
        for (Direction dir : Direction.values()) {
            DIRECTIONS.put(dir, (EnumProperty<ConnectionType>)EnumProperty.func_177709_a((String)dir.func_176610_l(), ConnectionType.class));
        }
    }
}

