/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.ItemEqualityType;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.containers.MainPipeContainer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class PipeTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    public final ItemStackHandler modules = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (!(item instanceof IModule)) {
                return false;
            }
            IModule module = (IModule)item;
            return PipeTileEntity.this.streamModules().allMatch(m -> module.isCompatible(stack, PipeTileEntity.this, (IModule)m.getRight()) && ((IModule)m.getRight()).isCompatible((ItemStack)m.getLeft(), PipeTileEntity.this, module));
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<PipeItem> items;
    private int lastItemAmount;
    private int priority;

    public PipeTileEntity() {
        super(Registry.pipeTileEntity);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("modules", (INBT)this.modules.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.modules.deserializeNBT(compound.func_74775_l("modules"));
        super.func_145839_a(compound);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = this.func_189515_b(new CompoundNBT());
        nbt.func_218657_a("items", (INBT)Utility.serializeAll(this.getItems()));
        return nbt;
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        this.func_145839_a(nbt);
        List<PipeItem> items = this.getItems();
        items.clear();
        items.addAll(Utility.deserializeAll(nbt.func_150295_c("items", 10), PipeItem::new));
    }

    public void func_73660_a() {
        if (!this.field_145850_b.isAreaLoaded(this.field_174879_c, 1)) {
            return;
        }
        IProfiler profiler = this.field_145850_b.func_217381_Z();
        if (!this.field_145850_b.field_72995_K) {
            profiler.func_76320_a("ticking_modules");
            int prio = 0;
            Iterator modules = this.streamModules().iterator();
            while (modules.hasNext()) {
                Pair module = (Pair)modules.next();
                ((IModule)module.getRight()).tick((ItemStack)module.getLeft(), this);
                prio += ((IModule)module.getRight()).getPriority((ItemStack)module.getLeft(), this);
            }
            if (prio != this.priority) {
                this.priority = prio;
                PipeNetwork.get(this.field_145850_b).clearDestinationCache(this.field_174879_c);
            }
            profiler.func_76319_b();
        }
        profiler.func_76320_a("ticking_items");
        List<PipeItem> items = this.getItems();
        for (int i = items.size() - 1; i >= 0; --i) {
            items.get(i).updateInPipe(this);
        }
        if (items.size() != this.lastItemAmount) {
            this.lastItemAmount = items.size();
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        profiler.func_76319_b();
    }

    public List<PipeItem> getItems() {
        if (this.items == null) {
            this.items = PipeNetwork.get(this.field_145850_b).getItemsInPipe(this.field_174879_c);
        }
        return this.items;
    }

    public boolean isConnected(Direction dir) {
        return ((ConnectionType)((Object)this.func_195044_w().func_177229_b((IProperty)PipeBlock.DIRECTIONS.get(dir)))).isConnected();
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(ItemStack stack, boolean force, boolean preventOversending) {
        if (!this.canWork()) {
            return null;
        }
        if (!force && this.streamModules().anyMatch(m -> !((IModule)m.getRight()).canAcceptItem((ItemStack)m.getLeft(), this, stack))) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            PipeNetwork network;
            int onTheWay;
            ItemStack remain;
            IItemHandler handler = this.getItemHandler(dir, null);
            if (handler == null || (remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true)).func_190916_E() == stack.func_190916_E()) continue;
            ItemStack toInsert = stack.func_77946_l();
            toInsert.func_190918_g(remain.func_190916_E());
            int maxAmount = this.streamModules().mapToInt(m -> ((IModule)m.getRight()).getMaxInsertionAmount((ItemStack)m.getLeft(), this, stack, handler)).min().orElse(Integer.MAX_VALUE);
            if (maxAmount < toInsert.func_190916_E()) {
                toInsert.func_190920_e(maxAmount);
            }
            BlockPos offset = this.field_174879_c.func_177972_a(dir);
            if ((preventOversending || maxAmount < Integer.MAX_VALUE) && (onTheWay = (network = PipeNetwork.get(this.field_145850_b)).getItemsOnTheWay(offset, null, new ItemEqualityType[0])) > 0) {
                if (maxAmount < Integer.MAX_VALUE) {
                    int onTheWaySame = network.getItemsOnTheWay(offset, stack, new ItemEqualityType[0]);
                    if (toInsert.func_190916_E() + onTheWaySame > maxAmount) {
                        toInsert.func_190920_e(maxAmount - onTheWaySame);
                    }
                }
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(copy.func_77976_d());
                int totalSpace = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack left = handler.insertItem(i, copy, true);
                    totalSpace += copy.func_77976_d() - left.func_190916_E();
                }
                if (onTheWay + toInsert.func_190916_E() > totalSpace) {
                    toInsert.func_190920_e(totalSpace - onTheWay);
                }
            }
            if (toInsert.func_190926_b()) continue;
            return Pair.of((Object)offset, (Object)toInsert);
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getItemSpeed() {
        float speed = (float)this.streamModules().mapToDouble(m -> ((IModule)m.getRight()).getItemSpeedIncrease((ItemStack)m.getLeft(), this)).sum();
        return 0.05f + speed;
    }

    public boolean canWork() {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canPipeWork((ItemStack)m.getLeft(), this));
    }

    public IItemHandler getItemHandler(Direction dir, PipeItem item) {
        IPipeConnectable connectable;
        if (!this.isConnected(dir)) {
            return null;
        }
        BlockPos pos = this.field_174879_c.func_177972_a(dir);
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile != null) {
            BlockState state;
            if (tile instanceof ChestTileEntity && (state = this.field_145850_b.func_180495_p(tile.func_174877_v())).func_177230_c() instanceof ChestBlock) {
                return new InvWrapper(ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)state.func_177230_c()), (BlockState)state, (World)this.field_145850_b, (BlockPos)tile.func_174877_v(), (boolean)true));
            }
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).orElse(null);
            if (handler != null) {
                return handler;
            }
        }
        if ((connectable = this.getPipeConnectable(dir)) != null) {
            return connectable.getItemHandler(this.field_145850_b, this.field_174879_c, dir, item);
        }
        return null;
    }

    public IPipeConnectable getPipeConnectable(Direction dir) {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir));
        if (state.func_177230_c() instanceof IPipeConnectable) {
            return (IPipeConnectable)state.func_177230_c();
        }
        return null;
    }

    public boolean isConnectedInventory(Direction dir) {
        return this.getItemHandler(dir, null) != null;
    }

    public boolean canHaveModules() {
        for (Direction dir : Direction.values()) {
            if (this.isConnectedInventory(dir)) {
                return true;
            }
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || !connectable.allowsModules(this.field_145850_b, this.field_174879_c, dir)) continue;
            return true;
        }
        return false;
    }

    public boolean canNetworkSee() {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canNetworkSee((ItemStack)m.getLeft(), this));
    }

    public Stream<Pair<ItemStack, IModule>> streamModules() {
        Stream.Builder<Pair> builder = Stream.builder();
        for (int i = 0; i < this.modules.getSlots(); ++i) {
            ItemStack stack = this.modules.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            builder.accept(Pair.of((Object)stack, (Object)((IModule)stack.func_77973_b())));
        }
        return builder.build();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getItems().clear();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.prettypipes.pipe", new Object[0]);
    }

    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new MainPipeContainer(Registry.pipeContainer, window, player, this.field_174879_c);
    }
}

