/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.stacksize;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.misc.ItemEqualityType;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class StackSizeModuleItem
extends ModuleItem {
    public StackSizeModuleItem(String name) {
        super(name);
        this.setRegistryName(name);
    }

    public static int getMaxStackSize(ItemStack module) {
        int amount;
        if (module.func_77942_o() && (amount = module.func_77978_p().func_74762_e("max_stack_size")) > 0) {
            return amount;
        }
        return 64;
    }

    public static void setMaxStackSize(ItemStack module, int amount) {
        module.func_196082_o().func_74768_a("max_stack_size", amount);
    }

    public static boolean getLimitToMaxStackSize(ItemStack module) {
        if (module.func_77942_o()) {
            return module.func_77978_p().func_74767_n("limit_to_max_stack_size");
        }
        return false;
    }

    public static void setLimitToMaxStackSize(ItemStack module, boolean yes) {
        module.func_196082_o().func_74757_a("limit_to_max_stack_size", yes);
    }

    @Override
    public int getMaxInsertionAmount(ItemStack module, PipeTileEntity tile, ItemStack stack, IItemHandler destination) {
        int max = StackSizeModuleItem.getMaxStackSize(module);
        if (StackSizeModuleItem.getLimitToMaxStackSize(module)) {
            max = Math.min(max, stack.func_77976_d());
        }
        int amount = 0;
        for (int i = 0; i < destination.getSlots(); ++i) {
            ItemStack stored = destination.getStackInSlot(i);
            if (stored.func_190926_b() || !ItemEqualityType.compareItems(stored, stack, new ItemEqualityType[0]) || (amount += stored.func_190916_E()) < max) continue;
            return 0;
        }
        return max - amount;
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeTileEntity tile, IModule other) {
        return !(other instanceof StackSizeModuleItem);
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeTileEntity tile) {
        return true;
    }

    @Override
    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeTileEntity tile, int windowId, PlayerInventory inv, PlayerEntity player, int moduleIndex) {
        return new StackSizeModuleContainer(Registry.stackSizeModuleContainer, windowId, player, tile.func_174877_v(), moduleIndex);
    }
}

