/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEqualityType;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.terminal.ItemTerminalTileEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.mutable.MutableInt;

public class CraftingTerminalTileEntity
extends ItemTerminalTileEntity {
    public final ItemStackHandler craftItems = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            for (PlayerEntity playerEntity : CraftingTerminalTileEntity.this.getLookingPlayers()) {
                playerEntity.field_71070_bA.func_75130_a(null);
            }
        }
    };
    public final ItemStackHandler ghostItems = new ItemStackHandler(9);

    public CraftingTerminalTileEntity() {
        super(Registry.craftingTerminalTileEntity);
    }

    public ItemStack getRequestedCraftItem(int slot) {
        ItemStack stack = this.craftItems.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            return stack;
        }
        return this.ghostItems.getStackInSlot(slot);
    }

    public boolean isGhostItem(int slot) {
        return this.craftItems.getStackInSlot(slot).func_190926_b() && !this.ghostItems.getStackInSlot(slot).func_190926_b();
    }

    public void setGhostItems(ListMultimap<Integer, ItemStack> stacks) {
        this.updateItems(new PlayerEntity[0]);
        block0: for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
            List items = stacks.get((Object)i);
            if (items.isEmpty()) {
                this.ghostItems.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            if (items.size() > 1) {
                for (ItemStack stack : items) {
                    EquatableItemStack equatable = new EquatableItemStack(stack);
                    NetworkItem network = (NetworkItem)this.networkItems.get(equatable);
                    if (network == null || !network.getLocations().stream().anyMatch(l -> l.getItemAmount(this.field_145850_b, stack, ItemEqualityType.NBT) > 0)) continue;
                    this.ghostItems.setStackInSlot(i, stack);
                    continue block0;
                }
            }
            this.ghostItems.setStackInSlot(i, (ItemStack)items.get(0));
        }
        if (!this.field_145850_b.field_72995_K) {
            ArrayListMultimap clients = ArrayListMultimap.create();
            for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
                clients.put((Object)i, (Object)this.ghostItems.getStackInSlot(i));
            }
            PacketHandler.sendToAllLoaded(this.field_145850_b, this.field_174879_c, new PacketGhostSlot(this.field_174879_c, (ListMultimap<Integer, ItemStack>)clients));
        }
    }

    public void requestCraftingItems(PlayerEntity player, boolean all) {
        ItemStack requested;
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        network.startProfile("terminal_request_crafting");
        this.updateItems(new PlayerEntity[0]);
        int lowestAvailable = Integer.MAX_VALUE;
        HashMap<EquatableItemStack, MutableInt> requiredItems = new HashMap<EquatableItemStack, MutableInt>();
        for (int i = 0; i < this.craftItems.getSlots(); ++i) {
            requested = this.getRequestedCraftItem(i);
            if (requested.func_190926_b()) continue;
            MutableInt amount = requiredItems.computeIfAbsent(new EquatableItemStack(requested), s -> new MutableInt());
            amount.add(1);
            int fit = requested.func_77976_d() - (this.isGhostItem(i) ? 0 : requested.func_190916_E());
            if (lowestAvailable <= fit) continue;
            lowestAvailable = fit;
        }
        for (Map.Entry entry : requiredItems.entrySet()) {
            EquatableItemStack stack = (EquatableItemStack)entry.getKey();
            NetworkItem item = (NetworkItem)this.networkItems.get(stack);
            int available = 0;
            if (item != null) {
                for (NetworkLocation location : item.getLocations()) {
                    int amount = location.getItemAmount(this.field_145850_b, stack.stack, ItemEqualityType.NBT);
                    if (amount <= 0) continue;
                    available += (amount -= network.getLockedAmount(location.getPos(), stack.stack, ItemEqualityType.NBT));
                }
                if ((available /= ((MutableInt)entry.getValue()).intValue()) < lowestAvailable) {
                    lowestAvailable = available;
                }
            } else {
                lowestAvailable = 0;
            }
            if (available > 0) continue;
            player.func_145747_a(new TranslationTextComponent("info.prettypipes.not_found", new Object[]{stack.stack.func_200301_q()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        if (lowestAvailable > 0) {
            if (!all) {
                lowestAvailable = 1;
            }
            for (int i = 0; i < this.craftItems.getSlots(); ++i) {
                requested = this.getRequestedCraftItem(i);
                if (requested.func_190926_b()) continue;
                requested = requested.func_77946_l();
                requested.func_190920_e(lowestAvailable);
                this.requestItemImpl(requested);
            }
            player.func_145747_a(new TranslationTextComponent("info.prettypipes.sending_ingredients", new Object[]{lowestAvailable}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        }
        network.endProfile();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("craft_items", (INBT)this.craftItems.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.craftItems.deserializeNBT(compound.func_74775_l("craft_items"));
        super.func_145839_a(compound);
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.prettypipes.crafting_terminal", new Object[0]);
    }

    @Override
    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new CraftingTerminalContainer(Registry.craftingTerminalContainer, window, player, this.field_174879_c);
    }
}

