/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEqualityType;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketNetworkItems;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemStackHandler;

public class ItemTerminalTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    public final ItemStackHandler items = new ItemStackHandler(12){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    public Map<EquatableItemStack, NetworkItem> networkItems;
    private final Queue<NetworkLock> pendingRequests = new ArrayDeque<NetworkLock>();

    protected ItemTerminalTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public ItemTerminalTileEntity() {
        this(Registry.itemTerminalTileEntity);
    }

    public void func_73660_a() {
        PlayerEntity[] lookingPlayers;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        PipeTileEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        boolean update = false;
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            for (int i = 6; i < 12; ++i) {
                ItemStack remain;
                ItemStack extracted = this.items.extractItem(i, Integer.MAX_VALUE, true);
                if (extracted.func_190926_b() || (remain = network.tryInsertItem(pipe.func_174877_v(), this.field_174879_c, extracted, true)).func_190916_E() == extracted.func_190916_E()) continue;
                this.items.extractItem(i, extracted.func_190916_E() - remain.func_190916_E(), false);
                break;
            }
            if (!this.pendingRequests.isEmpty()) {
                NetworkLock request = this.pendingRequests.remove();
                network.resolveNetworkLock(request);
                network.requestItem(request.location, pipe.func_174877_v(), this.field_174879_c, request.stack, ItemEqualityType.NBT);
                update = true;
            }
        }
        if ((this.field_145850_b.func_82737_E() % 100L == 0L || update) && (lookingPlayers = this.getLookingPlayers()).length > 0) {
            this.updateItems(lookingPlayers);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        for (NetworkLock lock : this.pendingRequests) {
            network.resolveNetworkLock(lock);
        }
    }

    public PipeTileEntity getConnectedPipe() {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        for (Direction dir : Direction.values()) {
            PipeTileEntity pipe = network.getPipe(this.field_174879_c.func_177972_a(dir));
            if (pipe == null) continue;
            return pipe;
        }
        return null;
    }

    public void updateItems(PlayerEntity ... playersToSync) {
        if (this.getConnectedPipe() == null) {
            return;
        }
        this.networkItems = this.collectItems();
        if (playersToSync.length > 0) {
            List<ItemStack> clientItems = this.networkItems.values().stream().map(NetworkItem::asStack).collect(Collectors.toList());
            for (PlayerEntity player : playersToSync) {
                ItemTerminalTileEntity tile;
                if (!(player.field_71070_bA instanceof ItemTerminalContainer) || (tile = ((ItemTerminalContainer)player.field_71070_bA).tile) != this) continue;
                PacketHandler.sendTo(player, new PacketNetworkItems(clientItems));
            }
        }
    }

    public void requestItem(PlayerEntity player, ItemStack stack) {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        network.startProfile("terminal_request_item");
        this.updateItems(new PlayerEntity[0]);
        int requested = this.requestItemImpl(stack);
        if (requested > 0) {
            player.func_145747_a(new TranslationTextComponent("info.prettypipes.sending", new Object[]{requested, stack.func_200301_q()}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else {
            player.func_145747_a(new TranslationTextComponent("info.prettypipes.not_found", new Object[]{stack.func_200301_q()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        network.endProfile();
    }

    protected int requestItemImpl(ItemStack stack) {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        EquatableItemStack equatable = new EquatableItemStack(stack);
        NetworkItem item = this.networkItems.get(equatable);
        if (item != null) {
            int remain = stack.func_190916_E();
            for (NetworkLocation location : item.getLocations()) {
                int amount = location.getItemAmount(this.field_145850_b, stack, ItemEqualityType.NBT);
                if (amount <= 0) continue;
                if ((amount -= network.getLockedAmount(location.getPos(), stack, ItemEqualityType.NBT)) <= 0) continue;
                if (remain < amount) {
                    amount = remain;
                }
                remain -= amount;
                while (amount > 0) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(Math.min(stack.func_77976_d(), amount));
                    NetworkLock lock = new NetworkLock(location, copy);
                    this.pendingRequests.add(lock);
                    network.createNetworkLock(lock);
                    amount -= copy.func_190916_E();
                }
                if (remain > 0) continue;
                break;
            }
            return stack.func_190916_E() - remain;
        }
        return 0;
    }

    protected PlayerEntity[] getLookingPlayers() {
        return (PlayerEntity[])this.field_145850_b.func_217369_A().stream().filter(p -> p.field_71070_bA instanceof ItemTerminalContainer).filter(p -> ((ItemTerminalContainer)p.field_71070_bA).tile == this).toArray(PlayerEntity[]::new);
    }

    private Map<EquatableItemStack, NetworkItem> collectItems() {
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        network.startProfile("terminal_collect_items");
        PipeTileEntity pipe = this.getConnectedPipe();
        HashMap<EquatableItemStack, NetworkItem> items = new HashMap<EquatableItemStack, NetworkItem>();
        for (NetworkLocation location : network.getOrderedNetworkItems(pipe.func_174877_v())) {
            for (ItemStack stack : location.getItems(this.field_145850_b).values()) {
                EquatableItemStack equatable = new EquatableItemStack(stack);
                NetworkItem item = items.computeIfAbsent(equatable, NetworkItem::new);
                item.add(location, stack);
            }
        }
        network.endProfile();
        return items;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.items.serializeNBT());
        compound.func_218657_a("requests", (INBT)Utility.serializeAll(this.pendingRequests));
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.items.deserializeNBT(compound.func_74775_l("items"));
        this.pendingRequests.clear();
        this.pendingRequests.addAll(Utility.deserializeAll(compound.func_150295_c("requests", 10), NetworkLock::new));
        super.func_145839_a(compound);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.prettypipes.item_terminal", new Object[0]);
    }

    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new ItemTerminalContainer(Registry.itemTerminalContainer, window, player, this.field_174879_c);
    }
}

