/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.capability.entity;

import melonslise.lambda.common.capability.entity.ICapabilityReloading;
import melonslise.lambda.common.item.api.IItemReloadable;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.ClientMessageReload;
import melonslise.lambda.common.network.message.server.ServerMessageReload;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityReloading
implements ICapabilityReloading {
    private static final ResourceLocation id = LambdaUtilities.createLambdaDomain("reloading");
    private EntityPlayer player;
    private boolean state;
    private EnumHand hand = EnumHand.MAIN_HAND;
    private ItemStack stack = ItemStack.field_190927_a;
    private int ticks;

    public CapabilityReloading(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public ResourceLocation getID() {
        return id;
    }

    @Override
    public boolean get() {
        return this.state;
    }

    @Override
    public EnumHand getHand() {
        return this.hand;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    @Override
    public void startReloading(EnumHand hand) {
        ItemStack stack = this.player.func_184586_b(hand);
        if (!this.state && stack.func_77973_b() instanceof IItemReloadable) {
            this.synchronize(true, hand);
            IItemReloadable reloadable = (IItemReloadable)stack.func_77973_b();
            int ticks = reloadable.onStartReloading(this.player, hand, stack);
            if (ticks > 0) {
                this.state = true;
                this.hand = hand;
                this.stack = stack;
                this.ticks = ticks;
            }
        }
    }

    @Override
    public void updateReloading() {
        if (this.state) {
            ItemStack stack = this.player.func_184586_b(this.hand);
            if (this.ticks > 0 && !this.stack.func_190926_b() && stack.func_77973_b() instanceof IItemReloadable && ((IItemReloadable)this.stack.func_77973_b()).continueReloading(this.player, this.stack, stack)) {
                --this.ticks;
                ((IItemReloadable)this.stack.func_77973_b()).onUpdateReloading(this.player, this.hand, this.stack, this.ticks);
            } else {
                this.stopReloading(this.hand);
            }
        }
    }

    @Override
    public void stopReloading(EnumHand hand) {
        if (this.state && this.hand == hand) {
            this.synchronize(false, hand);
            if (!this.stack.func_190926_b()) {
                ((IItemReloadable)this.stack.func_77973_b()).onStopReloading(this.player, this.hand, this.stack, this.ticks);
            }
            this.state = false;
        }
    }

    @Override
    public void synchronize() {
        this.synchronize(this.state, this.hand);
    }

    protected void synchronize(boolean state, EnumHand hand) {
        if (!this.player.field_70170_p.field_72995_K) {
            LambdaNetworks.network.sendToAllTracking((IMessage)new ClientMessageReload((Entity)this.player, state, hand), (Entity)this.player);
        } else if (this.player == Minecraft.func_71410_x().field_71439_g) {
            LambdaNetworks.network.sendToServer((IMessage)new ServerMessageReload(hand));
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound nbt, EnumFacing side) {
        return nbt;
    }

    @Override
    public void deserialize(NBTBase nbt) {
    }
}

