/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.capability.entity;

import melonslise.lambda.common.capability.entity.ICapabilityUsingItem;
import melonslise.lambda.common.item.api.IItemUsable;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.ClientMessageUseItem;
import melonslise.lambda.common.network.message.server.ServerMessageUseItem;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapabilityUsingItem
implements ICapabilityUsingItem {
    private static final ResourceLocation id = LambdaUtilities.createLambdaDomain("using.item");
    private EntityPlayer player;
    private boolean state;
    private EnumHand hand = EnumHand.MAIN_HAND;
    private ItemStack stack = ItemStack.field_190927_a;
    private int ticks;
    private int type;

    public CapabilityUsingItem(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public ResourceLocation getID() {
        return id;
    }

    @Override
    public boolean get() {
        return this.state;
    }

    @Override
    public EnumHand getHand() {
        return this.hand;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void startUsing(EnumHand hand, int type) {
        ItemStack stack = this.player.func_184586_b(hand);
        if (!this.state && stack.func_77973_b() instanceof IItemUsable) {
            this.synchronize(true, hand, type);
            if (((IItemUsable)stack.func_77973_b()).onStartUsing(this.player, hand, stack, type)) {
                this.state = true;
                this.hand = hand;
                this.stack = stack;
                this.ticks = 0;
                this.type = type;
            }
        }
    }

    @Override
    public void updateUsing() {
        if (this.state) {
            ItemStack stack = this.player.func_184586_b(this.hand);
            if (!this.stack.func_190926_b() && stack.func_77973_b() instanceof IItemUsable && ((IItemUsable)this.stack.func_77973_b()).continueUsing(this.player, this.hand, this.stack, stack, this.ticks, this.type)) {
                ++this.ticks;
                ((IItemUsable)this.stack.func_77973_b()).onUpdateUsing(this.player, this.hand, this.stack, this.ticks, this.type);
            } else {
                this.stopUsing(this.hand, this.type);
            }
        }
    }

    @Override
    public void stopUsing(EnumHand hand, int type) {
        if (this.state && this.hand == hand && this.type == type) {
            this.synchronize(false, hand, type);
            if (!this.stack.func_190926_b()) {
                ((IItemUsable)this.stack.func_77973_b()).onStopUsing(this.player, this.hand, this.stack, this.ticks, this.type);
            }
            this.state = false;
        }
    }

    @Override
    public void synchronize() {
        this.synchronize(this.state, this.hand, this.type);
    }

    protected void synchronize(boolean state, EnumHand hand, int type) {
        if (!this.player.field_70170_p.field_72995_K) {
            LambdaNetworks.network.sendToAllTracking((IMessage)new ClientMessageUseItem((Entity)this.player, state, type, hand), (Entity)this.player);
        } else if (this.player == Minecraft.func_71410_x().field_71439_g) {
            LambdaNetworks.network.sendToServer((IMessage)new ServerMessageUseItem(state, type, hand));
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound nbt, EnumFacing side) {
        return nbt;
    }

    @Override
    public void deserialize(NBTBase nbt) {
    }
}

