/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.capability.entity;

import melonslise.lambda.common.capability.entity.ICapabilityZooming;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;

public class CapabilityZooming
implements ICapabilityZooming {
    private static final ResourceLocation id = LambdaUtilities.createLambdaDomain("zooming");
    private EntityPlayer player;
    private boolean state;
    private EnumHand hand = EnumHand.MAIN_HAND;
    private ItemStack stack = ItemStack.field_190927_a;
    private int ticks;

    public CapabilityZooming(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public ResourceLocation getID() {
        return id;
    }

    @Override
    public boolean get() {
        return this.state;
    }

    @Override
    public EnumHand getHand() {
        return this.hand;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    @Override
    public void startZooming(EnumHand hand) {
        ItemStack stack = this.player.func_184586_b(hand);
        if (!this.state && !stack.func_190926_b()) {
            this.synchronize(true, hand);
            this.state = true;
            this.hand = hand;
            this.stack = stack;
            this.ticks = 0;
        }
    }

    @Override
    public void updateZooming() {
        if (this.state) {
            ItemStack stack = this.player.func_184586_b(this.hand);
            if (!this.stack.func_190926_b() && !stack.func_190926_b() && (this.player.field_70170_p.field_72995_K && ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)stack) || !this.player.field_70170_p.field_72995_K && ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)stack))) {
                ++this.ticks;
            } else {
                this.stopZooming(this.hand);
            }
        }
    }

    @Override
    public void stopZooming(EnumHand hand) {
        if (this.state && this.hand == hand) {
            this.synchronize(false, hand);
            this.state = false;
        }
    }

    @Override
    public void toggleZooming(EnumHand hand) {
        if (!this.state) {
            this.startZooming(hand);
        } else if (this.hand == hand) {
            this.stopZooming(hand);
        }
    }

    @Override
    public void synchronize() {
        this.synchronize(this.state, this.hand);
    }

    protected void synchronize(boolean state, EnumHand hand) {
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound nbt, EnumFacing side) {
        return nbt;
    }

    @Override
    public void deserialize(NBTBase nbt) {
    }
}

