/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.alien;

import java.util.Iterator;
import java.util.List;
import melonslise.lambda.common.entity.api.AEntityAlien;
import melonslise.lambda.common.network.LambdaNetworks;
import melonslise.lambda.common.network.message.client.MessageHoundeye;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHoundeye
extends AEntityAlien {
    public int blast;
    public int charge;
    public int flee;
    public static final double range = 3.0;
    public static final float blastDamage = 3.0f;
    public static final float bonusDamage = 2.0f;
    public float blastRadius;
    public float oldBlastRadius;

    public EntityHoundeye(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFlee(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFollow(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AICharge(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, true, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.oldBlastRadius = this.blastRadius;
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.field_70173_aa % (this.field_70146_Z.nextInt(10) + 15) == 0) {
            this.func_184185_a(LambdaSounds.alien_houndeye_hunt, this.func_70599_aP(), this.func_70647_i());
        }
        if (this.charge > 0) {
            --this.charge;
            if (this.charge == 0) {
                this.blast();
            }
        }
        if (this.blast > 0) {
            this.blastRadius = (5.0f - (float)this.blast) * 2.0f;
            --this.blast;
        } else {
            this.blastRadius = 0.0f;
        }
        if (this.flee > 0) {
            --this.flee;
        }
    }

    public void blast() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB radius = new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 2.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 2.0, this.field_70161_v + 5.0);
            int allies = this.field_70170_p.func_72872_a(EntityHoundeye.class, radius).size() - 1;
            List entities = this.field_70170_p.func_175674_a((Entity)this, radius, LambdaSelectors.HOUNDEYE_TARGETS);
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                ((Entity)iterator.next()).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f + 2.0f * (float)MathHelper.func_76125_a((int)allies, (int)0, (int)3));
            }
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
                Iterable blocks = BlockPos.func_191532_a((int)((int)this.field_70165_t - 5), (int)((int)this.field_70163_u - 2), (int)((int)this.field_70161_v - 5), (int)((int)this.field_70165_t + 5), (int)((int)this.field_70163_u + 2), (int)((int)this.field_70161_v + 5));
                for (BlockPos block : blocks) {
                    if (!LambdaSelectors.SHATTERABLES.apply((Object)this.field_70170_p.func_180495_p(block))) continue;
                    this.field_70170_p.func_175655_b(block, true);
                }
            }
        }
        this.blast = 5;
        this.func_184185_a(this.getBlastSound(), this.func_70599_aP(), this.func_70647_i());
    }

    @Override
    protected SoundEvent getAlertSound() {
        return LambdaSounds.alien_houndeye_alert;
    }

    protected SoundEvent getAttackSound() {
        return LambdaSounds.alien_houndeye_attack;
    }

    protected SoundEvent getBlastSound() {
        return LambdaSounds.alien_houndeye_blast;
    }

    protected SoundEvent func_184615_bR() {
        return LambdaSounds.alien_houndeye_die;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70638_az() == null ? LambdaSounds.alien_houndeye_idle : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return LambdaSounds.alien_houndeye_pain;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.flee = 30;
        return super.func_70097_a(source, amount);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB box = super.func_184177_bl();
        return this.blast > 0 ? new AxisAlignedBB(box.field_72340_a - 5.0, box.field_72338_b - 2.0, box.field_72339_c - 5.0, box.field_72336_d + 5.0, box.field_72337_e + 2.0, box.field_72334_f + 5.0) : box;
    }

    public static class AICharge
    extends EntityAIBase {
        protected EntityHoundeye entity;

        public AICharge(EntityHoundeye entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null && target.func_70089_S() && this.entity.charge == 0 && this.entity.func_70635_at().func_75522_a((Entity)target) && this.entity.flee == 0) {
                return (double)this.entity.func_70032_d((Entity)target) <= 3.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            EntityLivingBase target = this.entity.func_70638_az();
            return target != null && target.func_70089_S() && this.entity.charge != 0 && this.entity.flee == 0;
        }

        public void func_75249_e() {
            this.entity.charge = 50;
            LambdaNetworks.network.sendToAllTracking((IMessage)new MessageHoundeye(this.entity, MessageHoundeye.EHoundeyeAction.START_CHARGE, 50), (Entity)this.entity);
        }

        public void func_75251_c() {
            this.entity.charge = 0;
            LambdaNetworks.network.sendToAllTracking((IMessage)new MessageHoundeye(this.entity, MessageHoundeye.EHoundeyeAction.CHARGE, 0), (Entity)this.entity);
        }
    }

    public static class AIFollow
    extends EntityAIBase {
        protected EntityHoundeye entity;

        public AIFollow(EntityHoundeye entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null && target.func_70089_S() && this.entity.charge == 0 && this.entity.flee == 0) {
                return (double)this.entity.func_70032_d((Entity)target) > 3.0 || !this.entity.func_70635_at().func_75522_a((Entity)target);
            }
            return false;
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), 1.0);
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 30.0f, 30.0f);
        }
    }

    public static class AIFlee
    extends EntityAIBase {
        protected EntityHoundeye entity;

        public AIFlee(EntityHoundeye entity) {
            this.entity = entity;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70643_av();
            return target != null && target.func_70089_S() && this.entity.flee > 0;
        }

        public void func_75249_e() {
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.entity.func_70661_as().func_75499_g();
            this.entity.flee = 0;
        }

        public void func_75246_d() {
            if (this.entity.func_70661_as().func_75500_f()) {
                EntityLivingBase target = this.entity.func_70643_av();
                Vec3d position = RandomPositionGenerator.func_75461_b((EntityCreature)this.entity, (int)3, (int)2, (Vec3d)new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v));
                if (position != null) {
                    this.entity.func_70661_as().func_75492_a(position.field_72450_a, position.field_72448_b, position.field_72449_c, 1.0);
                }
            }
        }
    }
}

