/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.alien;

import java.util.Iterator;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntitySnark
extends EntityMob {
    public EntityLivingBase owner;
    public static final int life = 400;
    public static final String keyLife = "life";
    public static final String keyOwner = "owner";

    public EntitySnark(World world) {
        super(world);
        this.func_70105_a(0.35f, 0.35f);
    }

    public void fire(EntityLivingBase entity, double speed) {
        this.owner = entity;
        this.fire(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - 0.2, entity.field_70161_v, entity.func_70040_Z(), speed);
    }

    public void fire(double x, double y, double z, Vec3d direction, double speed) {
        this.func_70107_b(x, y, z);
        Vec3d motion = direction.func_72432_b().func_186678_a(speed);
        this.field_70159_w = motion.field_72450_a;
        this.field_70181_x = motion.field_72448_b;
        this.field_70179_y = motion.field_72449_c;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AILeapAtTarget((EntityLiving)this, 0.5f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6, 4));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, true, false, LambdaSelectors.SNARK_TARGETS));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.field_70173_aa % (this.field_70146_Z.nextInt(10) + 15) == 0) {
            this.func_184185_a(LambdaSounds.alien_snark_hunt, this.func_70599_aP(), this.func_70647_i() + (float)this.field_70173_aa / 800.0f);
        }
        if (this.field_70173_aa >= 400) {
            this.explode();
        }
    }

    protected void explode() {
        this.func_70106_y();
        this.func_184185_a(this.func_184615_bR(), 1.0f, 1.0f);
        this.func_184185_a(LambdaSounds.alien_snark_blast, 1.0f, 1.0f);
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            Vec3d position = this.func_174791_d();
            Iterator iterator = this.field_70170_p.func_175647_a(EntityLivingBase.class, LambdaUtilities.createAABB(position.func_178786_a(2.0, 2.0, 2.0), position.func_72441_c(2.0, 2.0, 2.0)), LambdaSelectors.SNARK_TARGETS).iterator();
            while (iterator.hasNext()) {
                ((EntityLivingBase)iterator.next()).func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.owner), 1.0f);
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.explode();
    }

    public boolean func_70652_k(Entity entity) {
        int burn;
        this.func_184185_a(LambdaSounds.alien_snark_deploy, 1.0f, 1.0f);
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entity instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (!entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.owner), damage)) {
            return false;
        }
        if (knockback > 0 && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70653_a((Entity)this, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            this.field_70159_w *= 0.6;
            this.field_70179_y *= 0.6;
        }
        if ((burn = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
            entity.func_70015_d(burn * 4);
        }
        if (entity instanceof EntityPlayer) {
            ItemStack stack1;
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack stack = this.func_184614_ca();
            ItemStack itemStack = stack1 = player.func_184587_cr() ? player.func_184607_cu() : ItemStack.field_190927_a;
            if (!stack.func_190926_b() && !stack1.func_190926_b() && stack.func_77973_b().canDisableShield(stack, stack1, (EntityLivingBase)player, (EntityLivingBase)this) && stack1.func_77973_b().isShield(stack1, (EntityLivingBase)player)) {
                float efficiency = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                if (this.field_70146_Z.nextFloat() < efficiency) {
                    player.func_184811_cZ().func_185145_a(stack1.func_77973_b(), 100);
                    this.field_70170_p.func_72960_a((Entity)player, (byte)30);
                }
            }
        }
        this.func_174815_a((EntityLivingBase)this, entity);
        return true;
    }

    public SoundEvent func_184615_bR() {
        return LambdaSounds.alien_snark_die;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a(keyLife, this.field_70173_aa);
        if (this.owner != null) {
            nbt.func_186854_a(keyOwner, this.owner.func_110124_au());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70173_aa = nbt.func_74762_e(keyLife);
        if (nbt.func_74764_b(keyOwner)) {
            this.owner = (EntityLivingBase)((WorldServer)this.field_70170_p).func_175733_a(nbt.func_186857_a(keyOwner));
        }
    }

    public static class AILeapAtTarget
    extends EntityAIBase {
        EntityLiving leaper;
        EntityLivingBase leapTarget;
        float motion;

        public AILeapAtTarget(EntityLiving leaper, float motion) {
            this.leaper = leaper;
            this.motion = motion;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.leapTarget = this.leaper.func_70638_az();
            if (this.leapTarget == null) {
                return false;
            }
            double distance = this.leaper.func_70068_e((Entity)this.leapTarget);
            if (distance >= 0.0 && distance <= 9.0) {
                if (!this.leaper.field_70122_E) {
                    return false;
                }
                return this.leaper.func_70681_au().nextInt(4) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return !this.leaper.field_70122_E;
        }

        public void func_75249_e() {
            double deltaX = this.leapTarget.field_70165_t - this.leaper.field_70165_t;
            double deltaZ = this.leapTarget.field_70161_v - this.leaper.field_70161_v;
            float length = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            if ((double)length >= 1.0E-4) {
                this.leaper.field_70159_w += deltaX / (double)length * 0.6 * 0.8 + this.leaper.field_70159_w * 0.2;
                this.leaper.field_70179_y += deltaZ / (double)length * 0.6 * 0.8 + this.leaper.field_70179_y * 0.2;
            }
            this.leaper.field_70181_x = this.motion;
        }
    }
}

