/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.entity.projectile;

import com.google.common.base.Predicate;
import io.netty.util.internal.ThreadLocalRandom;
import melonslise.lambda.common.entity.api.AEntityProjectile;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaSelectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityBullet
extends AEntityProjectile {
    protected float damage = 2.0f;
    protected int soundChance;
    public static final String keyDamage = "damage";

    public EntityBullet(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityBullet(World world, float damage, int soundChance) {
        this(world);
        this.damage = damage;
        this.soundChance = soundChance;
    }

    protected void func_70088_a() {
    }

    @Override
    protected void onHit(RayTraceResult result) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (result.field_72308_g != null) {
            if (result.field_72308_g.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.owner), this.damage)) {
                result.field_72308_g.field_70172_ad = 0;
            }
            if (this.soundChance <= 1 || random.nextInt(this.soundChance) == 0) {
                this.func_184185_a(this.getHitBodySound(), 1.0f, 1.0f);
            }
            this.func_70106_y();
        } else if (result.func_178782_a() != null) {
            if (this.getPenetratedBlocks().apply((Object)this.field_70170_p.func_180495_p(result.func_178782_a()))) {
                this.field_70170_p.func_175655_b(result.func_178782_a(), false);
            } else {
                if (this.soundChance <= 1 || random.nextInt(this.soundChance) == 0) {
                    this.func_184185_a(this.getHitSound(), 1.0f, 1.0f);
                }
                this.func_70106_y();
            }
        }
    }

    @Override
    protected Predicate<IBlockState> getPenetratedBlocks() {
        return LambdaSelectors.SHATTERABLES;
    }

    @Override
    public double getWaterResistance() {
        return 0.95;
    }

    @Override
    public double getGravity() {
        return 0.0;
    }

    public SoundEvent getHitBodySound() {
        return LambdaSounds.projectile_bullet_hitbody;
    }

    public SoundEvent getHitSound() {
        return LambdaSounds.projectile_bullet_ricochet;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a(keyDamage, this.damage);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.damage = nbt.func_74760_g(keyDamage);
    }
}

