/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.api;

import java.util.List;
import javax.annotation.Nullable;
import melonslise.lambda.common.item.api.AItemUsable;
import melonslise.lambda.common.item.api.ISuitDisplayProvider;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AItemLoadable
extends AItemUsable
implements ISuitDisplayProvider {
    protected final int size;
    public static final String keyMagazine = "magazine";

    public AItemLoadable(String name, int size) {
        super(name);
        this.size = size;
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (this.getMagazine(stack) <= 0) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getDryFireSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (this.getMagazine(stack) <= 0) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getDryFireSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return false;
    }

    protected int getMagazine(ItemStack stack) {
        return LambdaUtilities.getTag(stack).func_74762_e(keyMagazine);
    }

    protected void setMagazine(ItemStack stack, int amount) {
        LambdaUtilities.getTag(stack).func_74768_a(keyMagazine, MathHelper.func_76125_a((int)amount, (int)0, (int)this.size));
    }

    protected boolean consumeMagazine(ItemStack stack, int amount) {
        int magazine = this.getMagazine(stack);
        this.setMagazine(stack, magazine - amount);
        return magazine >= amount;
    }

    protected void restoreMagazine(ItemStack stack, int amount) {
        this.setMagazine(stack, this.getMagazine(stack) + amount);
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            SuitRenderUtilities.renderAmmo(event.getResolution(), color, Integer.toString(this.getMagazine(stack)), 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(this.getMagazine(stack) + " / " + this.size);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            this.setMagazine(stack, this.size);
            stacks.add((Object)stack);
        }
    }

    protected SoundEvent getDryFireSound() {
        return LambdaSounds.weapon_dryfire;
    }
}

