/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import melonslise.lambda.common.item.api.AItemLoadable;
import melonslise.lambda.common.item.api.IItemReloadable;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public abstract class AItemReloadable
extends AItemLoadable
implements IItemReloadable {
    protected final Item ammo;

    public AItemReloadable(String name, int size, Item ammo) {
        super(name, size);
        this.ammo = ammo;
    }

    public Item getAmmo() {
        return this.ammo;
    }

    @Override
    public int onStartReloading(EntityPlayer player, EnumHand hand, ItemStack stack) {
        int time = this.getReloadTime(player, hand, stack);
        if (time <= 0 || this.getMagazine(stack) >= this.size || !LambdaUtilities.hasItem(player, this.ammo)) {
            return 0;
        }
        player.func_184811_cZ().func_185145_a((Item)this, time);
        this.setUser(stack, (Entity)player);
        return time;
    }

    @Override
    public void onUpdateReloading(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
    }

    @Override
    public void onStopReloading(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.func_184811_cZ().func_185145_a((Item)this, 0);
        this.setUser(stack, null);
        if (ticks == 0) {
            ArrayList<ItemStack> ammos;
            if (player.func_184812_l_()) {
                this.setMagazine(stack, this.size);
                return;
            }
            int magazine = this.getMagazine(stack);
            if (magazine < this.size && !(ammos = LambdaUtilities.findStacks((Collection<ItemStack>)player.field_71069_bz.func_75138_a(), this.ammo)).isEmpty()) {
                Iterator<ItemStack> iterator = ammos.iterator();
                while (iterator.hasNext() && magazine < this.size) {
                    int refill = this.size - magazine;
                    ItemStack ammo = iterator.next();
                    if (refill >= ammo.func_190916_E()) {
                        refill = ammo.func_190916_E();
                    }
                    magazine += refill;
                    ammo.func_190920_e(ammo.func_190916_E() - refill);
                }
                this.setMagazine(stack, magazine);
            }
        }
    }

    public int getReloadTime(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return 0;
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int total = LambdaUtilities.getStackTotal(LambdaUtilities.findStacks((Collection<ItemStack>)Minecraft.func_71410_x().field_71439_g.field_71069_bz.func_75138_a(), this.ammo));
            SuitRenderUtilities.renderAmmo(event.getResolution(), color, this.getMagazine(stack) + " | " + total, 0);
        }
    }
}

