/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import melonslise.lambda.common.entity.projectile.EntityHornet;
import melonslise.lambda.common.item.api.AItemLoadable;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemHivehand
extends AItemLoadable {
    public ItemHivehand(String name, int size) {
        super(name, size);
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && entity.field_70173_aa % 10 == 0) {
            this.restoreMagazine(stack, 1);
        }
    }

    protected boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int cooldown, boolean homing) {
        if (LambdaUtilities.getReloading((Entity)player).get() || this.getMagazine(stack) <= 0 || this.getCooldown(stack) > 0) {
            return false;
        }
        this.consumeMagazine(stack, ammo);
        this.setCooldown(stack, cooldown);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_hivehand_shot, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityHornet hornet = new EntityHornet(player.field_70170_p, homing);
        hornet.fire((EntityLivingBase)player, hand, 0.8, 0.0f);
        player.field_70170_p.func_72838_d((Entity)hornet);
        return true;
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 1, 5, true);
        }
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return true;
    }

    @Override
    protected void secondaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 1, 2, false);
        }
    }

    @Override
    protected SoundEvent getDryFireSound() {
        return null;
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        super.renderDisplay(event, color, stack, hand);
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 0, 48);
        }
    }
}

