/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import java.util.Collection;
import melonslise.lambda.common.entity.projectile.EntityRocket;
import melonslise.lambda.common.item.api.AItemUsable;
import melonslise.lambda.common.item.api.ISuitDisplayProvider;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemRPG
extends AItemUsable
implements ISuitDisplayProvider {
    protected Item ammo;
    public static final String keyMode = "mode";

    public ItemRPG(String name, Item ammo) {
        super(name);
        this.ammo = ammo;
    }

    public boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int cooldown) {
        if (player.func_70055_a(Material.field_151586_h) || this.getCooldown(stack) > 0 || !LambdaUtilities.consumeItem(player, this.ammo, ammo)) {
            return false;
        }
        this.setCooldown(stack, cooldown);
        EntityRocket rocket = new EntityRocket(player.field_70170_p, this.getMode(stack));
        rocket.fire((EntityLivingBase)player, hand, 2.0, 0.0f);
        player.field_70170_p.func_72838_d((Entity)rocket);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_rpg_shot, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 1, 40);
        }
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            this.toggleMode(player.func_184586_b(hand));
        }
        return false;
    }

    public Item getAmmo() {
        return this.ammo;
    }

    protected boolean getMode(ItemStack stack) {
        return LambdaUtilities.getTag(stack).func_74767_n(keyMode);
    }

    protected void setMode(ItemStack stack, boolean mode) {
        LambdaUtilities.getTag(stack).func_74757_a(keyMode, mode);
    }

    protected void toggleMode(ItemStack stack) {
        NBTTagCompound nbt;
        nbt.func_74757_a(keyMode, !(nbt = LambdaUtilities.getTag(stack)).func_74767_n(keyMode));
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 24, 24);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int total = LambdaUtilities.getStackTotal(LambdaUtilities.findStacks((Collection<ItemStack>)Minecraft.func_71410_x().field_71439_g.field_71069_bz.func_75138_a(), this.ammo));
            SuitRenderUtilities.renderAmmo(event.getResolution(), color, Integer.toString(total), 0);
        }
    }
}

