/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import melonslise.lambda.common.entity.projectile.EntityBullet;
import melonslise.lambda.common.item.api.AItemReloadable;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemRevolver
extends AItemReloadable {
    public ItemRevolver(String name, int size, Item ammo) {
        super(name, size, ammo);
    }

    public boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int cooldown) {
        if (player.func_70055_a(Material.field_151586_h) || LambdaUtilities.getReloading((Entity)player).get() || this.getMagazine(stack) <= 0 || this.getCooldown(stack) > 0) {
            return false;
        }
        this.consumeMagazine(stack, ammo);
        this.setCooldown(stack, cooldown);
        EntityBullet bullet = new EntityBullet(player.field_70170_p, 11.0f, 1);
        bullet.fire((EntityLivingBase)player, hand, 4.0, (float)Math.PI / 180);
        player.field_70170_p.func_72838_d((Entity)bullet);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_python_shot, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        super.startSecondaryUsing(player, hand, stack);
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 1, 15);
        }
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return false;
    }

    @Override
    public void onStopReloading(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        super.onStopReloading(player, hand, stack, ticks);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_python_load, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public int getReloadTime(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return 15;
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        super.renderDisplay(event, color, stack, hand);
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 24, 0);
        }
    }
}

