/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import java.util.Collection;
import melonslise.lambda.common.entity.projectile.EntityBullet;
import melonslise.lambda.common.entity.projectile.EntityImpactGrenade;
import melonslise.lambda.common.item.api.AItemReloadable;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemSMG
extends AItemReloadable {
    protected final Item grenadeAmmo;

    public ItemSMG(String name, int size, Item ammo, Item grenadeAmmo) {
        super(name, size, ammo);
        this.grenadeAmmo = grenadeAmmo;
    }

    public boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int cooldown) {
        if (player.func_70055_a(Material.field_151586_h) || LambdaUtilities.getReloading((Entity)player).get() || this.getMagazine(stack) <= 0 || this.getCooldown(stack) > 0) {
            return false;
        }
        this.consumeMagazine(stack, ammo);
        this.setCooldown(stack, cooldown);
        EntityBullet bullet = new EntityBullet(player.field_70170_p, 2.0f, 2);
        bullet.fire((EntityLivingBase)player, hand, 4.0, 0.05235988f);
        player.field_70170_p.func_72838_d((Entity)bullet);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_mp_shot, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    public boolean fireGrenade(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int cooldown) {
        if (player.func_70055_a(Material.field_151586_h) || LambdaUtilities.getReloading((Entity)player).get() || !LambdaUtilities.consumeItem(player, this.grenadeAmmo, ammo) || !this.resetCooldown(stack, cooldown)) {
            return false;
        }
        EntityImpactGrenade grenade = new EntityImpactGrenade(player.field_70170_p);
        grenade.fire((EntityLivingBase)player, hand, 1.0, 0.0f);
        player.field_70170_p.func_72838_d((Entity)grenade);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_mp_grenade, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        super.startPrimaryUsing(player, hand, stack);
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fire(player, hand, stack, 1, 2);
        }
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!LambdaUtilities.hasItem(player, this.grenadeAmmo)) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.getDryFireSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected void secondaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            this.fireGrenade(player, hand, stack, 1, 20);
        }
    }

    public Item getGrenadeAmmo() {
        return this.ammo;
    }

    @Override
    public int onStartReloading(EntityPlayer player, EnumHand hand, ItemStack stack) {
        int time = super.onStartReloading(player, hand, stack);
        if (time > 0) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_mp_unload, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return time;
    }

    @Override
    public void onStopReloading(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        super.onStopReloading(player, hand, stack, ticks);
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_mp_load, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public int getReloadTime(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return 15;
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        super.renderDisplay(event, color, stack, hand);
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 48, 0);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int total = LambdaUtilities.getStackTotal(LambdaUtilities.findStacks((Collection<ItemStack>)Minecraft.func_71410_x().field_71439_g.field_71069_bz.func_75138_a(), this.grenadeAmmo));
            SuitRenderUtilities.renderAmmo(event.getResolution(), color, Integer.toString(total), 1);
        }
    }
}

