/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.item.weapon;

import melonslise.lambda.common.entity.projectile.EntityBullet;
import melonslise.lambda.common.item.api.AItemReloadable;
import melonslise.lambda.common.sound.LambdaSounds;
import melonslise.lambda.utility.LambdaUtilities;
import melonslise.lambda.utility.SuitRenderUtilities;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemShotgun
extends AItemReloadable {
    public ItemShotgun(String name, int size, Item ammo) {
        super(name, size, ammo);
    }

    public boolean fire(EntityPlayer player, EnumHand hand, ItemStack stack, int ammo, int cooldown) {
        if (player.func_70055_a(Material.field_151586_h) || LambdaUtilities.getReloading((Entity)player).get() || this.getMagazine(stack) <= 0 || this.getCooldown(stack) > 0) {
            return false;
        }
        this.consumeMagazine(stack, ammo);
        this.setCooldown(stack, cooldown);
        for (int a = 0; a < ammo * 6; ++a) {
            EntityBullet bullet = new EntityBullet(player.field_70170_p, 2.5f, ammo * 3);
            bullet.fire((EntityLivingBase)player, hand, 4.0, 0.06981317f * ((float)ammo + 1.0f));
            player.field_70170_p.func_72838_d((Entity)bullet);
        }
        return true;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!selected && player.func_184592_cb() != stack || LambdaUtilities.getReloading(entity).get() || this.getCooldown(stack) != 8) {
            return;
        }
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, LambdaSounds.weapon_spas_cock, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    protected boolean startPrimaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        super.startPrimaryUsing(player, hand, stack);
        return true;
    }

    @Override
    protected void primaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K && this.fire(player, hand, stack, 1, 15)) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_spas_shot_singlebarrel, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean startSecondaryUsing(EntityPlayer player, EnumHand hand, ItemStack stack) {
        super.startSecondaryUsing(player, hand, stack);
        return true;
    }

    @Override
    protected void secondaryUsingTick(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (!player.field_70170_p.field_72995_K && this.fire(player, hand, stack, 2, 25)) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_spas_shot_doublebarrel, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void onUpdateReloading(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        if (player.field_70170_p.field_72995_K || ticks % 10 != 9) {
            return;
        }
        if (this.getMagazine(stack) < this.size && LambdaUtilities.consumeItem(player, this.ammo, 1)) {
            this.restoreMagazine(stack, 1);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_spas_load, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void onStopReloading(EntityPlayer player, EnumHand hand, ItemStack stack, int ticks) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, LambdaSounds.weapon_spas_cock, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public int getReloadTime(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return (this.size - this.getMagazine(stack)) * 10 + 5;
    }

    @Override
    public void renderDisplay(RenderGameOverlayEvent.Pre event, int color, ItemStack stack, EnumHand hand) {
        super.renderDisplay(event, color, stack, hand);
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            SuitRenderUtilities.renderCrosshair(event.getResolution(), color, 72, 0);
        }
    }
}

