/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.network.message.client;

import io.netty.buffer.ByteBuf;
import melonslise.lambda.common.block.api.ITileUsable;
import melonslise.lambda.common.capability.entity.ICapabilityUsingTile;
import melonslise.lambda.common.network.message.server.ServerMessageUseTile;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientMessageUseTile
extends ServerMessageUseTile {
    private int id;

    public ClientMessageUseTile() {
    }

    public ClientMessageUseTile(Entity entity, boolean state, int type, BlockPos position, EnumFacing side, Vec3d hit) {
        super(state, type, position, side, hit);
        this.id = entity.func_145782_y();
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.id = buffer.readInt();
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.id);
    }

    public int getEntityID() {
        return this.id;
    }

    public Entity getEntity(World world) {
        return world.func_73045_a(this.id);
    }

    public static class Handler
    implements IMessageHandler<ClientMessageUseTile, IMessage> {
        public IMessage onMessage(final ClientMessageUseTile message, MessageContext context) {
            final Minecraft mc = Minecraft.func_71410_x();
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    Entity entity = message.getEntity((World)mc.field_71441_e);
                    if (entity != null && mc.field_71441_e.func_175667_e(message.getPosition()) && mc.field_71441_e.func_180495_p(message.getPosition()).func_177230_c() instanceof ITileUsable) {
                        ICapabilityUsingTile using = LambdaUtilities.getUsingTile(entity);
                        if (message.getState()) {
                            using.startUsing(message.getPosition(), message.getSide(), message.getHit(), message.getType());
                        } else {
                            using.stopUsing(message.getSide(), message.getHit(), message.getType());
                        }
                    }
                }
            };
            mc.func_152344_a(action);
            return null;
        }
    }
}

