/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.common.network.message.server;

import io.netty.buffer.ByteBuf;
import melonslise.lambda.common.block.api.ITileUsable;
import melonslise.lambda.common.capability.entity.ICapabilityUsingTile;
import melonslise.lambda.common.network.message.api.AMessageUse;
import melonslise.lambda.utility.LambdaUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerMessageUseTile
extends AMessageUse {
    private BlockPos position;
    private EnumFacing side;
    private Vec3d hit;

    public ServerMessageUseTile() {
    }

    public ServerMessageUseTile(boolean state, int type, BlockPos position, EnumFacing side, Vec3d hit) {
        super(state, type);
        this.position = position;
        this.side = side;
        this.hit = hit;
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.position = new BlockPos(LambdaUtilities.readIntegerVector(buffer));
        this.side = LambdaUtilities.readEnum(buffer, EnumFacing.class);
        this.hit = LambdaUtilities.readFloatVector(buffer);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        LambdaUtilities.writeIntegerVector(buffer, (Vec3i)this.position);
        LambdaUtilities.writeEnum(buffer, this.side);
        LambdaUtilities.writeFloatVector(buffer, this.hit);
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public Vec3d getHit() {
        return this.hit;
    }

    public static class Handler
    implements IMessageHandler<ServerMessageUseTile, IMessage> {
        public IMessage onMessage(final ServerMessageUseTile message, MessageContext context) {
            final EntityPlayerMP player = context.getServerHandler().field_147369_b;
            Runnable action = new Runnable(){

                @Override
                public void run() {
                    if (player.field_70170_p.func_175667_e(message.position) && player.field_70170_p.func_180495_p(message.position).func_177230_c() instanceof ITileUsable) {
                        ICapabilityUsingTile using = LambdaUtilities.getUsingTile((Entity)player);
                        if (message.getState()) {
                            using.startUsing(message.position, message.side, message.hit, message.getType());
                        } else {
                            using.stopUsing(message.side, message.hit, message.getType());
                        }
                    }
                }
            };
            player.func_71121_q().func_152344_a(action);
            return null;
        }
    }
}

