/*
 * Decompiled with CFR 0.152.
 */
package melonslise.lambda.utility;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import melonslise.lambda.common.capability.LambdaCapabilities;
import melonslise.lambda.common.capability.entity.ICapabilityPower;
import melonslise.lambda.common.capability.entity.ICapabilityReloading;
import melonslise.lambda.common.capability.entity.ICapabilityRemoteCharges;
import melonslise.lambda.common.capability.entity.ICapabilityUsingItem;
import melonslise.lambda.common.capability.entity.ICapabilityUsingTile;
import melonslise.lambda.common.capability.entity.ICapabilityZooming;
import melonslise.lambda.common.item.LambdaItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class LambdaUtilities {
    private LambdaUtilities() {
    }

    public static Vec3d rotateVector(Vec3d point, float yaw, float pitch) {
        return point.func_178789_a(-pitch / 180.0f * (float)Math.PI).func_178785_b(-yaw / 180.0f * (float)Math.PI);
    }

    public static Vec3d sampleSphereCap(Vec3d coneAxis, float angle) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Vec3d axis = Math.abs(coneAxis.field_72450_a) < Math.abs(coneAxis.field_72448_b) ? (Math.abs(coneAxis.field_72450_a) < Math.abs(coneAxis.field_72449_c) ? new Vec3d(1.0, 0.0, 0.0) : new Vec3d(0.0, 0.0, 1.0)) : (Math.abs(coneAxis.field_72448_b) < Math.abs(coneAxis.field_72449_c) ? new Vec3d(0.0, 1.0, 0.0) : new Vec3d(0.0, 0.0, 1.0));
        Vec3d u = coneAxis.func_72431_c(axis);
        Vec3d v = coneAxis.func_72431_c(u);
        float phi = random.nextFloat() * 2.0f * (float)Math.PI;
        float theta = (float)Math.acos(random.nextDouble(MathHelper.func_76134_b((float)angle), 1.0));
        return coneAxis.func_186678_a((double)MathHelper.func_76134_b((float)theta)).func_178787_e(u.func_186678_a((double)(MathHelper.func_76134_b((float)phi) * MathHelper.func_76126_a((float)theta)))).func_178787_e(v.func_186678_a((double)(MathHelper.func_76126_a((float)phi) * MathHelper.func_76126_a((float)theta))));
    }

    public static String prefixLambda(String path) {
        return String.join((CharSequence)".", "lambda", path);
    }

    public static ResourceLocation createLambdaDomain(String path) {
        return new ResourceLocation("lambda", path);
    }

    public static Collection subtract(Collection minuend, Collection subtrahend) {
        minuend.removeAll(subtrahend);
        return minuend;
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void sendToAllTrackingAndPlayer(EntityPlayerMP player, SimpleNetworkWrapper network, IMessage message) {
        network.sendToAllTracking(message, (Entity)player);
        network.sendTo(message, player);
    }

    public static Vec3d readFloatVector(ByteBuf buffer) {
        return new Vec3d((double)buffer.readFloat(), (double)buffer.readFloat(), (double)buffer.readFloat());
    }

    public static void writeFloatVector(ByteBuf buffer, Vec3d vector) {
        buffer.writeFloat((float)vector.field_72450_a);
        buffer.writeFloat((float)vector.field_72448_b);
        buffer.writeFloat((float)vector.field_72449_c);
    }

    public static Vec3i readIntegerVector(ByteBuf buffer) {
        return new Vec3i(buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static void writeIntegerVector(ByteBuf buffer, Vec3i vector) {
        buffer.writeInt(vector.func_177958_n());
        buffer.writeInt(vector.func_177956_o());
        buffer.writeInt(vector.func_177952_p());
    }

    public static Vec3i readShortVector(ByteBuf buffer) {
        return new Vec3i((int)buffer.readShort(), (int)buffer.readShort(), (int)buffer.readShort());
    }

    public static void writeShortVector(ByteBuf buffer, Vec3i vector) {
        buffer.writeShort((int)((short)vector.func_177958_n()));
        buffer.writeShort((int)((short)vector.func_177956_o()));
        buffer.writeShort((int)((short)vector.func_177952_p()));
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buffer, Class<T> c) {
        return (T)((Enum[])c.getEnumConstants())[buffer.readShort()];
    }

    public static void writeEnum(ByteBuf buffer, Enum<?> value) {
        buffer.writeShort((int)((short)value.ordinal()));
    }

    public static ICapabilityPower getPower(Entity entity) {
        return (ICapabilityPower)entity.getCapability(LambdaCapabilities.power, null);
    }

    public static ICapabilityUsingItem getUsingItem(Entity entity) {
        return (ICapabilityUsingItem)entity.getCapability(LambdaCapabilities.usingItem, null);
    }

    public static ICapabilityUsingTile getUsingTile(Entity entity) {
        return (ICapabilityUsingTile)entity.getCapability(LambdaCapabilities.usingTile, null);
    }

    public static ICapabilityReloading getReloading(Entity entity) {
        return (ICapabilityReloading)entity.getCapability(LambdaCapabilities.reloading, null);
    }

    public static ICapabilityZooming getZooming(Entity entity) {
        return (ICapabilityZooming)entity.getCapability(LambdaCapabilities.zooming, null);
    }

    public static ICapabilityRemoteCharges getRemoteCharges(Entity entity) {
        return (ICapabilityRemoteCharges)entity.getCapability(LambdaCapabilities.remoteCharges, null);
    }

    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean tagHasKey(ItemStack stack, String key) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(key);
    }

    public static int getStackTotal(Collection<ItemStack> stacks) {
        int total = 0;
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            total += iterator.next().func_190916_E();
        }
        return total;
    }

    public static ArrayList<ItemStack> findStacks(Collection<ItemStack> stacks, Item item) {
        ArrayList<ItemStack> matching = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.func_77973_b() != item) continue;
            matching.add(stack);
        }
        return matching;
    }

    public static int getMagazine(ItemStack stack) {
        return LambdaUtilities.tagHasKey(stack, "magazine") ? stack.func_77978_p().func_74762_e("magazine") : -1;
    }

    public static ItemStack createEgg(ResourceLocation entityID) {
        ItemStack egg = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)egg, (ResourceLocation)entityID);
        return egg;
    }

    public static boolean hasBadPotionEffect(EntityLivingBase entity) {
        Iterator iterator = entity.func_70651_bq().iterator();
        while (iterator.hasNext()) {
            if (!((PotionEffect)iterator.next()).func_188419_a().func_76398_f()) continue;
            return true;
        }
        return false;
    }

    public static void rotateTowardsMotion(Entity entity, float speed) {
        float horizontalMotion = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
        entity.field_70177_z = (float)(MathHelper.func_181159_b((double)entity.field_70159_w, (double)entity.field_70179_y) * 57.29577951308232);
        entity.field_70125_A = (float)(MathHelper.func_181159_b((double)entity.field_70181_x, (double)horizontalMotion) * 57.29577951308232);
        while (entity.field_70125_A - entity.field_70127_C < -180.0f) {
            entity.field_70127_C -= 360.0f;
        }
        while (entity.field_70125_A - entity.field_70127_C >= 180.0f) {
            entity.field_70127_C += 360.0f;
        }
        while (entity.field_70177_z - entity.field_70126_B < -180.0f) {
            entity.field_70126_B -= 360.0f;
        }
        while (entity.field_70177_z - entity.field_70126_B >= 180.0f) {
            entity.field_70126_B += 360.0f;
        }
        entity.field_70125_A = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * speed;
        entity.field_70177_z = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * speed;
    }

    public static EnumHandSide getHandSide(EntityLivingBase entity, EnumHand hand) {
        return LambdaUtilities.getHandSide(entity.func_184591_cq(), hand);
    }

    public static EnumHandSide getHandSide(EnumHandSide primarySide, EnumHand hand) {
        return hand == EnumHand.MAIN_HAND && primarySide == EnumHandSide.RIGHT || hand == EnumHand.OFF_HAND && primarySide == EnumHandSide.LEFT ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
    }

    public static Vec3d getHeldOffset(EntityLivingBase entity, EnumHand hand, Vec3d point) {
        if (LambdaUtilities.getHandSide(entity, hand) == EnumHandSide.LEFT) {
            point = new Vec3d(point.field_72450_a * -1.0, point.field_72448_b, point.field_72449_c);
        }
        return LambdaUtilities.rotateVector(point, entity.field_70177_z, entity.field_70125_A);
    }

    public static boolean hasItem(EntityPlayer player, Item item) {
        return player.func_184812_l_() || !LambdaUtilities.findStacks((Collection<ItemStack>)player.field_71069_bz.func_75138_a(), item).isEmpty();
    }

    public static boolean consumeItem(EntityPlayer player, Item item, int amount) {
        if (amount <= 0 || player.func_184812_l_()) {
            return true;
        }
        ArrayList<ItemStack> stacks = LambdaUtilities.findStacks((Collection<ItemStack>)player.field_71069_bz.func_75138_a(), item);
        if (LambdaUtilities.getStackTotal(stacks) < amount) {
            return false;
        }
        Iterator<ItemStack> iterator = stacks.iterator();
        while (amount > 0 && iterator.hasNext()) {
            ItemStack stack = iterator.next();
            int size = stack.func_190916_E();
            stack.func_190918_g(amount);
            amount -= size;
        }
        return amount <= 0;
    }

    public static boolean isContinuous(DamageSource source, EntityLivingBase entity) {
        return source == DamageSource.field_76369_e || source.func_76347_k() && entity.func_70027_ad() || source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || source == DamageSource.field_76367_g || source == DamageSource.field_82727_n || source == DamageSource.field_188407_q || source == DamageSource.field_76376_m && LambdaUtilities.hasBadPotionEffect(entity);
    }

    public static boolean isArmorSlot(EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.HEAD || slot == EntityEquipmentSlot.CHEST || slot == EntityEquipmentSlot.LEGS || slot == EntityEquipmentSlot.FEET;
    }

    public static boolean isWearingHazard(EntityLivingBase entity) {
        return entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == LambdaItems.suit_hazard_head && entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == LambdaItems.suit_hazard_chest && entity.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == LambdaItems.suit_hazard_legs && entity.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == LambdaItems.suit_hazard_boots;
    }

    public static AxisAlignedBB createAABB(Vec3d start, Vec3d end) {
        return new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c);
    }

    public static Vec3d getCenter(AxisAlignedBB box) {
        return new Vec3d(box.field_72340_a * 0.5 + box.field_72336_d * 0.5, box.field_72338_b * 0.5 + box.field_72337_e * 0.5, box.field_72339_c * 0.5 + box.field_72334_f * 0.5);
    }

    public static ArrayList<RayTraceResult> rayTraceBlocks(World world, Vec3d start, Vec3d end, boolean checkLiquids, boolean checkBounds, Predicate<IBlockState> ignoredBlocks) {
        RayTraceResult result;
        Vec3d line = end.func_178788_d(start);
        int x = (int)Math.floor(start.field_72450_a);
        int y = (int)Math.floor(start.field_72448_b);
        int z = (int)Math.floor(start.field_72449_c);
        int lastX = (int)Math.floor(end.field_72450_a);
        int lastY = (int)Math.floor(end.field_72448_b);
        int lastZ = (int)Math.floor(end.field_72449_c);
        Vec3i step = new Vec3i((int)Math.signum(line.field_72450_a), (int)Math.signum(line.field_72448_b), (int)Math.signum(line.field_72449_c));
        Vec3d delta = new Vec3d(1.0 / line.field_72450_a * (double)step.func_177958_n(), 1.0 / line.field_72448_b * (double)step.func_177956_o(), 1.0 / line.field_72449_c * (double)step.func_177952_p());
        double tMaxX = ((double)x + (step.func_177958_n() < 0 ? 0.0 : 1.0) - start.field_72450_a) / line.field_72450_a;
        double tMaxY = ((double)y + (step.func_177956_o() < 0 ? 0.0 : 1.0) - start.field_72448_b) / line.field_72448_b;
        double tMaxZ = ((double)z + (step.func_177952_p() < 0 ? 0.0 : 1.0) - start.field_72449_c) / line.field_72449_c;
        ArrayList results = Lists.newArrayList();
        BlockPos position = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(position);
        if ((!checkBounds || state.func_185890_d((IBlockAccess)world, position) != Block.field_185506_k) && state.func_177230_c().func_176209_a(state, checkLiquids) && (result = state.func_185910_a(world, position, start, end)) != null) {
            results.add(result);
            if (ignoredBlocks == null || !ignoredBlocks.apply((Object)state)) {
                return results;
            }
        }
        while (x != lastX || y != lastY || z != lastZ) {
            if (tMaxX < tMaxY) {
                if (tMaxX < tMaxZ) {
                    x += step.func_177958_n();
                    tMaxX += delta.field_72450_a;
                } else {
                    z += step.func_177952_p();
                    tMaxZ += delta.field_72449_c;
                }
            } else if (tMaxY < tMaxZ) {
                y += step.func_177956_o();
                tMaxY += delta.field_72448_b;
            } else {
                z += step.func_177952_p();
                tMaxZ += delta.field_72449_c;
            }
            position = new BlockPos(x, y, z);
            state = world.func_180495_p(position);
            if (checkBounds && state.func_185890_d((IBlockAccess)world, position) == Block.field_185506_k || !state.func_177230_c().func_176209_a(state, checkLiquids) || (result = state.func_185910_a(world, position, start, end)) == null) continue;
            results.add(result);
            if (ignoredBlocks != null && ignoredBlocks.apply((Object)state)) continue;
            return results;
        }
        return results;
    }

    public static RayTraceResult rayTraceBlocks(Entity entity, double length, boolean checkLiquids, boolean checkBounds) {
        return entity.field_70170_p.func_147447_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), entity.func_70040_Z().func_186678_a(length).func_72441_c(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), checkLiquids, checkBounds, false);
    }

    public static ArrayList<RayTraceResult> rayTraceEntities(World world, Vec3d start, Vec3d end, Collection<Entity> ignore, Predicate<Entity> filter) {
        ArrayList results = Lists.newArrayList();
        for (Entity entity : LambdaUtilities.subtract(world.func_72839_b(null, LambdaUtilities.createAABB(start, end).func_186662_g(1.0)), ignore)) {
            AxisAlignedBB box;
            RayTraceResult result1;
            if (!entity.func_70067_L() || entity.field_70145_X || filter != null && !filter.apply((Object)entity) || (result1 = (box = entity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null) continue;
            results.add(new RayTraceResult(entity, result1.field_72307_f));
        }
        return results;
    }

    public static RayTraceResult rayTraceClosestEntity(World world, Vec3d start, Vec3d end, Collection<Entity> ignore, Predicate<Entity> filter) {
        RayTraceResult result = null;
        Iterator iterator = LambdaUtilities.subtract(world.func_72839_b(null, LambdaUtilities.createAABB(start, end).func_186662_g(1.0)), ignore).iterator();
        double distanceMinimum = 0.0;
        while (iterator.hasNext()) {
            AxisAlignedBB box;
            RayTraceResult result1;
            Entity entity = (Entity)iterator.next();
            if (!entity.func_70067_L() || entity.field_70145_X || filter != null && !filter.apply((Object)entity) || (result1 = (box = entity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(start, end)) == null) continue;
            double distance = start.func_72436_e(result1.field_72307_f);
            if (distanceMinimum != 0.0 && !(distance < distanceMinimum)) continue;
            result = new RayTraceResult(entity, result1.field_72307_f);
            distanceMinimum = distance;
        }
        return result;
    }

    public static RayTraceResult getClosestIntersectedEntity(Vec3d start, Collection<RayTraceResult> entities, Predicate<Entity> filter) {
        RayTraceResult result = null;
        Iterator<RayTraceResult> iterator = entities.iterator();
        double distanceMinimum = 0.0;
        while (iterator.hasNext()) {
            RayTraceResult result1 = iterator.next();
            if (filter != null && !filter.apply((Object)result1.field_72308_g)) continue;
            double distance = start.func_72436_e(result1.field_72307_f);
            if (distanceMinimum != 0.0 && !(distance < distanceMinimum)) continue;
            result = result1;
            distanceMinimum = distance;
        }
        return result;
    }

    public static Entity getClosestEntity(Vec3d start, Collection<Entity> entities, Predicate<Entity> filter) {
        Entity target = null;
        double distanceMinimum = 0.0;
        for (Entity entity : entities) {
            if (filter != null && !filter.apply((Object)entity)) continue;
            double distance = entity.func_70092_e(start.field_72450_a, start.field_72448_b, start.field_72449_c);
            if (distanceMinimum != 0.0 && !(distance < distanceMinimum)) continue;
            target = entity;
            distanceMinimum = distance;
        }
        return target;
    }

    public static BlockPos getFirstBlockInDirection(World world, BlockPos start, EnumFacing direction, Predicate<IBlockState> condition, int range) {
        BlockPos end = start;
        for (int a = 0; a < range; ++a) {
            if (!condition.apply((Object)world.func_180495_p(end = end.func_177972_a(direction)))) continue;
            return end;
        }
        return end;
    }

    public static Vec3d getRenderOrigin(float partialTick) {
        Minecraft mc = Minecraft.func_71410_x();
        return new Vec3d(mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTick, mc.field_71439_g.field_70137_T + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70137_T) * (double)partialTick, mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTick);
    }

    public static void drawFlatQuad(Vec3d start, Vec3d end, double width, int color, boolean stretch, float partialTick) {
        Vec3d origin = LambdaUtilities.getRenderOrigin(partialTick);
        Vec3d camera = origin.func_72441_c(0.0, (double)Minecraft.func_71410_x().field_71439_g.func_70047_e(), 0.0);
        Vec3d delta = end.func_178788_d(start);
        Vec3d direction = delta.func_72432_b();
        Vec3d startUp = direction.func_72431_c(start.func_178788_d(camera)).func_72432_b().func_186678_a(width);
        Vec3d endUp = direction.func_72431_c(end.func_178788_d(camera)).func_72432_b().func_186678_a(width);
        float red = LambdaUtilities.getRed(color);
        float green = LambdaUtilities.getGreen(color);
        float blue = LambdaUtilities.getBlue(color);
        float alpha = LambdaUtilities.getAlpha(color);
        double length = stretch ? 1.0 : delta.func_72433_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(start.field_72450_a + startUp.field_72450_a - origin.field_72450_a, start.field_72448_b + startUp.field_72448_b - origin.field_72448_b, start.field_72449_c + startUp.field_72449_c - origin.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(start.field_72450_a - startUp.field_72450_a - origin.field_72450_a, start.field_72448_b - startUp.field_72448_b - origin.field_72448_b, start.field_72449_c - startUp.field_72449_c - origin.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(end.field_72450_a - endUp.field_72450_a - origin.field_72450_a, end.field_72448_b - endUp.field_72448_b - origin.field_72448_b, end.field_72449_c - endUp.field_72449_c - origin.field_72449_c).func_187315_a(1.0, length).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(end.field_72450_a + endUp.field_72450_a - origin.field_72450_a, end.field_72448_b + endUp.field_72448_b - origin.field_72448_b, end.field_72449_c + endUp.field_72449_c - origin.field_72449_c).func_187315_a(0.0, length).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void RenderItem(ModelResourceLocation resource, ItemStack stack) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(resource);
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
        GlStateManager.func_179121_F();
    }
}

